/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.extranet.booking.model.CountryLightweightSupplierDetails;
import travel.wink.sdk.extranet.booking.model.GeoJsonPointSupplierDetails;
import travel.wink.sdk.extranet.booking.model.SubCountryLightweightSupplierDetails;
import travel.wink.sdk.extranet.booking.model.SubSubCountryLightweightSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoNames have been created at [https://geonames.org](https://geonames.org) and contain geographical destinations we use as geoname data to associate travel inventory with a location.
 */
@JsonPropertyOrder({
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_GEO_NAME_ID,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_TYPE,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_NAME,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_URL_NAME,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_ASCII_NAME,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_LOCATION,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_FEATURE_CODE,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_COUNTRY_CODE,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_TIMEZONE,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_COUNTRY,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_SUB_COUNTRY,
  GeoNameLightweightSupplierDetails.JSON_PROPERTY_SUB_SUB_COUNTRY
})
@JsonTypeName("GeoNameLightweight_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:17:36.846722567+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class GeoNameLightweightSupplierDetails {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  @jakarta.annotation.Nullable
  private String geoNameId;

  /**
   * GeoNameLightweight type
   */
  public enum TypeEnum {
    CITY(String.valueOf("CITY")),
    
    ISLAND(String.valueOf("ISLAND")),
    
    OTHER(String.valueOf("OTHER"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nullable
  private TypeEnum type;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  @jakarta.annotation.Nullable
  private String urlName;

  public static final String JSON_PROPERTY_ASCII_NAME = "asciiName";
  @jakarta.annotation.Nullable
  private String asciiName;

  public static final String JSON_PROPERTY_LOCATION = "location";
  @jakarta.annotation.Nullable
  private GeoJsonPointSupplierDetails location;

  public static final String JSON_PROPERTY_FEATURE_CODE = "featureCode";
  @jakarta.annotation.Nullable
  private String featureCode;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  @jakarta.annotation.Nullable
  private String countryCode;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  @jakarta.annotation.Nullable
  private String timezone;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private CountryLightweightSupplierDetails country;

  public static final String JSON_PROPERTY_SUB_COUNTRY = "subCountry";
  @jakarta.annotation.Nullable
  private SubCountryLightweightSupplierDetails subCountry;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY = "subSubCountry";
  @jakarta.annotation.Nullable
  private SubSubCountryLightweightSupplierDetails subSubCountry;

  public GeoNameLightweightSupplierDetails() {
  }

  public GeoNameLightweightSupplierDetails geoNameId(@jakarta.annotation.Nullable String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

  /**
   * GeoName identifier
   * @return geoNameId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(@jakarta.annotation.Nullable String geoNameId) {
    this.geoNameId = geoNameId;
  }

  public GeoNameLightweightSupplierDetails type(@jakarta.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * GeoNameLightweight type
   * @return type
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@jakarta.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  public GeoNameLightweightSupplierDetails name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of city
   * @return name
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public GeoNameLightweightSupplierDetails urlName(@jakarta.annotation.Nullable String urlName) {
    
    this.urlName = urlName;
    return this;
  }

  /**
   * Url name
   * @return urlName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(@jakarta.annotation.Nullable String urlName) {
    this.urlName = urlName;
  }

  public GeoNameLightweightSupplierDetails asciiName(@jakarta.annotation.Nullable String asciiName) {
    
    this.asciiName = asciiName;
    return this;
  }

  /**
   * Ascii name of city
   * @return asciiName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsciiName() {
    return asciiName;
  }


  @JsonProperty(JSON_PROPERTY_ASCII_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsciiName(@jakarta.annotation.Nullable String asciiName) {
    this.asciiName = asciiName;
  }

  public GeoNameLightweightSupplierDetails location(@jakarta.annotation.Nullable GeoJsonPointSupplierDetails location) {
    
    this.location = location;
    return this;
  }

  /**
   * Coordinate points of the city
   * @return location
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointSupplierDetails getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(@jakarta.annotation.Nullable GeoJsonPointSupplierDetails location) {
    this.location = location;
  }

  public GeoNameLightweightSupplierDetails featureCode(@jakarta.annotation.Nullable String featureCode) {
    
    this.featureCode = featureCode;
    return this;
  }

  /**
   * Get featureCode
   * @return featureCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFeatureCode() {
    return featureCode;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatureCode(@jakarta.annotation.Nullable String featureCode) {
    this.featureCode = featureCode;
  }

  public GeoNameLightweightSupplierDetails countryCode(@jakarta.annotation.Nullable String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Get countryCode
   * @return countryCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(@jakarta.annotation.Nullable String countryCode) {
    this.countryCode = countryCode;
  }

  public GeoNameLightweightSupplierDetails timezone(@jakarta.annotation.Nullable String timezone) {
    
    this.timezone = timezone;
    return this;
  }

  /**
   * Timezone
   * @return timezone
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(@jakarta.annotation.Nullable String timezone) {
    this.timezone = timezone;
  }

  public GeoNameLightweightSupplierDetails country(@jakarta.annotation.Nullable CountryLightweightSupplierDetails country) {
    
    this.country = country;
    return this;
  }

  /**
   * Country
   * @return country
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CountryLightweightSupplierDetails getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(@jakarta.annotation.Nullable CountryLightweightSupplierDetails country) {
    this.country = country;
  }

  public GeoNameLightweightSupplierDetails subCountry(@jakarta.annotation.Nullable SubCountryLightweightSupplierDetails subCountry) {
    
    this.subCountry = subCountry;
    return this;
  }

  /**
   * Country sub division
   * @return subCountry
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubCountryLightweightSupplierDetails getSubCountry() {
    return subCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountry(@jakarta.annotation.Nullable SubCountryLightweightSupplierDetails subCountry) {
    this.subCountry = subCountry;
  }

  public GeoNameLightweightSupplierDetails subSubCountry(@jakarta.annotation.Nullable SubSubCountryLightweightSupplierDetails subSubCountry) {
    
    this.subSubCountry = subSubCountry;
    return this;
  }

  /**
   * Country sub sub division
   * @return subSubCountry
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubSubCountryLightweightSupplierDetails getSubSubCountry() {
    return subSubCountry;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountry(@jakarta.annotation.Nullable SubSubCountryLightweightSupplierDetails subSubCountry) {
    this.subSubCountry = subSubCountry;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoNameLightweightSupplierDetails geoNameLightweightSupplierDetails = (GeoNameLightweightSupplierDetails) o;
    return Objects.equals(this.geoNameId, geoNameLightweightSupplierDetails.geoNameId) &&
        Objects.equals(this.type, geoNameLightweightSupplierDetails.type) &&
        Objects.equals(this.name, geoNameLightweightSupplierDetails.name) &&
        Objects.equals(this.urlName, geoNameLightweightSupplierDetails.urlName) &&
        Objects.equals(this.asciiName, geoNameLightweightSupplierDetails.asciiName) &&
        Objects.equals(this.location, geoNameLightweightSupplierDetails.location) &&
        Objects.equals(this.featureCode, geoNameLightweightSupplierDetails.featureCode) &&
        Objects.equals(this.countryCode, geoNameLightweightSupplierDetails.countryCode) &&
        Objects.equals(this.timezone, geoNameLightweightSupplierDetails.timezone) &&
        Objects.equals(this.country, geoNameLightweightSupplierDetails.country) &&
        Objects.equals(this.subCountry, geoNameLightweightSupplierDetails.subCountry) &&
        Objects.equals(this.subSubCountry, geoNameLightweightSupplierDetails.subSubCountry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, type, name, urlName, asciiName, location, featureCode, countryCode, timezone, country, subCountry, subSubCountry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoNameLightweightSupplierDetails {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    asciiName: ").append(toIndentedString(asciiName)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    featureCode: ").append(toIndentedString(featureCode)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    subCountry: ").append(toIndentedString(subCountry)).append("\n");
    sb.append("    subSubCountry: ").append(toIndentedString(subSubCountry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

