/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md   # Extranet Booking API The Booking API exposes endpoints to manage bookings. This API lets you:  1. Booking: Manage bookings including cancellations. 2. Review: Manage user reviews. 3. Sync w. Calendar: Manage calendar sync with your favorite calendar software  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.booking.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LocalizedDescriptionSupplier
 */
@JsonPropertyOrder({
  LocalizedDescriptionSupplier.JSON_PROPERTY_DESCRIPTION,
  LocalizedDescriptionSupplier.JSON_PROPERTY_LANGUAGE,
  LocalizedDescriptionSupplier.JSON_PROPERTY_CREATOR,
  LocalizedDescriptionSupplier.JSON_PROPERTY_MD5_CONTENT_HASH,
  LocalizedDescriptionSupplier.JSON_PROPERTY_HASH_MISMATCH
})
@JsonTypeName("LocalizedDescription_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:17:36.846722567+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class LocalizedDescriptionSupplier {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nonnull
  private String description;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @jakarta.annotation.Nonnull
  private String language = "en";

  /**
   * Whether it was user or system generated.
   */
  public enum CreatorEnum {
    SYSTEM(String.valueOf("SYSTEM")),
    
    USER(String.valueOf("USER"));

    private String value;

    CreatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CreatorEnum fromValue(String value) {
      for (CreatorEnum b : CreatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CREATOR = "creator";
  @jakarta.annotation.Nullable
  private CreatorEnum creator = CreatorEnum.USER;

  public static final String JSON_PROPERTY_MD5_CONTENT_HASH = "md5ContentHash";
  @jakarta.annotation.Nullable
  private String md5ContentHash;

  public static final String JSON_PROPERTY_HASH_MISMATCH = "hashMismatch";
  @jakarta.annotation.Nullable
  private Boolean hashMismatch;

  public LocalizedDescriptionSupplier() {
  }
  /**
   * Constructor with only readonly parameters
   */
  @JsonCreator
  public LocalizedDescriptionSupplier(
    @JsonProperty(JSON_PROPERTY_HASH_MISMATCH) Boolean hashMismatch
  ) {
    this();
    this.hashMismatch = hashMismatch;
  }

  public LocalizedDescriptionSupplier description(@jakarta.annotation.Nonnull String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Longer text description
   * @return description
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(@jakarta.annotation.Nonnull String description) {
    this.description = description;
  }

  public LocalizedDescriptionSupplier language(@jakarta.annotation.Nonnull String language) {
    
    this.language = language;
    return this;
  }

  /**
   * Indicate which language this description is written in.
   * @return language
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=2,max=2)
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLanguage(@jakarta.annotation.Nonnull String language) {
    this.language = language;
  }

  public LocalizedDescriptionSupplier creator(@jakarta.annotation.Nullable CreatorEnum creator) {
    
    this.creator = creator;
    return this;
  }

  /**
   * Whether it was user or system generated.
   * @return creator
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreatorEnum getCreator() {
    return creator;
  }


  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreator(@jakarta.annotation.Nullable CreatorEnum creator) {
    this.creator = creator;
  }

  public LocalizedDescriptionSupplier md5ContentHash(@jakarta.annotation.Nullable String md5ContentHash) {
    
    this.md5ContentHash = md5ContentHash;
    return this;
  }

  /**
   * The md5 hash of the name, description and language.
   * @return md5ContentHash
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MD5_CONTENT_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMd5ContentHash() {
    return md5ContentHash;
  }


  @JsonProperty(JSON_PROPERTY_MD5_CONTENT_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMd5ContentHash(@jakarta.annotation.Nullable String md5ContentHash) {
    this.md5ContentHash = md5ContentHash;
  }

  /**
   * Get hashMismatch
   * @return hashMismatch
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HASH_MISMATCH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHashMismatch() {
    return hashMismatch;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalizedDescriptionSupplier localizedDescriptionSupplier = (LocalizedDescriptionSupplier) o;
    return Objects.equals(this.description, localizedDescriptionSupplier.description) &&
        Objects.equals(this.language, localizedDescriptionSupplier.language) &&
        Objects.equals(this.creator, localizedDescriptionSupplier.creator) &&
        Objects.equals(this.md5ContentHash, localizedDescriptionSupplier.md5ContentHash) &&
        Objects.equals(this.hashMismatch, localizedDescriptionSupplier.hashMismatch);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, language, creator, md5ContentHash, hashMismatch);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalizedDescriptionSupplier {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    md5ContentHash: ").append(toIndentedString(md5ContentHash)).append("\n");
    sb.append("    hashMismatch: ").append(toIndentedString(hashMismatch)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

