/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.booking.invoker.ApiClient;
import travel.wink.sdk.extranet.booking.model.CalDavResponseSupplier;

public class CalendarSyncApi {
    private ApiClient apiClient;

    public CalendarSyncApi() {
        this(new ApiClient());
    }

    @Autowired
    public CalendarSyncApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec caldavRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling caldav", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(this){};
        return this.apiClient.invokeAPI("/api/cal/property/{propertyIdentifier}/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<String> caldav(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(this){};
        return this.caldavRequestCreation(propertyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<String>> caldavWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<String> localVarReturnType = new ParameterizedTypeReference<String>(this){};
        return this.caldavRequestCreation(propertyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec caldavWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.caldavRequestCreation(propertyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec generateCalDavAuthRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling generateCalDavAuth", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/caldav/auth/regen", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CalDavResponseSupplier> generateCalDavAuth(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.generateCalDavAuthRequestCreation(propertyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CalDavResponseSupplier>> generateCalDavAuthWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.generateCalDavAuthRequestCreation(propertyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec generateCalDavAuthWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.generateCalDavAuthRequestCreation(propertyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec retrieveCalDavAuthRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling retrieveCalDavAuth", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/caldav/auth", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CalDavResponseSupplier> retrieveCalDavAuth(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.retrieveCalDavAuthRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CalDavResponseSupplier>> retrieveCalDavAuthWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>(this){};
        return this.retrieveCalDavAuthRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec retrieveCalDavAuthWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.retrieveCalDavAuthRequestCreation(propertyIdentifier, winkVersion, accept);
    }
}

