/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.booking.invoker.ApiClient;
import travel.wink.sdk.extranet.booking.model.CountResponseSupplier;
import travel.wink.sdk.extranet.booking.model.PageReviewSupplier;
import travel.wink.sdk.extranet.booking.model.ReviewResponseSupplier;
import travel.wink.sdk.extranet.booking.model.ReviewSupplier;
import travel.wink.sdk.extranet.booking.model.StateSupplier;

public class ReviewApi {
    private ApiClient apiClient;

    public ReviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec respondToReviewRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nonnull ReviewResponseSupplier reviewResponseSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ReviewResponseSupplier postBody = reviewResponseSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewResponseSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewResponseSupplier' when calling respondToReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ReviewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/{reviewIdentifier}/response", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewSupplier> respondToReview(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nonnull ReviewResponseSupplier reviewResponseSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewSupplier>(this){};
        return this.respondToReviewRequestCreation(propertyIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewSupplier>> respondToReviewWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nonnull ReviewResponseSupplier reviewResponseSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewSupplier>(this){};
        return this.respondToReviewRequestCreation(propertyIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec respondToReviewWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nonnull ReviewResponseSupplier reviewResponseSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.respondToReviewRequestCreation(propertyIdentifier, reviewIdentifier, reviewResponseSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showReviewRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (reviewIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'reviewIdentifier' when calling showReview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("reviewIdentifier", reviewIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ReviewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/{reviewIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ReviewSupplier> showReview(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewSupplier>(this){};
        return this.showReviewRequestCreation(propertyIdentifier, reviewIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ReviewSupplier>> showReviewWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ReviewSupplier> localVarReturnType = new ParameterizedTypeReference<ReviewSupplier>(this){};
        return this.showReviewRequestCreation(propertyIdentifier, reviewIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showReviewWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String reviewIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showReviewRequestCreation(propertyIdentifier, reviewIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showReviewCountRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showReviewCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CountResponseSupplier> showReviewCount(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>(this){};
        return this.showReviewCountRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CountResponseSupplier>> showReviewCountWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CountResponseSupplier>(this){};
        return this.showReviewCountRequestCreation(propertyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showReviewCountWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showReviewCountRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showReviewsRequestCreation(@Nonnull String propertyIdentifier, @Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showReviews", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageReviewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/review/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageReviewSupplier> showReviews(@Nonnull String propertyIdentifier, @Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewSupplier>(this){};
        return this.showReviewsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageReviewSupplier>> showReviewsWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageReviewSupplier> localVarReturnType = new ParameterizedTypeReference<PageReviewSupplier>(this){};
        return this.showReviewsRequestCreation(propertyIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showReviewsWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull StateSupplier stateSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.showReviewsRequestCreation(propertyIdentifier, stateSupplier, winkVersion);
    }
}

