/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import travel.wink.sdk.extranet.booking.model.BeneficiarySupplier;
import travel.wink.sdk.extranet.booking.model.GuestUserSupplier;
import travel.wink.sdk.extranet.booking.model.SimpleDateTimeItinerarySupplier;
import travel.wink.sdk.extranet.booking.model.SupplierContractItemPolicySupplier;

@JsonPropertyOrder(value={"supplierItemBookingCode", "user", "nameInEnglish", "descriptionInEnglish", "itinerary", "pricingType", "type", "beneficiaryList", "payable", "policy", "externalIdentifier", "tokensEarned", "dailyRateList", "cancelled", "sourceCurrency", "displayCurrency", "supplierCurrency", "internalCurrency", "captureCurrency", "sourceAmount", "displayAmount", "supplierAmount", "internalAmount", "captureAmount", "sourceAmountRefundModifier", "displayAmountRefundModifier", "supplierAmountRefundModifier", "internalAmountRefundModifier", "captureAmountRefundModifier", "netSourceAmount", "netDisplayAmount", "netSupplierAmount", "netInternalAmount", "netCaptureAmount", "metadata", "cancellableByTraveler", "cancellableWithNoCharges", "cancellableWithPotentialCharges", "cancellableBySupplierOrAgent"})
@JsonTypeName(value="BookingContractItem_Supplier")
public class BookingContractItemSupplier {
    public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
    @Nonnull
    private String supplierItemBookingCode;
    public static final String JSON_PROPERTY_USER = "user";
    @Nonnull
    private GuestUserSupplier user;
    public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
    @Nonnull
    private String nameInEnglish;
    public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
    @Nonnull
    private String descriptionInEnglish;
    public static final String JSON_PROPERTY_ITINERARY = "itinerary";
    @Nonnull
    private SimpleDateTimeItinerarySupplier itinerary;
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    @Nonnull
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
    @Nonnull
    private List<@Valid BeneficiarySupplier> beneficiaryList = new ArrayList<BeneficiarySupplier>();
    public static final String JSON_PROPERTY_PAYABLE = "payable";
    @Nonnull
    private PayableEnum payable;
    public static final String JSON_PROPERTY_POLICY = "policy";
    @Nullable
    private SupplierContractItemPolicySupplier policy;
    public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
    @Nullable
    private String externalIdentifier;
    public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
    @Nullable
    private Long tokensEarned;
    public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
    @Nullable
    private List<Object> dailyRateList = new ArrayList<Object>();
    public static final String JSON_PROPERTY_CANCELLED = "cancelled";
    @Nullable
    private Boolean cancelled;
    public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
    @Nonnull
    private String sourceCurrency;
    public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
    @Nonnull
    private String displayCurrency;
    public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
    @Nonnull
    private String supplierCurrency;
    public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
    @Nonnull
    private String internalCurrency;
    public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
    @Nonnull
    private String captureCurrency;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
    @Nonnull
    private BigDecimal sourceAmount;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
    @Nonnull
    private BigDecimal displayAmount;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
    @Nonnull
    private BigDecimal supplierAmount;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
    @Nonnull
    private BigDecimal internalAmount;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
    @Nonnull
    private BigDecimal captureAmount;
    public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
    @Nullable
    private BigDecimal sourceAmountRefundModifier;
    public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
    @Nullable
    private BigDecimal displayAmountRefundModifier;
    public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
    @Nullable
    private BigDecimal supplierAmountRefundModifier;
    public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
    @Nullable
    private BigDecimal internalAmountRefundModifier;
    public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
    @Nullable
    private BigDecimal captureAmountRefundModifier;
    public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
    @Nonnull
    private BigDecimal netSourceAmount;
    public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
    @Nonnull
    private BigDecimal netDisplayAmount;
    public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
    @Nonnull
    private BigDecimal netSupplierAmount;
    public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
    @Nonnull
    private BigDecimal netInternalAmount;
    public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
    @Nonnull
    private BigDecimal netCaptureAmount;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    @Nullable
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
    @Nullable
    private Boolean cancellableByTraveler;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
    @Nullable
    private Boolean cancellableWithNoCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
    @Nullable
    private Boolean cancellableWithPotentialCharges;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER_OR_AGENT = "cancellableBySupplierOrAgent";
    @Nullable
    private Boolean cancellableBySupplierOrAgent;

    public BookingContractItemSupplier supplierItemBookingCode(@Nonnull String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getSupplierItemBookingCode() {
        return this.supplierItemBookingCode;
    }

    @JsonProperty(value="supplierItemBookingCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierItemBookingCode(@Nonnull String supplierItemBookingCode) {
        this.supplierItemBookingCode = supplierItemBookingCode;
    }

    public BookingContractItemSupplier user(@Nonnull GuestUserSupplier user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestUserSupplier getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(@Nonnull GuestUserSupplier user) {
        this.user = user;
    }

    public BookingContractItemSupplier nameInEnglish(@Nonnull String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getNameInEnglish() {
        return this.nameInEnglish;
    }

    @JsonProperty(value="nameInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNameInEnglish(@Nonnull String nameInEnglish) {
        this.nameInEnglish = nameInEnglish;
    }

    public BookingContractItemSupplier descriptionInEnglish(@Nonnull String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDescriptionInEnglish() {
        return this.descriptionInEnglish;
    }

    @JsonProperty(value="descriptionInEnglish")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptionInEnglish(@Nonnull String descriptionInEnglish) {
        this.descriptionInEnglish = descriptionInEnglish;
    }

    public BookingContractItemSupplier itinerary(@Nonnull SimpleDateTimeItinerarySupplier itinerary) {
        this.itinerary = itinerary;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SimpleDateTimeItinerarySupplier getItinerary() {
        return this.itinerary;
    }

    @JsonProperty(value="itinerary")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItinerary(@Nonnull SimpleDateTimeItinerarySupplier itinerary) {
        this.itinerary = itinerary;
    }

    public BookingContractItemSupplier pricingType(@Nonnull PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(@Nonnull PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public BookingContractItemSupplier type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public BookingContractItemSupplier beneficiaryList(@Nonnull List<@Valid BeneficiarySupplier> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
        return this;
    }

    public BookingContractItemSupplier addBeneficiaryListItem(BeneficiarySupplier beneficiaryListItem) {
        if (this.beneficiaryList == null) {
            this.beneficiaryList = new ArrayList<BeneficiarySupplier>();
        }
        this.beneficiaryList.add(beneficiaryListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid BeneficiarySupplier> getBeneficiaryList() {
        return this.beneficiaryList;
    }

    @JsonProperty(value="beneficiaryList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryList(@Nonnull List<@Valid BeneficiarySupplier> beneficiaryList) {
        this.beneficiaryList = beneficiaryList;
    }

    public BookingContractItemSupplier payable(@Nonnull PayableEnum payable) {
        this.payable = payable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PayableEnum getPayable() {
        return this.payable;
    }

    @JsonProperty(value="payable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPayable(@Nonnull PayableEnum payable) {
        this.payable = payable;
    }

    public BookingContractItemSupplier policy(@Nullable SupplierContractItemPolicySupplier policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SupplierContractItemPolicySupplier getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(@Nullable SupplierContractItemPolicySupplier policy) {
        this.policy = policy;
    }

    public BookingContractItemSupplier externalIdentifier(@Nullable String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    @JsonProperty(value="externalIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalIdentifier(@Nullable String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public BookingContractItemSupplier tokensEarned(@Nullable Long tokensEarned) {
        this.tokensEarned = tokensEarned;
        return this;
    }

    @Nullable
    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTokensEarned() {
        return this.tokensEarned;
    }

    @JsonProperty(value="tokensEarned")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokensEarned(@Nullable Long tokensEarned) {
        this.tokensEarned = tokensEarned;
    }

    public BookingContractItemSupplier dailyRateList(@Nullable List<Object> dailyRateList) {
        this.dailyRateList = dailyRateList;
        return this;
    }

    public BookingContractItemSupplier addDailyRateListItem(Object dailyRateListItem) {
        if (this.dailyRateList == null) {
            this.dailyRateList = new ArrayList<Object>();
        }
        this.dailyRateList.add(dailyRateListItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getDailyRateList() {
        return this.dailyRateList;
    }

    @JsonProperty(value="dailyRateList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDailyRateList(@Nullable List<Object> dailyRateList) {
        this.dailyRateList = dailyRateList;
    }

    public BookingContractItemSupplier cancelled(@Nullable Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancelled() {
        return this.cancelled;
    }

    @JsonProperty(value="cancelled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancelled(@Nullable Boolean cancelled) {
        this.cancelled = cancelled;
    }

    public BookingContractItemSupplier sourceCurrency(@Nonnull String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getSourceCurrency() {
        return this.sourceCurrency;
    }

    @JsonProperty(value="sourceCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceCurrency(@Nonnull String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public BookingContractItemSupplier displayCurrency(@Nonnull String displayCurrency) {
        this.displayCurrency = displayCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDisplayCurrency() {
        return this.displayCurrency;
    }

    @JsonProperty(value="displayCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayCurrency(@Nonnull String displayCurrency) {
        this.displayCurrency = displayCurrency;
    }

    public BookingContractItemSupplier supplierCurrency(@Nonnull String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getSupplierCurrency() {
        return this.supplierCurrency;
    }

    @JsonProperty(value="supplierCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierCurrency(@Nonnull String supplierCurrency) {
        this.supplierCurrency = supplierCurrency;
    }

    public BookingContractItemSupplier internalCurrency(@Nonnull String internalCurrency) {
        this.internalCurrency = internalCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getInternalCurrency() {
        return this.internalCurrency;
    }

    @JsonProperty(value="internalCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalCurrency(@Nonnull String internalCurrency) {
        this.internalCurrency = internalCurrency;
    }

    public BookingContractItemSupplier captureCurrency(@Nonnull String captureCurrency) {
        this.captureCurrency = captureCurrency;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getCaptureCurrency() {
        return this.captureCurrency;
    }

    @JsonProperty(value="captureCurrency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureCurrency(@Nonnull String captureCurrency) {
        this.captureCurrency = captureCurrency;
    }

    public BookingContractItemSupplier sourceAmount(@Nonnull BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSourceAmount() {
        return this.sourceAmount;
    }

    @JsonProperty(value="sourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAmount(@Nonnull BigDecimal sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public BookingContractItemSupplier displayAmount(@Nonnull BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getDisplayAmount() {
        return this.displayAmount;
    }

    @JsonProperty(value="displayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayAmount(@Nonnull BigDecimal displayAmount) {
        this.displayAmount = displayAmount;
    }

    public BookingContractItemSupplier supplierAmount(@Nonnull BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getSupplierAmount() {
        return this.supplierAmount;
    }

    @JsonProperty(value="supplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierAmount(@Nonnull BigDecimal supplierAmount) {
        this.supplierAmount = supplierAmount;
    }

    public BookingContractItemSupplier internalAmount(@Nonnull BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getInternalAmount() {
        return this.internalAmount;
    }

    @JsonProperty(value="internalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInternalAmount(@Nonnull BigDecimal internalAmount) {
        this.internalAmount = internalAmount;
    }

    public BookingContractItemSupplier captureAmount(@Nonnull BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getCaptureAmount() {
        return this.captureAmount;
    }

    @JsonProperty(value="captureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCaptureAmount(@Nonnull BigDecimal captureAmount) {
        this.captureAmount = captureAmount;
    }

    public BookingContractItemSupplier sourceAmountRefundModifier(@Nullable BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getSourceAmountRefundModifier() {
        return this.sourceAmountRefundModifier;
    }

    @JsonProperty(value="sourceAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAmountRefundModifier(@Nullable BigDecimal sourceAmountRefundModifier) {
        this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    }

    public BookingContractItemSupplier displayAmountRefundModifier(@Nullable BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getDisplayAmountRefundModifier() {
        return this.displayAmountRefundModifier;
    }

    @JsonProperty(value="displayAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayAmountRefundModifier(@Nullable BigDecimal displayAmountRefundModifier) {
        this.displayAmountRefundModifier = displayAmountRefundModifier;
    }

    public BookingContractItemSupplier supplierAmountRefundModifier(@Nullable BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getSupplierAmountRefundModifier() {
        return this.supplierAmountRefundModifier;
    }

    @JsonProperty(value="supplierAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupplierAmountRefundModifier(@Nullable BigDecimal supplierAmountRefundModifier) {
        this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    }

    public BookingContractItemSupplier internalAmountRefundModifier(@Nullable BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getInternalAmountRefundModifier() {
        return this.internalAmountRefundModifier;
    }

    @JsonProperty(value="internalAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAmountRefundModifier(@Nullable BigDecimal internalAmountRefundModifier) {
        this.internalAmountRefundModifier = internalAmountRefundModifier;
    }

    public BookingContractItemSupplier captureAmountRefundModifier(@Nullable BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
        return this;
    }

    @Nullable
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @DecimalMin(value="0") BigDecimal getCaptureAmountRefundModifier() {
        return this.captureAmountRefundModifier;
    }

    @JsonProperty(value="captureAmountRefundModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureAmountRefundModifier(@Nullable BigDecimal captureAmountRefundModifier) {
        this.captureAmountRefundModifier = captureAmountRefundModifier;
    }

    public BookingContractItemSupplier netSourceAmount(@Nonnull BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetSourceAmount() {
        return this.netSourceAmount;
    }

    @JsonProperty(value="netSourceAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetSourceAmount(@Nonnull BigDecimal netSourceAmount) {
        this.netSourceAmount = netSourceAmount;
    }

    public BookingContractItemSupplier netDisplayAmount(@Nonnull BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetDisplayAmount() {
        return this.netDisplayAmount;
    }

    @JsonProperty(value="netDisplayAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetDisplayAmount(@Nonnull BigDecimal netDisplayAmount) {
        this.netDisplayAmount = netDisplayAmount;
    }

    public BookingContractItemSupplier netSupplierAmount(@Nonnull BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetSupplierAmount() {
        return this.netSupplierAmount;
    }

    @JsonProperty(value="netSupplierAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetSupplierAmount(@Nonnull BigDecimal netSupplierAmount) {
        this.netSupplierAmount = netSupplierAmount;
    }

    public BookingContractItemSupplier netInternalAmount(@Nonnull BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetInternalAmount() {
        return this.netInternalAmount;
    }

    @JsonProperty(value="netInternalAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetInternalAmount(@Nonnull BigDecimal netInternalAmount) {
        this.netInternalAmount = netInternalAmount;
    }

    public BookingContractItemSupplier netCaptureAmount(@Nonnull BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @DecimalMin(value="0")
    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @DecimalMin(value="0") BigDecimal getNetCaptureAmount() {
        return this.netCaptureAmount;
    }

    @JsonProperty(value="netCaptureAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNetCaptureAmount(@Nonnull BigDecimal netCaptureAmount) {
        this.netCaptureAmount = netCaptureAmount;
    }

    public BookingContractItemSupplier metadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public BookingContractItemSupplier putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(@Nullable Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public BookingContractItemSupplier cancellableByTraveler(@Nullable Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByTraveler() {
        return this.cancellableByTraveler;
    }

    @JsonProperty(value="cancellableByTraveler")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByTraveler(@Nullable Boolean cancellableByTraveler) {
        this.cancellableByTraveler = cancellableByTraveler;
    }

    public BookingContractItemSupplier cancellableWithNoCharges(@Nullable Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithNoCharges() {
        return this.cancellableWithNoCharges;
    }

    @JsonProperty(value="cancellableWithNoCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithNoCharges(@Nullable Boolean cancellableWithNoCharges) {
        this.cancellableWithNoCharges = cancellableWithNoCharges;
    }

    public BookingContractItemSupplier cancellableWithPotentialCharges(@Nullable Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharges() {
        return this.cancellableWithPotentialCharges;
    }

    @JsonProperty(value="cancellableWithPotentialCharges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharges(@Nullable Boolean cancellableWithPotentialCharges) {
        this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    }

    public BookingContractItemSupplier cancellableBySupplierOrAgent(@Nullable Boolean cancellableBySupplierOrAgent) {
        this.cancellableBySupplierOrAgent = cancellableBySupplierOrAgent;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableBySupplierOrAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableBySupplierOrAgent() {
        return this.cancellableBySupplierOrAgent;
    }

    @JsonProperty(value="cancellableBySupplierOrAgent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableBySupplierOrAgent(@Nullable Boolean cancellableBySupplierOrAgent) {
        this.cancellableBySupplierOrAgent = cancellableBySupplierOrAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractItemSupplier bookingContractItemSupplier = (BookingContractItemSupplier)o;
        return Objects.equals(this.supplierItemBookingCode, bookingContractItemSupplier.supplierItemBookingCode) && Objects.equals(this.user, bookingContractItemSupplier.user) && Objects.equals(this.nameInEnglish, bookingContractItemSupplier.nameInEnglish) && Objects.equals(this.descriptionInEnglish, bookingContractItemSupplier.descriptionInEnglish) && Objects.equals(this.itinerary, bookingContractItemSupplier.itinerary) && Objects.equals((Object)this.pricingType, (Object)bookingContractItemSupplier.pricingType) && Objects.equals((Object)this.type, (Object)bookingContractItemSupplier.type) && Objects.equals(this.beneficiaryList, bookingContractItemSupplier.beneficiaryList) && Objects.equals((Object)this.payable, (Object)bookingContractItemSupplier.payable) && Objects.equals(this.policy, bookingContractItemSupplier.policy) && Objects.equals(this.externalIdentifier, bookingContractItemSupplier.externalIdentifier) && Objects.equals(this.tokensEarned, bookingContractItemSupplier.tokensEarned) && Objects.equals(this.dailyRateList, bookingContractItemSupplier.dailyRateList) && Objects.equals(this.cancelled, bookingContractItemSupplier.cancelled) && Objects.equals(this.sourceCurrency, bookingContractItemSupplier.sourceCurrency) && Objects.equals(this.displayCurrency, bookingContractItemSupplier.displayCurrency) && Objects.equals(this.supplierCurrency, bookingContractItemSupplier.supplierCurrency) && Objects.equals(this.internalCurrency, bookingContractItemSupplier.internalCurrency) && Objects.equals(this.captureCurrency, bookingContractItemSupplier.captureCurrency) && Objects.equals(this.sourceAmount, bookingContractItemSupplier.sourceAmount) && Objects.equals(this.displayAmount, bookingContractItemSupplier.displayAmount) && Objects.equals(this.supplierAmount, bookingContractItemSupplier.supplierAmount) && Objects.equals(this.internalAmount, bookingContractItemSupplier.internalAmount) && Objects.equals(this.captureAmount, bookingContractItemSupplier.captureAmount) && Objects.equals(this.sourceAmountRefundModifier, bookingContractItemSupplier.sourceAmountRefundModifier) && Objects.equals(this.displayAmountRefundModifier, bookingContractItemSupplier.displayAmountRefundModifier) && Objects.equals(this.supplierAmountRefundModifier, bookingContractItemSupplier.supplierAmountRefundModifier) && Objects.equals(this.internalAmountRefundModifier, bookingContractItemSupplier.internalAmountRefundModifier) && Objects.equals(this.captureAmountRefundModifier, bookingContractItemSupplier.captureAmountRefundModifier) && Objects.equals(this.netSourceAmount, bookingContractItemSupplier.netSourceAmount) && Objects.equals(this.netDisplayAmount, bookingContractItemSupplier.netDisplayAmount) && Objects.equals(this.netSupplierAmount, bookingContractItemSupplier.netSupplierAmount) && Objects.equals(this.netInternalAmount, bookingContractItemSupplier.netInternalAmount) && Objects.equals(this.netCaptureAmount, bookingContractItemSupplier.netCaptureAmount) && Objects.equals(this.metadata, bookingContractItemSupplier.metadata) && Objects.equals(this.cancellableByTraveler, bookingContractItemSupplier.cancellableByTraveler) && Objects.equals(this.cancellableWithNoCharges, bookingContractItemSupplier.cancellableWithNoCharges) && Objects.equals(this.cancellableWithPotentialCharges, bookingContractItemSupplier.cancellableWithPotentialCharges) && Objects.equals(this.cancellableBySupplierOrAgent, bookingContractItemSupplier.cancellableBySupplierOrAgent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.supplierItemBookingCode, this.user, this.nameInEnglish, this.descriptionInEnglish, this.itinerary, this.pricingType, this.type, this.beneficiaryList, this.payable, this.policy, this.externalIdentifier, this.tokensEarned, this.dailyRateList, this.cancelled, this.sourceCurrency, this.displayCurrency, this.supplierCurrency, this.internalCurrency, this.captureCurrency, this.sourceAmount, this.displayAmount, this.supplierAmount, this.internalAmount, this.captureAmount, this.sourceAmountRefundModifier, this.displayAmountRefundModifier, this.supplierAmountRefundModifier, this.internalAmountRefundModifier, this.captureAmountRefundModifier, this.netSourceAmount, this.netDisplayAmount, this.netSupplierAmount, this.netInternalAmount, this.netCaptureAmount, this.metadata, this.cancellableByTraveler, this.cancellableWithNoCharges, this.cancellableWithPotentialCharges, this.cancellableBySupplierOrAgent});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractItemSupplier {\n");
        sb.append("    supplierItemBookingCode: ").append(this.toIndentedString(this.supplierItemBookingCode)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    nameInEnglish: ").append(this.toIndentedString(this.nameInEnglish)).append("\n");
        sb.append("    descriptionInEnglish: ").append(this.toIndentedString(this.descriptionInEnglish)).append("\n");
        sb.append("    itinerary: ").append(this.toIndentedString(this.itinerary)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    beneficiaryList: ").append(this.toIndentedString(this.beneficiaryList)).append("\n");
        sb.append("    payable: ").append(this.toIndentedString((Object)this.payable)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    externalIdentifier: ").append(this.toIndentedString(this.externalIdentifier)).append("\n");
        sb.append("    tokensEarned: ").append(this.toIndentedString(this.tokensEarned)).append("\n");
        sb.append("    dailyRateList: ").append(this.toIndentedString(this.dailyRateList)).append("\n");
        sb.append("    cancelled: ").append(this.toIndentedString(this.cancelled)).append("\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    displayCurrency: ").append(this.toIndentedString(this.displayCurrency)).append("\n");
        sb.append("    supplierCurrency: ").append(this.toIndentedString(this.supplierCurrency)).append("\n");
        sb.append("    internalCurrency: ").append(this.toIndentedString(this.internalCurrency)).append("\n");
        sb.append("    captureCurrency: ").append(this.toIndentedString(this.captureCurrency)).append("\n");
        sb.append("    sourceAmount: ").append(this.toIndentedString(this.sourceAmount)).append("\n");
        sb.append("    displayAmount: ").append(this.toIndentedString(this.displayAmount)).append("\n");
        sb.append("    supplierAmount: ").append(this.toIndentedString(this.supplierAmount)).append("\n");
        sb.append("    internalAmount: ").append(this.toIndentedString(this.internalAmount)).append("\n");
        sb.append("    captureAmount: ").append(this.toIndentedString(this.captureAmount)).append("\n");
        sb.append("    sourceAmountRefundModifier: ").append(this.toIndentedString(this.sourceAmountRefundModifier)).append("\n");
        sb.append("    displayAmountRefundModifier: ").append(this.toIndentedString(this.displayAmountRefundModifier)).append("\n");
        sb.append("    supplierAmountRefundModifier: ").append(this.toIndentedString(this.supplierAmountRefundModifier)).append("\n");
        sb.append("    internalAmountRefundModifier: ").append(this.toIndentedString(this.internalAmountRefundModifier)).append("\n");
        sb.append("    captureAmountRefundModifier: ").append(this.toIndentedString(this.captureAmountRefundModifier)).append("\n");
        sb.append("    netSourceAmount: ").append(this.toIndentedString(this.netSourceAmount)).append("\n");
        sb.append("    netDisplayAmount: ").append(this.toIndentedString(this.netDisplayAmount)).append("\n");
        sb.append("    netSupplierAmount: ").append(this.toIndentedString(this.netSupplierAmount)).append("\n");
        sb.append("    netInternalAmount: ").append(this.toIndentedString(this.netInternalAmount)).append("\n");
        sb.append("    netCaptureAmount: ").append(this.toIndentedString(this.netCaptureAmount)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    cancellableByTraveler: ").append(this.toIndentedString(this.cancellableByTraveler)).append("\n");
        sb.append("    cancellableWithNoCharges: ").append(this.toIndentedString(this.cancellableWithNoCharges)).append("\n");
        sb.append("    cancellableWithPotentialCharges: ").append(this.toIndentedString(this.cancellableWithPotentialCharges)).append("\n");
        sb.append("    cancellableBySupplierOrAgent: ").append(this.toIndentedString(this.cancellableBySupplierOrAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        PER_STAY(String.valueOf("PER_STAY")),
        PER_DAY(String.valueOf("PER_DAY")),
        PER_NIGHT(String.valueOf("PER_NIGHT")),
        PER_USE(String.valueOf("PER_USE")),
        PER_HOUR(String.valueOf("PER_HOUR")),
        PER_PERSON(String.valueOf("PER_PERSON")),
        PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
        PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
        PER_ADULT(String.valueOf("PER_ADULT")),
        PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
        PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
        PER_CHILD(String.valueOf("PER_CHILD")),
        PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
        PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LODGING(String.valueOf("LODGING")),
        RAIL(String.valueOf("RAIL")),
        AIR(String.valueOf("AIR")),
        CAR(String.valueOf("CAR")),
        CRUISE(String.valueOf("CRUISE")),
        PACKAGE(String.valueOf("PACKAGE")),
        ADD_ON(String.valueOf("ADD_ON")),
        RENTAL(String.valueOf("RENTAL")),
        EXPERIENCE(String.valueOf("EXPERIENCE")),
        ANCILLARY_BOOKING(String.valueOf("ANCILLARY_BOOKING")),
        ANCILLARY_FEE(String.valueOf("ANCILLARY_FEE"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayableEnum {
        IMMEDIATE(String.valueOf("IMMEDIATE")),
        ARRIVAL(String.valueOf("ARRIVAL")),
        DEPARTURE(String.valueOf("DEPARTURE")),
        AGENT(String.valueOf("AGENT"));

        private String value;

        private PayableEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayableEnum fromValue(String value) {
            for (PayableEnum b : PayableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

