/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import travel.wink.sdk.extranet.booking.model.CustomMonetaryAmount;

@JsonPropertyOrder(value={"identifier", "acquirerRefundIdentifier", "requestedByIdentifier", "refund", "created", "description", "reasonType", "cancelOnRefund", "statusType", "requestType", "requestStatus", "requestResponse", "receiptUrl", "retries", "allocation"})
@JsonTypeName(value="Refund_SupplierDetails")
public class RefundSupplierDetails {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private String identifier;
    public static final String JSON_PROPERTY_ACQUIRER_REFUND_IDENTIFIER = "acquirerRefundIdentifier";
    @Nullable
    private String acquirerRefundIdentifier;
    public static final String JSON_PROPERTY_REQUESTED_BY_IDENTIFIER = "requestedByIdentifier";
    @Nullable
    private String requestedByIdentifier;
    public static final String JSON_PROPERTY_REFUND = "refund";
    @Nonnull
    private CustomMonetaryAmount refund;
    public static final String JSON_PROPERTY_CREATED = "created";
    @Nonnull
    private LocalDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_REASON_TYPE = "reasonType";
    @Nonnull
    private ReasonTypeEnum reasonType;
    public static final String JSON_PROPERTY_CANCEL_ON_REFUND = "cancelOnRefund";
    @Nonnull
    private CancelOnRefundEnum cancelOnRefund;
    public static final String JSON_PROPERTY_STATUS_TYPE = "statusType";
    @Nonnull
    private StatusTypeEnum statusType;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    @Nonnull
    private RequestTypeEnum requestType;
    public static final String JSON_PROPERTY_REQUEST_STATUS = "requestStatus";
    @Nonnull
    private RequestStatusEnum requestStatus;
    public static final String JSON_PROPERTY_REQUEST_RESPONSE = "requestResponse";
    @Nonnull
    private String requestResponse;
    public static final String JSON_PROPERTY_RECEIPT_URL = "receiptUrl";
    @Nullable
    private String receiptUrl;
    public static final String JSON_PROPERTY_RETRIES = "retries";
    @Nullable
    private Integer retries = 0;
    public static final String JSON_PROPERTY_ALLOCATION = "allocation";
    @Nullable
    private AllocationEnum allocation = AllocationEnum.EQUAL_DISTRIBUTION;

    public RefundSupplierDetails identifier(@Nonnull String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public RefundSupplierDetails acquirerRefundIdentifier(@Nullable String acquirerRefundIdentifier) {
        this.acquirerRefundIdentifier = acquirerRefundIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="acquirerRefundIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerRefundIdentifier() {
        return this.acquirerRefundIdentifier;
    }

    @JsonProperty(value="acquirerRefundIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerRefundIdentifier(@Nullable String acquirerRefundIdentifier) {
        this.acquirerRefundIdentifier = acquirerRefundIdentifier;
    }

    public RefundSupplierDetails requestedByIdentifier(@Nullable String requestedByIdentifier) {
        this.requestedByIdentifier = requestedByIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestedByIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestedByIdentifier() {
        return this.requestedByIdentifier;
    }

    @JsonProperty(value="requestedByIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestedByIdentifier(@Nullable String requestedByIdentifier) {
        this.requestedByIdentifier = requestedByIdentifier;
    }

    public RefundSupplierDetails refund(@Nonnull CustomMonetaryAmount refund) {
        this.refund = refund;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getRefund() {
        return this.refund;
    }

    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRefund(@Nonnull CustomMonetaryAmount refund) {
        this.refund = refund;
    }

    public RefundSupplierDetails created(@Nonnull LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreated(@Nonnull LocalDateTime created) {
        this.created = created;
    }

    public RefundSupplierDetails description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public RefundSupplierDetails reasonType(@Nonnull ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReasonTypeEnum getReasonType() {
        return this.reasonType;
    }

    @JsonProperty(value="reasonType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReasonType(@Nonnull ReasonTypeEnum reasonType) {
        this.reasonType = reasonType;
    }

    public RefundSupplierDetails cancelOnRefund(@Nonnull CancelOnRefundEnum cancelOnRefund) {
        this.cancelOnRefund = cancelOnRefund;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="cancelOnRefund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancelOnRefundEnum getCancelOnRefund() {
        return this.cancelOnRefund;
    }

    @JsonProperty(value="cancelOnRefund")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCancelOnRefund(@Nonnull CancelOnRefundEnum cancelOnRefund) {
        this.cancelOnRefund = cancelOnRefund;
    }

    public RefundSupplierDetails statusType(@Nonnull StatusTypeEnum statusType) {
        this.statusType = statusType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="statusType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusTypeEnum getStatusType() {
        return this.statusType;
    }

    @JsonProperty(value="statusType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatusType(@Nonnull StatusTypeEnum statusType) {
        this.statusType = statusType;
    }

    public RefundSupplierDetails requestType(@Nonnull RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestType(@Nonnull RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public RefundSupplierDetails requestStatus(@Nonnull RequestStatusEnum requestStatus) {
        this.requestStatus = requestStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="requestStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RequestStatusEnum getRequestStatus() {
        return this.requestStatus;
    }

    @JsonProperty(value="requestStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestStatus(@Nonnull RequestStatusEnum requestStatus) {
        this.requestStatus = requestStatus;
    }

    public RefundSupplierDetails requestResponse(@Nonnull String requestResponse) {
        this.requestResponse = requestResponse;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="requestResponse")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRequestResponse() {
        return this.requestResponse;
    }

    @JsonProperty(value="requestResponse")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestResponse(@Nonnull String requestResponse) {
        this.requestResponse = requestResponse;
    }

    public RefundSupplierDetails receiptUrl(@Nullable String receiptUrl) {
        this.receiptUrl = receiptUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="receiptUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    @JsonProperty(value="receiptUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiptUrl(@Nullable String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }

    public RefundSupplierDetails retries(@Nullable Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @JsonProperty(value="retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRetries(@Nullable Integer retries) {
        this.retries = retries;
    }

    public RefundSupplierDetails allocation(@Nullable AllocationEnum allocation) {
        this.allocation = allocation;
        return this;
    }

    @Nullable
    @JsonProperty(value="allocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AllocationEnum getAllocation() {
        return this.allocation;
    }

    @JsonProperty(value="allocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllocation(@Nullable AllocationEnum allocation) {
        this.allocation = allocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundSupplierDetails refundSupplierDetails = (RefundSupplierDetails)o;
        return Objects.equals(this.identifier, refundSupplierDetails.identifier) && Objects.equals(this.acquirerRefundIdentifier, refundSupplierDetails.acquirerRefundIdentifier) && Objects.equals(this.requestedByIdentifier, refundSupplierDetails.requestedByIdentifier) && Objects.equals(this.refund, refundSupplierDetails.refund) && Objects.equals(this.created, refundSupplierDetails.created) && Objects.equals(this.description, refundSupplierDetails.description) && Objects.equals((Object)this.reasonType, (Object)refundSupplierDetails.reasonType) && Objects.equals((Object)this.cancelOnRefund, (Object)refundSupplierDetails.cancelOnRefund) && Objects.equals((Object)this.statusType, (Object)refundSupplierDetails.statusType) && Objects.equals((Object)this.requestType, (Object)refundSupplierDetails.requestType) && Objects.equals((Object)this.requestStatus, (Object)refundSupplierDetails.requestStatus) && Objects.equals(this.requestResponse, refundSupplierDetails.requestResponse) && Objects.equals(this.receiptUrl, refundSupplierDetails.receiptUrl) && Objects.equals(this.retries, refundSupplierDetails.retries) && Objects.equals((Object)this.allocation, (Object)refundSupplierDetails.allocation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.acquirerRefundIdentifier, this.requestedByIdentifier, this.refund, this.created, this.description, this.reasonType, this.cancelOnRefund, this.statusType, this.requestType, this.requestStatus, this.requestResponse, this.receiptUrl, this.retries, this.allocation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundSupplierDetails {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    acquirerRefundIdentifier: ").append(this.toIndentedString(this.acquirerRefundIdentifier)).append("\n");
        sb.append("    requestedByIdentifier: ").append(this.toIndentedString(this.requestedByIdentifier)).append("\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reasonType: ").append(this.toIndentedString((Object)this.reasonType)).append("\n");
        sb.append("    cancelOnRefund: ").append(this.toIndentedString((Object)this.cancelOnRefund)).append("\n");
        sb.append("    statusType: ").append(this.toIndentedString((Object)this.statusType)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    requestStatus: ").append(this.toIndentedString((Object)this.requestStatus)).append("\n");
        sb.append("    requestResponse: ").append(this.toIndentedString(this.requestResponse)).append("\n");
        sb.append("    receiptUrl: ").append(this.toIndentedString(this.receiptUrl)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    allocation: ").append(this.toIndentedString((Object)this.allocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AllocationEnum {
        FROM_SALE_ONLY(String.valueOf("FROM_SALE_ONLY")),
        EQUAL_DISTRIBUTION(String.valueOf("EQUAL_DISTRIBUTION")),
        CUSTOMERS_ONLY(String.valueOf("CUSTOMERS_ONLY"));

        private String value;

        private AllocationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllocationEnum fromValue(String value) {
            for (AllocationEnum b : AllocationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReasonTypeEnum {
        DUPLICATE(String.valueOf("DUPLICATE")),
        FRAUDULENT(String.valueOf("FRAUDULENT")),
        REQUESTED_BY_CUSTOMER(String.valueOf("REQUESTED_BY_CUSTOMER")),
        GUEST_COMPLAINT(String.valueOf("GUEST_COMPLAINT")),
        GUEST_BOOKED_INCORRECT_DATE(String.valueOf("GUEST_BOOKED_INCORRECT_DATE")),
        GUEST_SICK(String.valueOf("GUEST_SICK")),
        OVERBOOKING(String.valueOf("OVERBOOKING")),
        EMERGENCY(String.valueOf("EMERGENCY")),
        FLIGHT_CANCELLED(String.valueOf("FLIGHT_CANCELLED")),
        DEATH_IN_FAMILY(String.valueOf("DEATH_IN_FAMILY")),
        OTHER(String.valueOf("OTHER")),
        EXPIRED_UNCAPTURED_CHARGE(String.valueOf("EXPIRED_UNCAPTURED_CHARGE"));

        private String value;

        private ReasonTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonTypeEnum fromValue(String value) {
            for (ReasonTypeEnum b : ReasonTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CancelOnRefundEnum {
        NONE(String.valueOf("NONE")),
        CANCEL_ON_SUCCESSFUL_REFUND(String.valueOf("CANCEL_ON_SUCCESSFUL_REFUND")),
        CANCEL_REGARDLESS(String.valueOf("CANCEL_REGARDLESS"));

        private String value;

        private CancelOnRefundEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CancelOnRefundEnum fromValue(String value) {
            for (CancelOnRefundEnum b : CancelOnRefundEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusTypeEnum {
        PENDING(String.valueOf("PENDING")),
        SUCCEEDED(String.valueOf("SUCCEEDED")),
        CANCELED(String.valueOf("CANCELED")),
        REQUIRES_ACTION(String.valueOf("REQUIRES_ACTION")),
        FAILED(String.valueOf("FAILED"));

        private String value;

        private StatusTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusTypeEnum fromValue(String value) {
            for (StatusTypeEnum b : StatusTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestTypeEnum {
        BY_SUPPLIER(String.valueOf("BY_SUPPLIER")),
        BY_ADMIN(String.valueOf("BY_ADMIN")),
        BY_STRIPE(String.valueOf("BY_STRIPE")),
        BY_SYSTEM(String.valueOf("BY_SYSTEM")),
        BY_AGENT(String.valueOf("BY_AGENT"));

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestStatusEnum {
        PENDING(String.valueOf("PENDING")),
        APPROVED(String.valueOf("APPROVED")),
        REJECTED(String.valueOf("REJECTED"));

        private String value;

        private RequestStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestStatusEnum fromValue(String value) {
            for (RequestStatusEnum b : RequestStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

