/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.booking.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.booking.model.BedroomConfigurationSupplier;
import travel.wink.sdk.extranet.booking.model.CancellationPolicyLightweightSupplier;
import travel.wink.sdk.extranet.booking.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.booking.model.ExtraChargesSupplier;
import travel.wink.sdk.extranet.booking.model.GuestRoomLightweightSupplier;
import travel.wink.sdk.extranet.booking.model.PerkLightweightSupplier;
import travel.wink.sdk.extranet.booking.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.booking.model.RoomConfigurationPriceRatePlanSupplier;
import travel.wink.sdk.extranet.booking.model.StayRateSupplier;

@JsonPropertyOrder(value={"policy", "room", "rooms", "bedroomConfiguration", "adults", "children", "startDate", "endDate", "price", "roomRateIdentifier", "roomRateInternalName", "ratePlan", "perkTypes", "extraCharges", "activeCancellationPolicy", "cancellable", "cancellableByHotel", "cancellableWithPotentialCharge", "roomNights", "guests", "rateSource", "sourceTotal", "userSpecifiedCurrencyTotal", "internalTotal"})
@JsonTypeName(value="RoomStay_Supplier")
public class RoomStaySupplier {
    public static final String JSON_PROPERTY_POLICY = "policy";
    @Nonnull
    private PropertyPolicySupplier policy;
    public static final String JSON_PROPERTY_ROOM = "room";
    @Nonnull
    private GuestRoomLightweightSupplier room;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    @Nonnull
    private Integer rooms = 1;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION = "bedroomConfiguration";
    @Nonnull
    private BedroomConfigurationSupplier bedroomConfiguration;
    public static final String JSON_PROPERTY_ADULTS = "adults";
    @Nonnull
    private Integer adults = 2;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nonnull
    private Integer children = 0;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    @Nonnull
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    @Nonnull
    private LocalDate endDate;
    public static final String JSON_PROPERTY_PRICE = "price";
    @Nonnull
    private StayRateSupplier price;
    public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
    @Nonnull
    private UUID roomRateIdentifier;
    public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
    @Nonnull
    private String roomRateInternalName;
    public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
    @Nonnull
    private RoomConfigurationPriceRatePlanSupplier ratePlan;
    public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
    @Nullable
    private List<@Valid PerkLightweightSupplier> perkTypes = new ArrayList<PerkLightweightSupplier>();
    public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
    @Nonnull
    private ExtraChargesSupplier extraCharges;
    public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
    @Nonnull
    private CancellationPolicyLightweightSupplier activeCancellationPolicy;
    public static final String JSON_PROPERTY_CANCELLABLE = "cancellable";
    @Nullable
    private Boolean cancellable;
    public static final String JSON_PROPERTY_CANCELLABLE_BY_HOTEL = "cancellableByHotel";
    @Nullable
    private Boolean cancellableByHotel;
    public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGE = "cancellableWithPotentialCharge";
    @Nullable
    private Boolean cancellableWithPotentialCharge;
    public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
    @Nullable
    private Long roomNights;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    @Nullable
    private Integer guests;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    @Nullable
    private String rateSource;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    @Nullable
    private CustomMonetaryAmount sourceTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    @Nullable
    private CustomMonetaryAmount userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    @Nullable
    private CustomMonetaryAmount internalTotal;

    public RoomStaySupplier policy(@Nonnull PropertyPolicySupplier policy) {
        this.policy = policy;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PropertyPolicySupplier getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPolicy(@Nonnull PropertyPolicySupplier policy) {
        this.policy = policy;
    }

    public RoomStaySupplier room(@Nonnull GuestRoomLightweightSupplier room) {
        this.room = room;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestRoomLightweightSupplier getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoom(@Nonnull GuestRoomLightweightSupplier room) {
        this.room = room;
    }

    public RoomStaySupplier rooms(@Nonnull Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRooms(@Nonnull Integer rooms) {
        this.rooms = rooms;
    }

    public RoomStaySupplier bedroomConfiguration(@Nonnull BedroomConfigurationSupplier bedroomConfiguration) {
        this.bedroomConfiguration = bedroomConfiguration;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="bedroomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BedroomConfigurationSupplier getBedroomConfiguration() {
        return this.bedroomConfiguration;
    }

    @JsonProperty(value="bedroomConfiguration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfiguration(@Nonnull BedroomConfigurationSupplier bedroomConfiguration) {
        this.bedroomConfiguration = bedroomConfiguration;
    }

    public RoomStaySupplier adults(@Nonnull Integer adults) {
        this.adults = adults;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAdults() {
        return this.adults;
    }

    @JsonProperty(value="adults")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdults(@Nonnull Integer adults) {
        this.adults = adults;
    }

    public RoomStaySupplier children(@Nonnull Integer children) {
        this.children = children;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChildren(@Nonnull Integer children) {
        this.children = children;
    }

    public RoomStaySupplier startDate(@Nonnull LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(@Nonnull LocalDate startDate) {
        this.startDate = startDate;
    }

    public RoomStaySupplier endDate(@Nonnull LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndDate(@Nonnull LocalDate endDate) {
        this.endDate = endDate;
    }

    public RoomStaySupplier price(@Nonnull StayRateSupplier price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StayRateSupplier getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(@Nonnull StayRateSupplier price) {
        this.price = price;
    }

    public RoomStaySupplier roomRateIdentifier(@Nonnull UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getRoomRateIdentifier() {
        return this.roomRateIdentifier;
    }

    @JsonProperty(value="roomRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateIdentifier(@Nonnull UUID roomRateIdentifier) {
        this.roomRateIdentifier = roomRateIdentifier;
    }

    public RoomStaySupplier roomRateInternalName(@Nonnull String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomRateInternalName() {
        return this.roomRateInternalName;
    }

    @JsonProperty(value="roomRateInternalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomRateInternalName(@Nonnull String roomRateInternalName) {
        this.roomRateInternalName = roomRateInternalName;
    }

    public RoomStaySupplier ratePlan(@Nonnull RoomConfigurationPriceRatePlanSupplier ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomConfigurationPriceRatePlanSupplier getRatePlan() {
        return this.ratePlan;
    }

    @JsonProperty(value="ratePlan")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlan(@Nonnull RoomConfigurationPriceRatePlanSupplier ratePlan) {
        this.ratePlan = ratePlan;
    }

    public RoomStaySupplier perkTypes(@Nullable List<@Valid PerkLightweightSupplier> perkTypes) {
        this.perkTypes = perkTypes;
        return this;
    }

    public RoomStaySupplier addPerkTypesItem(PerkLightweightSupplier perkTypesItem) {
        if (this.perkTypes == null) {
            this.perkTypes = new ArrayList<PerkLightweightSupplier>();
        }
        this.perkTypes.add(perkTypesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid PerkLightweightSupplier> getPerkTypes() {
        return this.perkTypes;
    }

    @JsonProperty(value="perkTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPerkTypes(@Nullable List<@Valid PerkLightweightSupplier> perkTypes) {
        this.perkTypes = perkTypes;
    }

    public RoomStaySupplier extraCharges(@Nonnull ExtraChargesSupplier extraCharges) {
        this.extraCharges = extraCharges;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExtraChargesSupplier getExtraCharges() {
        return this.extraCharges;
    }

    @JsonProperty(value="extraCharges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExtraCharges(@Nonnull ExtraChargesSupplier extraCharges) {
        this.extraCharges = extraCharges;
    }

    public RoomStaySupplier activeCancellationPolicy(@Nonnull CancellationPolicyLightweightSupplier activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CancellationPolicyLightweightSupplier getActiveCancellationPolicy() {
        return this.activeCancellationPolicy;
    }

    @JsonProperty(value="activeCancellationPolicy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActiveCancellationPolicy(@Nonnull CancellationPolicyLightweightSupplier activeCancellationPolicy) {
        this.activeCancellationPolicy = activeCancellationPolicy;
    }

    public RoomStaySupplier cancellable(@Nullable Boolean cancellable) {
        this.cancellable = cancellable;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellable() {
        return this.cancellable;
    }

    @JsonProperty(value="cancellable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellable(@Nullable Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public RoomStaySupplier cancellableByHotel(@Nullable Boolean cancellableByHotel) {
        this.cancellableByHotel = cancellableByHotel;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableByHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableByHotel() {
        return this.cancellableByHotel;
    }

    @JsonProperty(value="cancellableByHotel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableByHotel(@Nullable Boolean cancellableByHotel) {
        this.cancellableByHotel = cancellableByHotel;
    }

    public RoomStaySupplier cancellableWithPotentialCharge(@Nullable Boolean cancellableWithPotentialCharge) {
        this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
        return this;
    }

    @Nullable
    @JsonProperty(value="cancellableWithPotentialCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCancellableWithPotentialCharge() {
        return this.cancellableWithPotentialCharge;
    }

    @JsonProperty(value="cancellableWithPotentialCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCancellableWithPotentialCharge(@Nullable Boolean cancellableWithPotentialCharge) {
        this.cancellableWithPotentialCharge = cancellableWithPotentialCharge;
    }

    public RoomStaySupplier roomNights(@Nullable Long roomNights) {
        this.roomNights = roomNights;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRoomNights() {
        return this.roomNights;
    }

    @JsonProperty(value="roomNights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomNights(@Nullable Long roomNights) {
        this.roomNights = roomNights;
    }

    public RoomStaySupplier guests(@Nullable Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(@Nullable Integer guests) {
        this.guests = guests;
    }

    public RoomStaySupplier rateSource(@Nullable String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(@Nullable String rateSource) {
        this.rateSource = rateSource;
    }

    public RoomStaySupplier sourceTotal(@Nullable CustomMonetaryAmount sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(@Nullable CustomMonetaryAmount sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public RoomStaySupplier userSpecifiedCurrencyTotal(@Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(@Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public RoomStaySupplier internalTotal(@Nullable CustomMonetaryAmount internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomMonetaryAmount getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(@Nullable CustomMonetaryAmount internalTotal) {
        this.internalTotal = internalTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomStaySupplier roomStaySupplier = (RoomStaySupplier)o;
        return Objects.equals(this.policy, roomStaySupplier.policy) && Objects.equals(this.room, roomStaySupplier.room) && Objects.equals(this.rooms, roomStaySupplier.rooms) && Objects.equals(this.bedroomConfiguration, roomStaySupplier.bedroomConfiguration) && Objects.equals(this.adults, roomStaySupplier.adults) && Objects.equals(this.children, roomStaySupplier.children) && Objects.equals(this.startDate, roomStaySupplier.startDate) && Objects.equals(this.endDate, roomStaySupplier.endDate) && Objects.equals(this.price, roomStaySupplier.price) && Objects.equals(this.roomRateIdentifier, roomStaySupplier.roomRateIdentifier) && Objects.equals(this.roomRateInternalName, roomStaySupplier.roomRateInternalName) && Objects.equals(this.ratePlan, roomStaySupplier.ratePlan) && Objects.equals(this.perkTypes, roomStaySupplier.perkTypes) && Objects.equals(this.extraCharges, roomStaySupplier.extraCharges) && Objects.equals(this.activeCancellationPolicy, roomStaySupplier.activeCancellationPolicy) && Objects.equals(this.cancellable, roomStaySupplier.cancellable) && Objects.equals(this.cancellableByHotel, roomStaySupplier.cancellableByHotel) && Objects.equals(this.cancellableWithPotentialCharge, roomStaySupplier.cancellableWithPotentialCharge) && Objects.equals(this.roomNights, roomStaySupplier.roomNights) && Objects.equals(this.guests, roomStaySupplier.guests) && Objects.equals(this.rateSource, roomStaySupplier.rateSource) && Objects.equals(this.sourceTotal, roomStaySupplier.sourceTotal) && Objects.equals(this.userSpecifiedCurrencyTotal, roomStaySupplier.userSpecifiedCurrencyTotal) && Objects.equals(this.internalTotal, roomStaySupplier.internalTotal);
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.room, this.rooms, this.bedroomConfiguration, this.adults, this.children, this.startDate, this.endDate, this.price, this.roomRateIdentifier, this.roomRateInternalName, this.ratePlan, this.perkTypes, this.extraCharges, this.activeCancellationPolicy, this.cancellable, this.cancellableByHotel, this.cancellableWithPotentialCharge, this.roomNights, this.guests, this.rateSource, this.sourceTotal, this.userSpecifiedCurrencyTotal, this.internalTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomStaySupplier {\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    bedroomConfiguration: ").append(this.toIndentedString(this.bedroomConfiguration)).append("\n");
        sb.append("    adults: ").append(this.toIndentedString(this.adults)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    roomRateIdentifier: ").append(this.toIndentedString(this.roomRateIdentifier)).append("\n");
        sb.append("    roomRateInternalName: ").append(this.toIndentedString(this.roomRateInternalName)).append("\n");
        sb.append("    ratePlan: ").append(this.toIndentedString(this.ratePlan)).append("\n");
        sb.append("    perkTypes: ").append(this.toIndentedString(this.perkTypes)).append("\n");
        sb.append("    extraCharges: ").append(this.toIndentedString(this.extraCharges)).append("\n");
        sb.append("    activeCancellationPolicy: ").append(this.toIndentedString(this.activeCancellationPolicy)).append("\n");
        sb.append("    cancellable: ").append(this.toIndentedString(this.cancellable)).append("\n");
        sb.append("    cancellableByHotel: ").append(this.toIndentedString(this.cancellableByHotel)).append("\n");
        sb.append("    cancellableWithPotentialCharge: ").append(this.toIndentedString(this.cancellableWithPotentialCharge)).append("\n");
        sb.append("    roomNights: ").append(this.toIndentedString(this.roomNights)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

