/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.distribution.invoker.ApiClient;
import travel.wink.sdk.extranet.distribution.model.BookingTestRequestSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.BookingViewSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.ChannelNameSupplier;
import travel.wink.sdk.extranet.distribution.model.DateRangeSupplier;
import travel.wink.sdk.extranet.distribution.model.DescriptiveRoomSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.PageRateSupplier;
import travel.wink.sdk.extranet.distribution.model.RateSupplier;
import travel.wink.sdk.extranet.distribution.model.StateSupplier;
import travel.wink.sdk.extranet.distribution.model.UpsertBulkRateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.UpsertIndividualRateRequestWrapperSupplier;
import travel.wink.sdk.extranet.distribution.model.VerifyRatesRequestSupplierDetails;

public class DailyRateApi {
    private ApiClient apiClient;

    public DailyRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public DailyRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec bulkUpdateRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertBulkRateRequestSupplier postBody = upsertBulkRateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertBulkRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBulkRateRequestSupplier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/bulk", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> bulkUpdateRate(String propertyIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.bulkUpdateRateRequestCreation(propertyIdentifier, masterRateIdentifier, upsertBulkRateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> bulkUpdateRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.bulkUpdateRateRequestCreation(propertyIdentifier, masterRateIdentifier, upsertBulkRateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec bulkUpdateRateWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.bulkUpdateRateRequestCreation(propertyIdentifier, masterRateIdentifier, upsertBulkRateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec createTestBookingRequestCreation(String propertyIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        BookingTestRequestSupplierDetails postBody = bookingTestRequestSupplierDetails;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingTestRequestSupplierDetails == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingTestRequestSupplierDetails' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sandbox/booking", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplierDetails> createTestBooking(String propertyIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(this){};
        return this.createTestBookingRequestCreation(propertyIdentifier, bookingTestRequestSupplierDetails, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplierDetails>> createTestBookingWithHttpInfo(String propertyIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(this){};
        return this.createTestBookingRequestCreation(propertyIdentifier, bookingTestRequestSupplierDetails, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createTestBookingWithResponseSpec(String propertyIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        return this.createTestBookingRequestCreation(propertyIdentifier, bookingTestRequestSupplierDetails, winkVersion);
    }

    private WebClient.ResponseSpec showAllHotelRatesRequestCreation(String propertyIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        DateRangeSupplier postBody = dateRangeSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dateRangeSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRangeSupplier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/rates/dates", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> showAllHotelRates(String propertyIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.showAllHotelRatesRequestCreation(propertyIdentifier, dateRangeSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> showAllHotelRatesWithHttpInfo(String propertyIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.showAllHotelRatesRequestCreation(propertyIdentifier, dateRangeSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAllHotelRatesWithResponseSpec(String propertyIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        return this.showAllHotelRatesRequestCreation(propertyIdentifier, dateRangeSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showAllMasterRatesRatesRequestCreation(String propertyIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        DateRangeSupplier postBody = dateRangeSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dateRangeSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRangeSupplier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/rates/dates", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> showAllMasterRatesRates(String propertyIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.showAllMasterRatesRatesRequestCreation(propertyIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> showAllMasterRatesRatesWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.showAllMasterRatesRatesRequestCreation(propertyIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAllMasterRatesRatesWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        return this.showAllMasterRatesRatesRequestCreation(propertyIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showChannelsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sandbox/channel/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChannelNameSupplier> showChannels(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>(this){};
        return this.showChannelsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChannelNameSupplier>>> showChannelsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>(this){};
        return this.showChannelsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showChannelsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showChannelsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showDailyRatesPageRequestCreation(String propertyIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageRateSupplier> showDailyRatesPage(String propertyIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>(this){};
        return this.showDailyRatesPageRequestCreation(propertyIdentifier, masterRateIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageRateSupplier>> showDailyRatesPageWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>(this){};
        return this.showDailyRatesPageRequestCreation(propertyIdentifier, masterRateIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDailyRatesPageWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.showDailyRatesPageRequestCreation(propertyIdentifier, masterRateIdentifier, stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showDescriptiveInventoryRequestCreation(String propertyIdentifier, VerifyRatesRequestSupplierDetails verifyRatesRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        VerifyRatesRequestSupplierDetails postBody = verifyRatesRequestSupplierDetails;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (verifyRatesRequestSupplierDetails == null) {
            throw new WebClientResponseException("Missing the required parameter 'verifyRatesRequestSupplierDetails' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sandbox/room/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DescriptiveRoomSupplierDetails> showDescriptiveInventory(String propertyIdentifier, VerifyRatesRequestSupplierDetails verifyRatesRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>(this){};
        return this.showDescriptiveInventoryRequestCreation(propertyIdentifier, verifyRatesRequestSupplierDetails, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DescriptiveRoomSupplierDetails>>> showDescriptiveInventoryWithHttpInfo(String propertyIdentifier, VerifyRatesRequestSupplierDetails verifyRatesRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>(this){};
        return this.showDescriptiveInventoryRequestCreation(propertyIdentifier, verifyRatesRequestSupplierDetails, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDescriptiveInventoryWithResponseSpec(String propertyIdentifier, VerifyRatesRequestSupplierDetails verifyRatesRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        return this.showDescriptiveInventoryRequestCreation(propertyIdentifier, verifyRatesRequestSupplierDetails, winkVersion);
    }

    private WebClient.ResponseSpec updateRateListRequestCreation(String propertyIdentifier, List<UpsertIndividualRateRequestWrapperSupplier> upsertIndividualRateRequestWrapperSupplier, String winkVersion) throws WebClientResponseException {
        List<UpsertIndividualRateRequestWrapperSupplier> postBody = upsertIndividualRateRequestWrapperSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRateList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertIndividualRateRequestWrapperSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertIndividualRateRequestWrapperSupplier' when calling updateRateList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/rate/update", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateSupplier> updateRateList(String propertyIdentifier, List<UpsertIndividualRateRequestWrapperSupplier> upsertIndividualRateRequestWrapperSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.updateRateListRequestCreation(propertyIdentifier, upsertIndividualRateRequestWrapperSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateSupplier>>> updateRateListWithHttpInfo(String propertyIdentifier, List<UpsertIndividualRateRequestWrapperSupplier> upsertIndividualRateRequestWrapperSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>(this){};
        return this.updateRateListRequestCreation(propertyIdentifier, upsertIndividualRateRequestWrapperSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRateListWithResponseSpec(String propertyIdentifier, List<UpsertIndividualRateRequestWrapperSupplier> upsertIndividualRateRequestWrapperSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateRateListRequestCreation(propertyIdentifier, upsertIndividualRateRequestWrapperSupplier, winkVersion);
    }
}

