/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.distribution.invoker.ApiClient;
import travel.wink.sdk.extranet.distribution.model.InventoryUpdateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.distribution.model.SalesChannelCreateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.SalesChannelSupplier;
import travel.wink.sdk.extranet.distribution.model.SalesChannelUpdateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.SelectableKeyValuePairSupplier;

public class SalesChannelApi {
    private ApiClient apiClient;

    public SalesChannelApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestCreation(String propertyIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        SalesChannelCreateRequestSupplier postBody = salesChannelCreateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelCreateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelCreateRequestSupplier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> createSalesChannel(String propertyIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.createSalesChannelRequestCreation(propertyIdentifier, salesChannelCreateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> createSalesChannelWithHttpInfo(String propertyIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.createSalesChannelRequestCreation(propertyIdentifier, salesChannelCreateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSalesChannelWithResponseSpec(String propertyIdentifier, SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createSalesChannelRequestCreation(propertyIdentifier, salesChannelCreateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestCreation(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeSalesChannel(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeSalesChannelWithHttpInfo(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSalesChannelWithResponseSpec(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAccountsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAccounts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> showAccounts(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showAccountsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> showAccountsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showAccountsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAccountsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAccountsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelRequestCreation(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> showSalesChannel(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> showSalesChannelWithHttpInfo(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelWithResponseSpec(String propertyIdentifier, String salesChannelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsRequestCreation(String propertyIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier-bundle/{rateModifierBundleIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierBundlePairs(String propertyIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierBundlePairsWithHttpInfo(String propertyIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsWithResponseSpec(String propertyIdentifier, String rateModifierBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierPairsRequestCreation(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier/{rateModifierIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierPairs(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierPairsWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelContextRateModifierPairsWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelContextRateModifierPairsRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityRequestCreation(String propertyIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier/{rateModifierIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> toggleSalesChannelPromoAvailability(String propertyIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(propertyIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoAvailabilityWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(propertyIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(propertyIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityRequestCreation(String propertyIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier-bundle/{rateModifierBundleIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> toggleSalesChannelPromoBundleAvailability(String propertyIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoBundleAvailabilityWithHttpInfo(String propertyIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityWithResponseSpec(String propertyIdentifier, String rateModifierBundleIdentifier, List<InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateSalesChannelRequestCreation(String propertyIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        SalesChannelUpdateRequestSupplier postBody = salesChannelUpdateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelUpdateRequestSupplier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> updateSalesChannel(String propertyIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.updateSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> updateSalesChannelWithHttpInfo(String propertyIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.updateSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSalesChannelWithResponseSpec(String propertyIdentifier, String salesChannelIdentifier, SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion);
    }
}

