/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.api;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.distribution.invoker.ApiClient;
import travel.wink.sdk.extranet.distribution.model.CreateScheduleItemRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.ScheduleItemViewSupplier;
import travel.wink.sdk.extranet.distribution.model.UpdateScheduleItemRequestSupplier;

public class SchedulerApi {
    private ApiClient apiClient;

    public SchedulerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SchedulerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createScheduleItemRequestCreation(String propertyIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        CreateScheduleItemRequestSupplier postBody = createScheduleItemRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createScheduleItemRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'createScheduleItemRequestSupplier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/schedule/{inventoryIdentifier}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ScheduleItemViewSupplier> createScheduleItem(String propertyIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.createScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, createScheduleItemRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemViewSupplier>> createScheduleItemWithHttpInfo(String propertyIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.createScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, createScheduleItemRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createScheduleItemWithResponseSpec(String propertyIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, createScheduleItemRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeScheduleItemRequestCreation(String propertyIdentifier, String inventoryIdentifier, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ScheduleItemViewSupplier> removeScheduleItem(String propertyIdentifier, String inventoryIdentifier, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.removeScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, identifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemViewSupplier>> removeScheduleItemWithHttpInfo(String propertyIdentifier, String inventoryIdentifier, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.removeScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, identifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeScheduleItemWithResponseSpec(String propertyIdentifier, String inventoryIdentifier, String identifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, identifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showScheduleItemsRequestCreation(String propertyIdentifier, String inventoryIdentifier, LocalDateTime start, LocalDateTime end, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (start == null) {
            throw new WebClientResponseException("Missing the required parameter 'start' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (end == null) {
            throw new WebClientResponseException("Missing the required parameter 'end' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "end", end));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/schedule/{inventoryIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ScheduleItemViewSupplier> showScheduleItems(String propertyIdentifier, String inventoryIdentifier, LocalDateTime start, LocalDateTime end, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.showScheduleItemsRequestCreation(propertyIdentifier, inventoryIdentifier, start, end, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ScheduleItemViewSupplier>>> showScheduleItemsWithHttpInfo(String propertyIdentifier, String inventoryIdentifier, LocalDateTime start, LocalDateTime end, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.showScheduleItemsRequestCreation(propertyIdentifier, inventoryIdentifier, start, end, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showScheduleItemsWithResponseSpec(String propertyIdentifier, String inventoryIdentifier, LocalDateTime start, LocalDateTime end, String winkVersion, String accept) throws WebClientResponseException {
        return this.showScheduleItemsRequestCreation(propertyIdentifier, inventoryIdentifier, start, end, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateScheduleItemRequestCreation(String propertyIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpdateScheduleItemRequestSupplier postBody = updateScheduleItemRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (updateScheduleItemRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateScheduleItemRequestSupplier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ScheduleItemViewSupplier> updateScheduleItem(String propertyIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.updateScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ScheduleItemViewSupplier>> updateScheduleItemWithHttpInfo(String propertyIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>(this){};
        return this.updateScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateScheduleItemWithResponseSpec(String propertyIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateScheduleItemRequestCreation(propertyIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequestSupplier, winkVersion);
    }
}

