/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"start", "end", "startTimezone", "endTimezone", "isAllDay", "recurrenceRule", "recurrenceId", "recurrenceException", "bookingIdentifier", "type", "attendees"})
@JsonTypeName(value="CreateScheduleItemRequest_Supplier")
public class CreateScheduleItemRequestSupplier {
    public static final String JSON_PROPERTY_START = "start";
    private LocalDateTime start;
    public static final String JSON_PROPERTY_END = "end";
    private LocalDateTime end;
    public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
    private String startTimezone;
    public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
    private String endTimezone;
    public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
    private Boolean isAllDay = false;
    public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
    private String recurrenceRule;
    public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
    private String recurrenceId;
    public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
    private List<LocalDateTime> recurrenceException;
    public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
    private UUID bookingIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ATTENDEES = "attendees";
    private Integer attendees = 1;

    public CreateScheduleItemRequestSupplier start(LocalDateTime start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public CreateScheduleItemRequestSupplier end(LocalDateTime end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public CreateScheduleItemRequestSupplier startTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStartTimezone() {
        return this.startTimezone;
    }

    @JsonProperty(value="startTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartTimezone(String startTimezone) {
        this.startTimezone = startTimezone;
    }

    public CreateScheduleItemRequestSupplier endTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEndTimezone() {
        return this.endTimezone;
    }

    @JsonProperty(value="endTimezone")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndTimezone(String endTimezone) {
        this.endTimezone = endTimezone;
    }

    public CreateScheduleItemRequestSupplier isAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="isAllDay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsAllDay() {
        return this.isAllDay;
    }

    @JsonProperty(value="isAllDay")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
    }

    public CreateScheduleItemRequestSupplier recurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
        return this;
    }

    @Nullable
    @JsonProperty(value="recurrenceRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurrenceRule() {
        return this.recurrenceRule;
    }

    @JsonProperty(value="recurrenceRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceRule(String recurrenceRule) {
        this.recurrenceRule = recurrenceRule;
    }

    public CreateScheduleItemRequestSupplier recurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="recurrenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    @JsonProperty(value="recurrenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public CreateScheduleItemRequestSupplier recurrenceException(List<LocalDateTime> recurrenceException) {
        this.recurrenceException = recurrenceException;
        return this;
    }

    public CreateScheduleItemRequestSupplier addRecurrenceExceptionItem(LocalDateTime recurrenceExceptionItem) {
        if (this.recurrenceException == null) {
            this.recurrenceException = new ArrayList<LocalDateTime>();
        }
        this.recurrenceException.add(recurrenceExceptionItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recurrenceException")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalDateTime> getRecurrenceException() {
        return this.recurrenceException;
    }

    @JsonProperty(value="recurrenceException")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurrenceException(List<LocalDateTime> recurrenceException) {
        this.recurrenceException = recurrenceException;
    }

    public CreateScheduleItemRequestSupplier bookingIdentifier(UUID bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getBookingIdentifier() {
        return this.bookingIdentifier;
    }

    @JsonProperty(value="bookingIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookingIdentifier(UUID bookingIdentifier) {
        this.bookingIdentifier = bookingIdentifier;
    }

    public CreateScheduleItemRequestSupplier type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateScheduleItemRequestSupplier attendees(Integer attendees) {
        this.attendees = attendees;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="attendees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttendees(Integer attendees) {
        this.attendees = attendees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier = (CreateScheduleItemRequestSupplier)o;
        return Objects.equals(this.start, createScheduleItemRequestSupplier.start) && Objects.equals(this.end, createScheduleItemRequestSupplier.end) && Objects.equals(this.startTimezone, createScheduleItemRequestSupplier.startTimezone) && Objects.equals(this.endTimezone, createScheduleItemRequestSupplier.endTimezone) && Objects.equals(this.isAllDay, createScheduleItemRequestSupplier.isAllDay) && Objects.equals(this.recurrenceRule, createScheduleItemRequestSupplier.recurrenceRule) && Objects.equals(this.recurrenceId, createScheduleItemRequestSupplier.recurrenceId) && Objects.equals(this.recurrenceException, createScheduleItemRequestSupplier.recurrenceException) && Objects.equals(this.bookingIdentifier, createScheduleItemRequestSupplier.bookingIdentifier) && Objects.equals((Object)this.type, (Object)createScheduleItemRequestSupplier.type) && Objects.equals(this.attendees, createScheduleItemRequestSupplier.attendees);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.start, this.end, this.startTimezone, this.endTimezone, this.isAllDay, this.recurrenceRule, this.recurrenceId, this.recurrenceException, this.bookingIdentifier, this.type, this.attendees});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateScheduleItemRequestSupplier {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    startTimezone: ").append(this.toIndentedString(this.startTimezone)).append("\n");
        sb.append("    endTimezone: ").append(this.toIndentedString(this.endTimezone)).append("\n");
        sb.append("    isAllDay: ").append(this.toIndentedString(this.isAllDay)).append("\n");
        sb.append("    recurrenceRule: ").append(this.toIndentedString(this.recurrenceRule)).append("\n");
        sb.append("    recurrenceId: ").append(this.toIndentedString(this.recurrenceId)).append("\n");
        sb.append("    recurrenceException: ").append(this.toIndentedString(this.recurrenceException)).append("\n");
        sb.append("    bookingIdentifier: ").append(this.toIndentedString(this.bookingIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    attendees: ").append(this.toIndentedString(this.attendees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        SPA("SPA"),
        RESTAURANT("RESTAURANT"),
        ACTIVITY("ACTIVITY"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

