/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.distribution.invoker.ApiClient;
import travel.wink.sdk.extranet.distribution.model.InventoryUsageSupplier;

public class InventoryUsageApi {
    private ApiClient apiClient;

    public InventoryUsageApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryUsageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showActivityUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActivityUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling showActivityUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/activity/{activityIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showActivityUsage(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showActivityUsageRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showActivityUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showActivityUsageRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivityUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showActivityUsageRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAddOnUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAddOnUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOnUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/add-on/{addOnIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showAddOnUsage(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAddOnUsageRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showAddOnUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAddOnUsageRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAddOnUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAddOnUsageRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAttractionUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String attractionIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAttractionUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling showAttractionUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/attraction/{attractionIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showAttractionUsage(@Nonnull String propertyIdentifier, @Nonnull String attractionIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAttractionUsageRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showAttractionUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String attractionIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAttractionUsageRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAttractionUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String attractionIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAttractionUsageRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMeetingRoomUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String meetingRoomIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMeetingRoomUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoomUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/meeting-room/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showMeetingRoomUsage(@Nonnull String propertyIdentifier, @Nonnull String meetingRoomIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showMeetingRoomUsageRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showMeetingRoomUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String meetingRoomIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showMeetingRoomUsageRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMeetingRoomUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String meetingRoomIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showMeetingRoomUsageRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPlaceUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String placeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPlaceUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlaceUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/place/{placeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showPlaceUsage(@Nonnull String propertyIdentifier, @Nonnull String placeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showPlaceUsageRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showPlaceUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String placeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showPlaceUsageRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPlaceUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String placeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showPlaceUsageRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRatePlanUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRatePlanUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlanUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/rate-plan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showRatePlanUsage(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRatePlanUsageRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showRatePlanUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRatePlanUsageRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRatePlanUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRatePlanUsageRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRestaurantUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling showRestaurantUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/restaurant/{restaurantIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showRestaurantUsage(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRestaurantUsageRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showRestaurantUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRestaurantUsageRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRestaurantUsageRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRoomTypeUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRoomTypeUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling showRoomTypeUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/room-type/{roomTypeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showRoomTypeUsage(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRoomTypeUsageRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showRoomTypeUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRoomTypeUsageRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRoomTypeUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRoomTypeUsageRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSpaUsageRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSpaUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling showSpaUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory-usage/spa/{spaIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showSpaUsage(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showSpaUsageRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showSpaUsageWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showSpaUsageRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSpaUsageWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSpaUsageRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept);
    }
}

