/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.distribution.invoker.ApiClient;
import travel.wink.sdk.extranet.distribution.model.InventoryUpdateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.SalesChannelCreateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.SalesChannelSupplier;
import travel.wink.sdk.extranet.distribution.model.SalesChannelUpdateRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.SelectableKeyValuePairSupplier;

public class SalesChannelApi {
    private ApiClient apiClient;

    public SalesChannelApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestCreation(@Nonnull String propertyIdentifier, @Nonnull SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SalesChannelCreateRequestSupplier postBody = salesChannelCreateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelCreateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelCreateRequestSupplier' when calling createSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> createSalesChannel(@Nonnull String propertyIdentifier, @Nonnull SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.createSalesChannelRequestCreation(propertyIdentifier, salesChannelCreateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> createSalesChannelWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.createSalesChannelRequestCreation(propertyIdentifier, salesChannelCreateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSalesChannelWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull SalesChannelCreateRequestSupplier salesChannelCreateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSalesChannelRequestCreation(propertyIdentifier, salesChannelCreateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling removeSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> removeSalesChannel(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.removeSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> removeSalesChannelWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.removeSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSalesChannelWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAccountsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAccounts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> showAccounts(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showAccountsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> showAccountsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showAccountsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAccountsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAccountsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> showSalesChannel(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> showSalesChannelWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.showSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showSalesChannelContextRateModifierBundlePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier-bundle/{rateModifierBundleIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierBundlePairs(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierBundlePairsWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelContextRateModifierBundlePairsWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSalesChannelContextRateModifierBundlePairsRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelContextRateModifierPairsRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showSalesChannelContextRateModifierPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier/{rateModifierIdentifier}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SelectableKeyValuePairSupplier> showSalesChannelContextRateModifierPairs(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SelectableKeyValuePairSupplier>>> showSalesChannelContextRateModifierPairsWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SelectableKeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<SelectableKeyValuePairSupplier>(this){};
        return this.showSalesChannelContextRateModifierPairsRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelContextRateModifierPairsWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSalesChannelContextRateModifierPairsRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier/{rateModifierIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> toggleSalesChannelPromoAvailability(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(propertyIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoAvailabilityWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(propertyIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleSalesChannelPromoAvailabilityWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.toggleSalesChannelPromoAvailabilityRequestCreation(propertyIdentifier, rateModifierIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        List<InventoryUpdateRequestSupplier> postBody = inventoryUpdateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUpdateRequestSupplier' when calling toggleSalesChannelPromoBundleAvailability", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/rate-modifier-bundle/{rateModifierBundleIdentifier}/list", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelSupplier> toggleSalesChannelPromoBundleAvailability(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelSupplier>>> toggleSalesChannelPromoBundleAvailabilityWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleSalesChannelPromoBundleAvailabilityWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull List<@Valid InventoryUpdateRequestSupplier> inventoryUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.toggleSalesChannelPromoBundleAvailabilityRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, inventoryUpdateRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateSalesChannelRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nonnull SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        SalesChannelUpdateRequestSupplier postBody = salesChannelUpdateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelUpdateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelUpdateRequestSupplier' when calling updateSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales/account/{salesChannelIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelSupplier> updateSalesChannel(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nonnull SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.updateSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelSupplier>> updateSalesChannelWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nonnull SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelSupplier>(this){};
        return this.updateSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSalesChannelWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String salesChannelIdentifier, @Nonnull SalesChannelUpdateRequestSupplier salesChannelUpdateRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSalesChannelRequestCreation(propertyIdentifier, salesChannelIdentifier, salesChannelUpdateRequestSupplier, winkVersion);
    }
}

