/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.distribution.invoker.ApiClient;
import travel.wink.sdk.extranet.distribution.model.SalesChannelRequestSupplier;
import travel.wink.sdk.extranet.distribution.model.UpsertSalesChannelRequestRequestSupplier;

public class SalesChannelRequestApi {
    private ApiClient apiClient;

    public SalesChannelRequestApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelRequestApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertSalesChannelRequestRequestSupplier upsertSalesChannelRequestRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSalesChannelRequestRequestSupplier postBody = upsertSalesChannelRequestRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSalesChannelRequestRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRequestRequestSupplier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales-channel/request", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRequestSupplier> createSalesChannelRequest(@Nonnull String propertyIdentifier, @Nonnull UpsertSalesChannelRequestRequestSupplier upsertSalesChannelRequestRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.createSalesChannelRequestRequestCreation(propertyIdentifier, upsertSalesChannelRequestRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRequestSupplier>> createSalesChannelRequestWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertSalesChannelRequestRequestSupplier upsertSalesChannelRequestRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.createSalesChannelRequestRequestCreation(propertyIdentifier, upsertSalesChannelRequestRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSalesChannelRequestWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertSalesChannelRequestRequestSupplier upsertSalesChannelRequestRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSalesChannelRequestRequestCreation(propertyIdentifier, upsertSalesChannelRequestRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales-channel/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRequestSupplier> removeSalesChannelRequest(@Nonnull String propertyIdentifier, @Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.removeSalesChannelRequestRequestCreation(propertyIdentifier, salesChannelRequestIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRequestSupplier>> removeSalesChannelRequestWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.removeSalesChannelRequestRequestCreation(propertyIdentifier, salesChannelRequestIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSalesChannelRequestWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSalesChannelRequestRequestCreation(propertyIdentifier, salesChannelRequestIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSalesChannelRequestsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSalesChannelRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/sales-channel/request/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelRequestSupplier> showSalesChannelRequests(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.showSalesChannelRequestsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelRequestSupplier>>> showSalesChannelRequestsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestSupplier>(this){};
        return this.showSalesChannelRequestsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelRequestsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSalesChannelRequestsRequestCreation(propertyIdentifier, winkVersion, accept);
    }
}

