/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.distribution.model.InventoryUsageItemSupplier;

@JsonPropertyOrder(value={"inventoryIdentifier", "name", "type", "itemList", "referenced"})
@JsonTypeName(value="InventoryUsage_Supplier")
public class InventoryUsageSupplier {
    public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
    @Nonnull
    private UUID inventoryIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    @Nonnull
    private List<@Valid InventoryUsageItemSupplier> itemList = new ArrayList<InventoryUsageItemSupplier>();
    public static final String JSON_PROPERTY_REFERENCED = "referenced";
    @Nullable
    private Boolean referenced;

    public InventoryUsageSupplier inventoryIdentifier(@Nonnull UUID inventoryIdentifier) {
        this.inventoryIdentifier = inventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="inventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getInventoryIdentifier() {
        return this.inventoryIdentifier;
    }

    @JsonProperty(value="inventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryIdentifier(@Nonnull UUID inventoryIdentifier) {
        this.inventoryIdentifier = inventoryIdentifier;
    }

    public InventoryUsageSupplier name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public InventoryUsageSupplier type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public InventoryUsageSupplier itemList(@Nonnull List<@Valid InventoryUsageItemSupplier> itemList) {
        this.itemList = itemList;
        return this;
    }

    public InventoryUsageSupplier addItemListItem(InventoryUsageItemSupplier itemListItem) {
        if (this.itemList == null) {
            this.itemList = new ArrayList<InventoryUsageItemSupplier>();
        }
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid List<@Valid InventoryUsageItemSupplier> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(@Nonnull List<@Valid InventoryUsageItemSupplier> itemList) {
        this.itemList = itemList;
    }

    public InventoryUsageSupplier referenced(@Nullable Boolean referenced) {
        this.referenced = referenced;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenced")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReferenced() {
        return this.referenced;
    }

    @JsonProperty(value="referenced")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenced(@Nullable Boolean referenced) {
        this.referenced = referenced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryUsageSupplier inventoryUsageSupplier = (InventoryUsageSupplier)o;
        return Objects.equals(this.inventoryIdentifier, inventoryUsageSupplier.inventoryIdentifier) && Objects.equals(this.name, inventoryUsageSupplier.name) && Objects.equals((Object)this.type, (Object)inventoryUsageSupplier.type) && Objects.equals(this.itemList, inventoryUsageSupplier.itemList) && Objects.equals(this.referenced, inventoryUsageSupplier.referenced);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inventoryIdentifier, this.name, this.type, this.itemList, this.referenced});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryUsageSupplier {\n");
        sb.append("    inventoryIdentifier: ").append(this.toIndentedString(this.inventoryIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    referenced: ").append(this.toIndentedString(this.referenced)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GUEST_ROOM(String.valueOf("GUEST_ROOM")),
        ADD_ON(String.valueOf("ADD_ON")),
        MEETING_ROOM(String.valueOf("MEETING_ROOM")),
        RESTAURANT(String.valueOf("RESTAURANT")),
        SPA(String.valueOf("SPA")),
        ATTRACTION(String.valueOf("ATTRACTION")),
        PLACE(String.valueOf("PLACE")),
        ACTIVITY(String.valueOf("ACTIVITY"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

