/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.distribution.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.distribution.model.PayoutFeeSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.QuoteLightweightSupplierDetails;

@JsonPropertyOrder(value={"vendor", "vendorIdentifier", "vendorName", "ledgerIdentifier", "beneficiaryIdentifier", "externalPayeeIdentifier", "type", "entry", "fees", "quote", "created", "description", "payoutId", "referenceCode", "referenceCodeDate", "status"})
@JsonTypeName(value="Payout_SupplierDetails")
public class PayoutSupplierDetails {
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    @Nonnull
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_VENDOR_IDENTIFIER = "vendorIdentifier";
    @Nonnull
    private String vendorIdentifier;
    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    @Nonnull
    private String vendorName;
    public static final String JSON_PROPERTY_LEDGER_IDENTIFIER = "ledgerIdentifier";
    @Nonnull
    private UUID ledgerIdentifier;
    public static final String JSON_PROPERTY_BENEFICIARY_IDENTIFIER = "beneficiaryIdentifier";
    @Nonnull
    private UUID beneficiaryIdentifier;
    public static final String JSON_PROPERTY_EXTERNAL_PAYEE_IDENTIFIER = "externalPayeeIdentifier";
    @Nonnull
    private String externalPayeeIdentifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_ENTRY = "entry";
    @Nonnull
    private CustomMonetaryAmount entry;
    public static final String JSON_PROPERTY_FEES = "fees";
    @Nullable
    private List<@Valid PayoutFeeSupplierDetails> fees = new ArrayList<PayoutFeeSupplierDetails>();
    public static final String JSON_PROPERTY_QUOTE = "quote";
    @Nullable
    private QuoteLightweightSupplierDetails quote;
    public static final String JSON_PROPERTY_CREATED = "created";
    @Nonnull
    private LocalDateTime created;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_PAYOUT_ID = "payoutId";
    @Nullable
    private String payoutId;
    public static final String JSON_PROPERTY_REFERENCE_CODE = "referenceCode";
    @Nullable
    private String referenceCode;
    public static final String JSON_PROPERTY_REFERENCE_CODE_DATE = "referenceCodeDate";
    @Nullable
    private LocalDateTime referenceCodeDate;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status;

    public PayoutSupplierDetails vendor(@Nonnull VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendor(@Nonnull VendorEnum vendor) {
        this.vendor = vendor;
    }

    public PayoutSupplierDetails vendorIdentifier(@Nonnull String vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="vendorIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getVendorIdentifier() {
        return this.vendorIdentifier;
    }

    @JsonProperty(value="vendorIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendorIdentifier(@Nonnull String vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
    }

    public PayoutSupplierDetails vendorName(@Nonnull String vendorName) {
        this.vendorName = vendorName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getVendorName() {
        return this.vendorName;
    }

    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendorName(@Nonnull String vendorName) {
        this.vendorName = vendorName;
    }

    public PayoutSupplierDetails ledgerIdentifier(@Nonnull UUID ledgerIdentifier) {
        this.ledgerIdentifier = ledgerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="ledgerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getLedgerIdentifier() {
        return this.ledgerIdentifier;
    }

    @JsonProperty(value="ledgerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLedgerIdentifier(@Nonnull UUID ledgerIdentifier) {
        this.ledgerIdentifier = ledgerIdentifier;
    }

    public PayoutSupplierDetails beneficiaryIdentifier(@Nonnull UUID beneficiaryIdentifier) {
        this.beneficiaryIdentifier = beneficiaryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="beneficiaryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getBeneficiaryIdentifier() {
        return this.beneficiaryIdentifier;
    }

    @JsonProperty(value="beneficiaryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBeneficiaryIdentifier(@Nonnull UUID beneficiaryIdentifier) {
        this.beneficiaryIdentifier = beneficiaryIdentifier;
    }

    public PayoutSupplierDetails externalPayeeIdentifier(@Nonnull String externalPayeeIdentifier) {
        this.externalPayeeIdentifier = externalPayeeIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="externalPayeeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExternalPayeeIdentifier() {
        return this.externalPayeeIdentifier;
    }

    @JsonProperty(value="externalPayeeIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExternalPayeeIdentifier(@Nonnull String externalPayeeIdentifier) {
        this.externalPayeeIdentifier = externalPayeeIdentifier;
    }

    public PayoutSupplierDetails type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public PayoutSupplierDetails entry(@Nonnull CustomMonetaryAmount entry) {
        this.entry = entry;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getEntry() {
        return this.entry;
    }

    @JsonProperty(value="entry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntry(@Nonnull CustomMonetaryAmount entry) {
        this.entry = entry;
    }

    public PayoutSupplierDetails fees(@Nullable List<@Valid PayoutFeeSupplierDetails> fees) {
        this.fees = fees;
        return this;
    }

    public PayoutSupplierDetails addFeesItem(PayoutFeeSupplierDetails feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<PayoutFeeSupplierDetails>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid PayoutFeeSupplierDetails> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFees(@Nullable List<@Valid PayoutFeeSupplierDetails> fees) {
        this.fees = fees;
    }

    public PayoutSupplierDetails quote(@Nullable QuoteLightweightSupplierDetails quote) {
        this.quote = quote;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="quote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QuoteLightweightSupplierDetails getQuote() {
        return this.quote;
    }

    @JsonProperty(value="quote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuote(@Nullable QuoteLightweightSupplierDetails quote) {
        this.quote = quote;
    }

    public PayoutSupplierDetails created(@Nonnull LocalDateTime created) {
        this.created = created;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreated(@Nonnull LocalDateTime created) {
        this.created = created;
    }

    public PayoutSupplierDetails description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public PayoutSupplierDetails payoutId(@Nullable String payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nullable
    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutId() {
        return this.payoutId;
    }

    @JsonProperty(value="payoutId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutId(@Nullable String payoutId) {
        this.payoutId = payoutId;
    }

    public PayoutSupplierDetails referenceCode(@Nullable String referenceCode) {
        this.referenceCode = referenceCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceCode() {
        return this.referenceCode;
    }

    @JsonProperty(value="referenceCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceCode(@Nullable String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public PayoutSupplierDetails referenceCodeDate(@Nullable LocalDateTime referenceCodeDate) {
        this.referenceCodeDate = referenceCodeDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="referenceCodeDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getReferenceCodeDate() {
        return this.referenceCodeDate;
    }

    @JsonProperty(value="referenceCodeDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceCodeDate(@Nullable LocalDateTime referenceCodeDate) {
        this.referenceCodeDate = referenceCodeDate;
    }

    public PayoutSupplierDetails status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutSupplierDetails payoutSupplierDetails = (PayoutSupplierDetails)o;
        return Objects.equals((Object)this.vendor, (Object)payoutSupplierDetails.vendor) && Objects.equals(this.vendorIdentifier, payoutSupplierDetails.vendorIdentifier) && Objects.equals(this.vendorName, payoutSupplierDetails.vendorName) && Objects.equals(this.ledgerIdentifier, payoutSupplierDetails.ledgerIdentifier) && Objects.equals(this.beneficiaryIdentifier, payoutSupplierDetails.beneficiaryIdentifier) && Objects.equals(this.externalPayeeIdentifier, payoutSupplierDetails.externalPayeeIdentifier) && Objects.equals((Object)this.type, (Object)payoutSupplierDetails.type) && Objects.equals(this.entry, payoutSupplierDetails.entry) && Objects.equals(this.fees, payoutSupplierDetails.fees) && Objects.equals(this.quote, payoutSupplierDetails.quote) && Objects.equals(this.created, payoutSupplierDetails.created) && Objects.equals(this.description, payoutSupplierDetails.description) && Objects.equals(this.payoutId, payoutSupplierDetails.payoutId) && Objects.equals(this.referenceCode, payoutSupplierDetails.referenceCode) && Objects.equals(this.referenceCodeDate, payoutSupplierDetails.referenceCodeDate) && Objects.equals((Object)this.status, (Object)payoutSupplierDetails.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vendor, this.vendorIdentifier, this.vendorName, this.ledgerIdentifier, this.beneficiaryIdentifier, this.externalPayeeIdentifier, this.type, this.entry, this.fees, this.quote, this.created, this.description, this.payoutId, this.referenceCode, this.referenceCodeDate, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutSupplierDetails {\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    vendorIdentifier: ").append(this.toIndentedString(this.vendorIdentifier)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    ledgerIdentifier: ").append(this.toIndentedString(this.ledgerIdentifier)).append("\n");
        sb.append("    beneficiaryIdentifier: ").append(this.toIndentedString(this.beneficiaryIdentifier)).append("\n");
        sb.append("    externalPayeeIdentifier: ").append(this.toIndentedString(this.externalPayeeIdentifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    entry: ").append(this.toIndentedString(this.entry)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    referenceCode: ").append(this.toIndentedString(this.referenceCode)).append("\n");
        sb.append("    referenceCodeDate: ").append(this.toIndentedString(this.referenceCodeDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE(String.valueOf("STRIPE")),
        AGENT(String.valueOf("AGENT")),
        NMI(String.valueOf("NMI")),
        WISE(String.valueOf("WISE")),
        TEST(String.valueOf("TEST"));

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BANK_TRANSFER(String.valueOf("BANK_TRANSFER"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        INITIATED(String.valueOf("INITIATED")),
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        FAILED(String.valueOf("FAILED")),
        CANCELLED(String.valueOf("CANCELLED")),
        COMPLETE(String.valueOf("COMPLETE"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

