/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.distribution.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.extranet.distribution.model.AddressSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.BedroomConfigurationSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.ContactSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.distribution.model.GeoJsonPointSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.SimpleDescriptionSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.SimpleMultimediaSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.SocialSupplierDetails;
import travel.wink.sdk.extranet.distribution.model.TransactionalTravelInventorySupplierDetails;
import travel.wink.sdk.extranet.distribution.model.TravelInventoryRecognitionSupplierDetails;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "transactionalInventoryList", "maxOccupancy", "minOccupancy", "quantity", "nonSmoking", "bedroomConfigurationList", "size", "maxAdultOccupancy", "maxChildOccupancy", "bathroomCount", "livingRoomCount", "maxRollaways", "roomCategory", "floor", "roomLocationCode", "roomViewCode", "composite", "compositeCount", "roomClassificationCode", "roomArchitectureCode", "roomGender", "sharedRoomInd", "maxCribs", "amenities", "includedAdultOccupancy", "includedChildOccupancy", "baseRate", "minRate"})
@JsonTypeName(value="RoomTypeLightweight_SupplierDetails")
public class RoomTypeLightweightSupplierDetails {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private String identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    @Nonnull
    private String hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    @Nonnull
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    @Nullable
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nonnull
    private GeoJsonPointSupplierDetails location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionSupplierDetails> descriptions = new ArrayList<SimpleDescriptionSupplierDetails>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    @Nonnull
    private List<@Valid SimpleMultimediaSupplierDetails> multimedias = new ArrayList<SimpleMultimediaSupplierDetails>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    @Nonnull
    private ContactSupplierDetails contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private AddressSupplierDetails address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    @Nonnull
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    @Nonnull
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    @Nullable
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    @Nonnull
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nonnull
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    @Nullable
    private List<String> disabilityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    @Nullable
    private List<String> securityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    @Nullable
    private List<@Valid SocialSupplierDetails> socials = new ArrayList<SocialSupplierDetails>();
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    @Nonnull
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    @Nullable
    private List<@Valid TravelInventoryRecognitionSupplierDetails> recognitionList = new ArrayList<TravelInventoryRecognitionSupplierDetails>();
    public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
    @Nullable
    private List<@Valid TransactionalTravelInventorySupplierDetails> transactionalInventoryList = new ArrayList<TransactionalTravelInventorySupplierDetails>();
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    @Nonnull
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    @Nonnull
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    @Nonnull
    private Integer quantity;
    public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
    @Nonnull
    private Boolean nonSmoking;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
    @Nonnull
    private List<@Valid BedroomConfigurationSupplierDetails> bedroomConfigurationList = new ArrayList<BedroomConfigurationSupplierDetails>();
    public static final String JSON_PROPERTY_SIZE = "size";
    @Nonnull
    private Float size;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    @Nonnull
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    @Nonnull
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
    @Nonnull
    private Integer bathroomCount = 1;
    public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
    @Nonnull
    private Integer livingRoomCount = 1;
    public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
    @Nonnull
    private Integer maxRollaways = 0;
    public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
    @Nonnull
    private String roomCategory;
    public static final String JSON_PROPERTY_FLOOR = "floor";
    @Nullable
    private String floor;
    public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
    @Nonnull
    private String roomLocationCode;
    public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
    @Nonnull
    private String roomViewCode;
    public static final String JSON_PROPERTY_COMPOSITE = "composite";
    @Nonnull
    private Boolean composite = false;
    public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
    @Nonnull
    private Integer compositeCount = 0;
    public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
    @Nonnull
    private String roomClassificationCode;
    public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
    @Nonnull
    private String roomArchitectureCode;
    public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
    @Nullable
    private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;
    public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
    @Nonnull
    private Boolean sharedRoomInd = false;
    public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
    @Nonnull
    private Integer maxCribs = 0;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    @Nullable
    private List<String> amenities = new ArrayList<String>();
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    @Nonnull
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    @Nonnull
    private Integer includedChildOccupancy = 0;
    public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
    @Nonnull
    private CustomMonetaryAmount baseRate;
    public static final String JSON_PROPERTY_MIN_RATE = "minRate";
    @Nonnull
    private CustomMonetaryAmount minRate;

    public RoomTypeLightweightSupplierDetails identifier(@Nonnull String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public RoomTypeLightweightSupplierDetails hotelIdentifier(@Nonnull String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(@Nonnull String hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RoomTypeLightweightSupplierDetails featuredInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public RoomTypeLightweightSupplierDetails lifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public RoomTypeLightweightSupplierDetails location(@Nonnull GeoJsonPointSupplierDetails location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointSupplierDetails getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(@Nonnull GeoJsonPointSupplierDetails location) {
        this.location = location;
    }

    public RoomTypeLightweightSupplierDetails descriptions(@Nonnull List<@Valid SimpleDescriptionSupplierDetails> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addDescriptionsItem(SimpleDescriptionSupplierDetails descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionSupplierDetails>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleDescriptionSupplierDetails> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionSupplierDetails> descriptions) {
        this.descriptions = descriptions;
    }

    public RoomTypeLightweightSupplierDetails multimedias(@Nonnull List<@Valid SimpleMultimediaSupplierDetails> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addMultimediasItem(SimpleMultimediaSupplierDetails multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaSupplierDetails>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleMultimediaSupplierDetails> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(@Nonnull List<@Valid SimpleMultimediaSupplierDetails> multimedias) {
        this.multimedias = multimedias;
    }

    public RoomTypeLightweightSupplierDetails contact(@Nonnull ContactSupplierDetails contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactSupplierDetails getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(@Nonnull ContactSupplierDetails contact) {
        this.contact = contact;
    }

    public RoomTypeLightweightSupplierDetails address(@Nonnull AddressSupplierDetails address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressSupplierDetails getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull AddressSupplierDetails address) {
        this.address = address;
    }

    public RoomTypeLightweightSupplierDetails commissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RoomTypeLightweightSupplierDetails name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public RoomTypeLightweightSupplierDetails proximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public RoomTypeLightweightSupplierDetails sort(@Nullable Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable Integer sort) {
        this.sort = sort;
    }

    public RoomTypeLightweightSupplierDetails minAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public RoomTypeLightweightSupplierDetails bookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
    }

    public RoomTypeLightweightSupplierDetails active(@Nonnull Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(@Nonnull Boolean active) {
        this.active = active;
    }

    public RoomTypeLightweightSupplierDetails disabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public RoomTypeLightweightSupplierDetails securityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public RoomTypeLightweightSupplierDetails socials(@Nullable List<@Valid SocialSupplierDetails> socials) {
        this.socials = socials;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addSocialsItem(SocialSupplierDetails socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialSupplierDetails>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SocialSupplierDetails> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(@Nullable List<@Valid SocialSupplierDetails> socials) {
        this.socials = socials;
    }

    public RoomTypeLightweightSupplierDetails pricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public RoomTypeLightweightSupplierDetails recognitionList(@Nullable List<@Valid TravelInventoryRecognitionSupplierDetails> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addRecognitionListItem(TravelInventoryRecognitionSupplierDetails recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionSupplierDetails>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid TravelInventoryRecognitionSupplierDetails> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(@Nullable List<@Valid TravelInventoryRecognitionSupplierDetails> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public RoomTypeLightweightSupplierDetails transactionalInventoryList(@Nullable List<@Valid TransactionalTravelInventorySupplierDetails> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addTransactionalInventoryListItem(TransactionalTravelInventorySupplierDetails transactionalInventoryListItem) {
        if (this.transactionalInventoryList == null) {
            this.transactionalInventoryList = new ArrayList<TransactionalTravelInventorySupplierDetails>();
        }
        this.transactionalInventoryList.add(transactionalInventoryListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid TransactionalTravelInventorySupplierDetails> getTransactionalInventoryList() {
        return this.transactionalInventoryList;
    }

    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionalInventoryList(@Nullable List<@Valid TransactionalTravelInventorySupplierDetails> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
    }

    public RoomTypeLightweightSupplierDetails maxOccupancy(@Nonnull Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(@Nonnull Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public RoomTypeLightweightSupplierDetails minOccupancy(@Nonnull Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(@Nonnull Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public RoomTypeLightweightSupplierDetails quantity(@Nonnull Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(@Nonnull Integer quantity) {
        this.quantity = quantity;
    }

    public RoomTypeLightweightSupplierDetails nonSmoking(@Nonnull Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getNonSmoking() {
        return this.nonSmoking;
    }

    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNonSmoking(@Nonnull Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
    }

    public RoomTypeLightweightSupplierDetails bedroomConfigurationList(@Nonnull List<@Valid BedroomConfigurationSupplierDetails> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addBedroomConfigurationListItem(BedroomConfigurationSupplierDetails bedroomConfigurationListItem) {
        if (this.bedroomConfigurationList == null) {
            this.bedroomConfigurationList = new ArrayList<BedroomConfigurationSupplierDetails>();
        }
        this.bedroomConfigurationList.add(bedroomConfigurationListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid BedroomConfigurationSupplierDetails> getBedroomConfigurationList() {
        return this.bedroomConfigurationList;
    }

    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfigurationList(@Nonnull List<@Valid BedroomConfigurationSupplierDetails> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
    }

    public RoomTypeLightweightSupplierDetails size(@Nonnull Float size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1") Float getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(@Nonnull Float size) {
        this.size = size;
    }

    public RoomTypeLightweightSupplierDetails maxAdultOccupancy(@Nonnull Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(@Nonnull Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public RoomTypeLightweightSupplierDetails maxChildOccupancy(@Nonnull Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(@Nonnull Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public RoomTypeLightweightSupplierDetails bathroomCount(@Nonnull Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getBathroomCount() {
        return this.bathroomCount;
    }

    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBathroomCount(@Nonnull Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
    }

    public RoomTypeLightweightSupplierDetails livingRoomCount(@Nonnull Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getLivingRoomCount() {
        return this.livingRoomCount;
    }

    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLivingRoomCount(@Nonnull Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
    }

    public RoomTypeLightweightSupplierDetails maxRollaways(@Nonnull Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxRollaways() {
        return this.maxRollaways;
    }

    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxRollaways(@Nonnull Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
    }

    public RoomTypeLightweightSupplierDetails roomCategory(@Nonnull String roomCategory) {
        this.roomCategory = roomCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomCategory() {
        return this.roomCategory;
    }

    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomCategory(@Nonnull String roomCategory) {
        this.roomCategory = roomCategory;
    }

    public RoomTypeLightweightSupplierDetails floor(@Nullable String floor) {
        this.floor = floor;
        return this;
    }

    @Nullable
    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFloor() {
        return this.floor;
    }

    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFloor(@Nullable String floor) {
        this.floor = floor;
    }

    public RoomTypeLightweightSupplierDetails roomLocationCode(@Nonnull String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomLocationCode() {
        return this.roomLocationCode;
    }

    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomLocationCode(@Nonnull String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
    }

    public RoomTypeLightweightSupplierDetails roomViewCode(@Nonnull String roomViewCode) {
        this.roomViewCode = roomViewCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomViewCode() {
        return this.roomViewCode;
    }

    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomViewCode(@Nonnull String roomViewCode) {
        this.roomViewCode = roomViewCode;
    }

    public RoomTypeLightweightSupplierDetails composite(@Nonnull Boolean composite) {
        this.composite = composite;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getComposite() {
        return this.composite;
    }

    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setComposite(@Nonnull Boolean composite) {
        this.composite = composite;
    }

    public RoomTypeLightweightSupplierDetails compositeCount(@Nonnull Integer compositeCount) {
        this.compositeCount = compositeCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getCompositeCount() {
        return this.compositeCount;
    }

    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompositeCount(@Nonnull Integer compositeCount) {
        this.compositeCount = compositeCount;
    }

    public RoomTypeLightweightSupplierDetails roomClassificationCode(@Nonnull String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomClassificationCode() {
        return this.roomClassificationCode;
    }

    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomClassificationCode(@Nonnull String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
    }

    public RoomTypeLightweightSupplierDetails roomArchitectureCode(@Nonnull String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomArchitectureCode() {
        return this.roomArchitectureCode;
    }

    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomArchitectureCode(@Nonnull String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
    }

    public RoomTypeLightweightSupplierDetails roomGender(@Nullable RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomGenderEnum getRoomGender() {
        return this.roomGender;
    }

    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomGender(@Nullable RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
    }

    public RoomTypeLightweightSupplierDetails sharedRoomInd(@Nonnull Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSharedRoomInd() {
        return this.sharedRoomInd;
    }

    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSharedRoomInd(@Nonnull Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
    }

    public RoomTypeLightweightSupplierDetails maxCribs(@Nonnull Integer maxCribs) {
        this.maxCribs = maxCribs;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxCribs() {
        return this.maxCribs;
    }

    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxCribs(@Nonnull Integer maxCribs) {
        this.maxCribs = maxCribs;
    }

    public RoomTypeLightweightSupplierDetails amenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public RoomTypeLightweightSupplierDetails addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
    }

    public RoomTypeLightweightSupplierDetails includedAdultOccupancy(@Nonnull Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(@Nonnull Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public RoomTypeLightweightSupplierDetails includedChildOccupancy(@Nonnull Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(@Nonnull Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public RoomTypeLightweightSupplierDetails baseRate(@Nonnull CustomMonetaryAmount baseRate) {
        this.baseRate = baseRate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="baseRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getBaseRate() {
        return this.baseRate;
    }

    @JsonProperty(value="baseRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBaseRate(@Nonnull CustomMonetaryAmount baseRate) {
        this.baseRate = baseRate;
    }

    public RoomTypeLightweightSupplierDetails minRate(@Nonnull CustomMonetaryAmount minRate) {
        this.minRate = minRate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="minRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getMinRate() {
        return this.minRate;
    }

    @JsonProperty(value="minRate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinRate(@Nonnull CustomMonetaryAmount minRate) {
        this.minRate = minRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomTypeLightweightSupplierDetails roomTypeLightweightSupplierDetails = (RoomTypeLightweightSupplierDetails)o;
        return Objects.equals(this.identifier, roomTypeLightweightSupplierDetails.identifier) && Objects.equals(this.hotelIdentifier, roomTypeLightweightSupplierDetails.hotelIdentifier) && Objects.equals(this.featuredInd, roomTypeLightweightSupplierDetails.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)roomTypeLightweightSupplierDetails.lifestyleType) && Objects.equals(this.location, roomTypeLightweightSupplierDetails.location) && Objects.equals(this.descriptions, roomTypeLightweightSupplierDetails.descriptions) && Objects.equals(this.multimedias, roomTypeLightweightSupplierDetails.multimedias) && Objects.equals(this.contact, roomTypeLightweightSupplierDetails.contact) && Objects.equals(this.address, roomTypeLightweightSupplierDetails.address) && Objects.equals(this.commissionable, roomTypeLightweightSupplierDetails.commissionable) && Objects.equals(this.name, roomTypeLightweightSupplierDetails.name) && Objects.equals(this.proximityCode, roomTypeLightweightSupplierDetails.proximityCode) && Objects.equals(this.sort, roomTypeLightweightSupplierDetails.sort) && Objects.equals(this.minAgeAppropriateCode, roomTypeLightweightSupplierDetails.minAgeAppropriateCode) && Objects.equals(this.bookable, roomTypeLightweightSupplierDetails.bookable) && Objects.equals(this.active, roomTypeLightweightSupplierDetails.active) && Objects.equals(this.disabilityFeatures, roomTypeLightweightSupplierDetails.disabilityFeatures) && Objects.equals(this.securityFeatures, roomTypeLightweightSupplierDetails.securityFeatures) && Objects.equals(this.socials, roomTypeLightweightSupplierDetails.socials) && Objects.equals((Object)this.pricePoint, (Object)roomTypeLightweightSupplierDetails.pricePoint) && Objects.equals(this.recognitionList, roomTypeLightweightSupplierDetails.recognitionList) && Objects.equals(this.transactionalInventoryList, roomTypeLightweightSupplierDetails.transactionalInventoryList) && Objects.equals(this.maxOccupancy, roomTypeLightweightSupplierDetails.maxOccupancy) && Objects.equals(this.minOccupancy, roomTypeLightweightSupplierDetails.minOccupancy) && Objects.equals(this.quantity, roomTypeLightweightSupplierDetails.quantity) && Objects.equals(this.nonSmoking, roomTypeLightweightSupplierDetails.nonSmoking) && Objects.equals(this.bedroomConfigurationList, roomTypeLightweightSupplierDetails.bedroomConfigurationList) && Objects.equals(this.size, roomTypeLightweightSupplierDetails.size) && Objects.equals(this.maxAdultOccupancy, roomTypeLightweightSupplierDetails.maxAdultOccupancy) && Objects.equals(this.maxChildOccupancy, roomTypeLightweightSupplierDetails.maxChildOccupancy) && Objects.equals(this.bathroomCount, roomTypeLightweightSupplierDetails.bathroomCount) && Objects.equals(this.livingRoomCount, roomTypeLightweightSupplierDetails.livingRoomCount) && Objects.equals(this.maxRollaways, roomTypeLightweightSupplierDetails.maxRollaways) && Objects.equals(this.roomCategory, roomTypeLightweightSupplierDetails.roomCategory) && Objects.equals(this.floor, roomTypeLightweightSupplierDetails.floor) && Objects.equals(this.roomLocationCode, roomTypeLightweightSupplierDetails.roomLocationCode) && Objects.equals(this.roomViewCode, roomTypeLightweightSupplierDetails.roomViewCode) && Objects.equals(this.composite, roomTypeLightweightSupplierDetails.composite) && Objects.equals(this.compositeCount, roomTypeLightweightSupplierDetails.compositeCount) && Objects.equals(this.roomClassificationCode, roomTypeLightweightSupplierDetails.roomClassificationCode) && Objects.equals(this.roomArchitectureCode, roomTypeLightweightSupplierDetails.roomArchitectureCode) && Objects.equals((Object)this.roomGender, (Object)roomTypeLightweightSupplierDetails.roomGender) && Objects.equals(this.sharedRoomInd, roomTypeLightweightSupplierDetails.sharedRoomInd) && Objects.equals(this.maxCribs, roomTypeLightweightSupplierDetails.maxCribs) && Objects.equals(this.amenities, roomTypeLightweightSupplierDetails.amenities) && Objects.equals(this.includedAdultOccupancy, roomTypeLightweightSupplierDetails.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, roomTypeLightweightSupplierDetails.includedChildOccupancy) && Objects.equals(this.baseRate, roomTypeLightweightSupplierDetails.baseRate) && Objects.equals(this.minRate, roomTypeLightweightSupplierDetails.minRate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.transactionalInventoryList, this.maxOccupancy, this.minOccupancy, this.quantity, this.nonSmoking, this.bedroomConfigurationList, this.size, this.maxAdultOccupancy, this.maxChildOccupancy, this.bathroomCount, this.livingRoomCount, this.maxRollaways, this.roomCategory, this.floor, this.roomLocationCode, this.roomViewCode, this.composite, this.compositeCount, this.roomClassificationCode, this.roomArchitectureCode, this.roomGender, this.sharedRoomInd, this.maxCribs, this.amenities, this.includedAdultOccupancy, this.includedChildOccupancy, this.baseRate, this.minRate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomTypeLightweightSupplierDetails {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    transactionalInventoryList: ").append(this.toIndentedString(this.transactionalInventoryList)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    nonSmoking: ").append(this.toIndentedString(this.nonSmoking)).append("\n");
        sb.append("    bedroomConfigurationList: ").append(this.toIndentedString(this.bedroomConfigurationList)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    bathroomCount: ").append(this.toIndentedString(this.bathroomCount)).append("\n");
        sb.append("    livingRoomCount: ").append(this.toIndentedString(this.livingRoomCount)).append("\n");
        sb.append("    maxRollaways: ").append(this.toIndentedString(this.maxRollaways)).append("\n");
        sb.append("    roomCategory: ").append(this.toIndentedString(this.roomCategory)).append("\n");
        sb.append("    floor: ").append(this.toIndentedString(this.floor)).append("\n");
        sb.append("    roomLocationCode: ").append(this.toIndentedString(this.roomLocationCode)).append("\n");
        sb.append("    roomViewCode: ").append(this.toIndentedString(this.roomViewCode)).append("\n");
        sb.append("    composite: ").append(this.toIndentedString(this.composite)).append("\n");
        sb.append("    compositeCount: ").append(this.toIndentedString(this.compositeCount)).append("\n");
        sb.append("    roomClassificationCode: ").append(this.toIndentedString(this.roomClassificationCode)).append("\n");
        sb.append("    roomArchitectureCode: ").append(this.toIndentedString(this.roomArchitectureCode)).append("\n");
        sb.append("    roomGender: ").append(this.toIndentedString((Object)this.roomGender)).append("\n");
        sb.append("    sharedRoomInd: ").append(this.toIndentedString(this.sharedRoomInd)).append("\n");
        sb.append("    maxCribs: ").append(this.toIndentedString(this.maxCribs)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("    baseRate: ").append(this.toIndentedString(this.baseRate)).append("\n");
        sb.append("    minRate: ").append(this.toIndentedString(this.minRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF(String.valueOf("HALF")),
        ONE(String.valueOf("ONE")),
        ONE_HALF(String.valueOf("ONE_HALF")),
        TWO(String.valueOf("TWO")),
        TWO_HALF(String.valueOf("TWO_HALF")),
        THREE(String.valueOf("THREE")),
        THREE_HALF(String.valueOf("THREE_HALF")),
        FOUR(String.valueOf("FOUR")),
        FOUR_HALF(String.valueOf("FOUR_HALF")),
        FIVE(String.valueOf("FIVE"));

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RoomGenderEnum {
        MALE(String.valueOf("Male")),
        FEMALE(String.valueOf("Female")),
        MALE_AND_FEMALE(String.valueOf("MaleAndFemale")),
        UNKNOWN(String.valueOf("Unknown"));

        private String value;

        private RoomGenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoomGenderEnum fromValue(String value) {
            for (RoomGenderEnum b : RoomGenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
        LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
        LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
        LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
        LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
        LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
        LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
        LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
        LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
        LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
        LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
        LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
        LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
        LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
        LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
        LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
        LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
        LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
        LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
        LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
        LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
        LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
        LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

