/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.experiences.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.experiences.invoker.ApiClient;
import travel.wink.sdk.extranet.experiences.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.experiences.model.RefPointViewSupplier;
import travel.wink.sdk.extranet.experiences.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.experiences.model.UpsertPlaceRequestSupplier;

public class PlaceApi {
    private ApiClient apiClient;

    public PlaceApi() {
        this(new ApiClient());
    }

    @Autowired
    public PlaceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createPlaceRequestCreation(String propertyIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertPlaceRequestSupplier postBody = upsertPlaceRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPlaceRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPlaceRequestSupplier' when calling createPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> createPlace(String propertyIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.createPlaceRequestCreation(propertyIdentifier, upsertPlaceRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> createPlaceWithHttpInfo(String propertyIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.createPlaceRequestCreation(propertyIdentifier, upsertPlaceRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createPlaceWithResponseSpec(String propertyIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createPlaceRequestCreation(propertyIdentifier, upsertPlaceRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removePlaceRequestCreation(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling removePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place/{placeIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removePlace(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removePlaceRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removePlaceWithHttpInfo(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removePlaceRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removePlaceWithResponseSpec(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removePlaceRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPlaceRequestCreation(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place/{placeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> showPlace(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.showPlaceRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> showPlaceWithHttpInfo(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.showPlaceRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPlaceWithResponseSpec(String propertyIdentifier, String placeIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPlaceRequestCreation(propertyIdentifier, placeIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPlacePairsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPlacePairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showPlacePairs(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showPlacePairsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showPlacePairsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showPlacePairsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPlacePairsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPlacePairsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPlacesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPlaces", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RefPointViewSupplier> showPlaces(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.showPlacesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RefPointViewSupplier>>> showPlacesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.showPlacesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPlacesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPlacesRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updatePlaceRequestCreation(String propertyIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertPlaceRequestSupplier postBody = upsertPlaceRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertPlaceRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPlaceRequestSupplier' when calling updatePlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place/{placeIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> updatePlace(String propertyIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.updatePlaceRequestCreation(propertyIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> updatePlaceWithHttpInfo(String propertyIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.updatePlaceRequestCreation(propertyIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updatePlaceWithResponseSpec(String propertyIdentifier, String placeIdentifier, UpsertPlaceRequestSupplier upsertPlaceRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updatePlaceRequestCreation(propertyIdentifier, placeIdentifier, upsertPlaceRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadPlaceMediaRequestCreation(String propertyIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadPlaceMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/place/{placeIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RefPointViewSupplier> uploadPlaceMedia(String propertyIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.uploadPlaceMediaRequestCreation(propertyIdentifier, placeIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RefPointViewSupplier>> uploadPlaceMediaWithHttpInfo(String propertyIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RefPointViewSupplier> localVarReturnType = new ParameterizedTypeReference<RefPointViewSupplier>(this){};
        return this.uploadPlaceMediaRequestCreation(propertyIdentifier, placeIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadPlaceMediaWithResponseSpec(String propertyIdentifier, String placeIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadPlaceMediaRequestCreation(propertyIdentifier, placeIdentifier, files);
    }
}

