/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.experiences.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.experiences.invoker.ApiClient;
import travel.wink.sdk.extranet.experiences.model.AttractionView;
import travel.wink.sdk.extranet.experiences.model.KeyValuePair;
import travel.wink.sdk.extranet.experiences.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.experiences.model.UpsertAttractionRequest;

public class AttractionApi {
    private ApiClient apiClient;

    public AttractionApi() {
        this(new ApiClient());
    }

    @Autowired
    public AttractionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAttractionRequestCreation(String propertyIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        UpsertAttractionRequest postBody = upsertAttractionRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAttractionRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAttractionRequest' when calling createAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AttractionView> createAttraction(String propertyIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.createAttractionRequestCreation(propertyIdentifier, upsertAttractionRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AttractionView>> createAttractionWithHttpInfo(String propertyIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.createAttractionRequestCreation(propertyIdentifier, upsertAttractionRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAttractionWithResponseSpec(String propertyIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        return this.createAttractionRequestCreation(propertyIdentifier, upsertAttractionRequest, winkVersion);
    }

    private WebClient.ResponseSpec removeAttractionRequestCreation(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling removeAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction/{attractionIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeAttraction(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeAttractionRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAttractionWithHttpInfo(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeAttractionRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAttractionWithResponseSpec(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeAttractionRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAttractionRequestCreation(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling showAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction/{attractionIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AttractionView> showAttraction(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.showAttractionRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AttractionView>> showAttractionWithHttpInfo(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.showAttractionRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAttractionWithResponseSpec(String propertyIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAttractionRequestCreation(propertyIdentifier, attractionIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAttractionPairsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAttractionPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showAttractionPairs(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.showAttractionPairsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showAttractionPairsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.showAttractionPairsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAttractionPairsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAttractionPairsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAttractionsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAttractions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AttractionView> showAttractions(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.showAttractionsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AttractionView>>> showAttractionsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.showAttractionsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAttractionsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAttractionsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAttractionRequestCreation(String propertyIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        UpsertAttractionRequest postBody = upsertAttractionRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling updateAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAttractionRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAttractionRequest' when calling updateAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction/{attractionIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AttractionView> updateAttraction(String propertyIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.updateAttractionRequestCreation(propertyIdentifier, attractionIdentifier, upsertAttractionRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AttractionView>> updateAttractionWithHttpInfo(String propertyIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.updateAttractionRequestCreation(propertyIdentifier, attractionIdentifier, upsertAttractionRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAttractionWithResponseSpec(String propertyIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        return this.updateAttractionRequestCreation(propertyIdentifier, attractionIdentifier, upsertAttractionRequest, winkVersion);
    }

    private WebClient.ResponseSpec uploadAttractionMediaRequestCreation(String propertyIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadAttractionMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling uploadAttractionMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadAttractionMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/attraction/{attractionIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AttractionView> uploadAttractionMedia(String propertyIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.uploadAttractionMediaRequestCreation(propertyIdentifier, attractionIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AttractionView>> uploadAttractionMediaWithHttpInfo(String propertyIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>(this){};
        return this.uploadAttractionMediaRequestCreation(propertyIdentifier, attractionIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadAttractionMediaWithResponseSpec(String propertyIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadAttractionMediaRequestCreation(propertyIdentifier, attractionIdentifier, files);
    }
}

