/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.experiences.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.experiences.invoker.ApiClient;
import travel.wink.sdk.extranet.experiences.model.Activity;
import travel.wink.sdk.extranet.experiences.model.KeyValuePair;
import travel.wink.sdk.extranet.experiences.model.UpsertActivityRequest;

public class ActivityApi {
    private ApiClient apiClient;

    public ActivityApi() {
        this(new ApiClient());
    }

    @Autowired
    public ActivityApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createActivityRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertActivityRequest postBody = upsertActivityRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityRequest' when calling createActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Activity> createActivity(@Nonnull String propertyIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.createActivityRequestCreation(propertyIdentifier, upsertActivityRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Activity>> createActivityWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.createActivityRequestCreation(propertyIdentifier, upsertActivityRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createActivityWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createActivityRequestCreation(propertyIdentifier, upsertActivityRequest, winkVersion);
    }

    private WebClient.ResponseSpec removeActivityRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling removeActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity/{activityIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Activity> removeActivity(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.removeActivityRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Activity>> removeActivityWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.removeActivityRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeActivityWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeActivityRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showActivitiesRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActivities", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Activity> showActivities(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.showActivitiesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Activity>>> showActivitiesWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.showActivitiesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivitiesWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showActivitiesRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showActivityRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling showActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity/{activityIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Activity> showActivity(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.showActivityRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Activity>> showActivityWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.showActivityRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivityWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showActivityRequestCreation(propertyIdentifier, activityIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showActivityPairsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showActivityPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePair> showActivityPairs(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.showActivityPairsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePair>>> showActivityPairsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>(this){};
        return this.showActivityPairsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivityPairsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showActivityPairsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateActivityRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertActivityRequest postBody = upsertActivityRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertActivityRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertActivityRequest' when calling updateActivity", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity/{activityIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Activity> updateActivity(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.updateActivityRequestCreation(propertyIdentifier, activityIdentifier, upsertActivityRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Activity>> updateActivityWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.updateActivityRequestCreation(propertyIdentifier, activityIdentifier, upsertActivityRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateActivityWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull UpsertActivityRequest upsertActivityRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateActivityRequestCreation(propertyIdentifier, activityIdentifier, upsertActivityRequest, winkVersion);
    }

    private WebClient.ResponseSpec uploadActivityMediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadActivityMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/experience/activity/{activityIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Activity> uploadActivityMedia(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.uploadActivityMediaRequestCreation(propertyIdentifier, activityIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Activity>> uploadActivityMediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<Activity> localVarReturnType = new ParameterizedTypeReference<Activity>(this){};
        return this.uploadActivityMediaRequestCreation(propertyIdentifier, activityIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadActivityMediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String activityIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        return this.uploadActivityMediaRequestCreation(propertyIdentifier, activityIdentifier, files);
    }
}

