/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.facilities.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.facilities.invoker.ApiClient;
import travel.wink.sdk.extranet.facilities.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.facilities.model.MeetingRoomViewSupplier;
import travel.wink.sdk.extranet.facilities.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.facilities.model.UpsertMeetingRoomRequestSupplier;

public class MeetingRoomApi {
    private ApiClient apiClient;

    public MeetingRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public MeetingRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMeetingRoomRequestCreation(String propertyIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertMeetingRoomRequestSupplier postBody = upsertMeetingRoomRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertMeetingRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequestSupplier' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomViewSupplier> createMeetingRoom(String propertyIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.createMeetingRoomRequestCreation(propertyIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomViewSupplier>> createMeetingRoomWithHttpInfo(String propertyIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.createMeetingRoomRequestCreation(propertyIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createMeetingRoomWithResponseSpec(String propertyIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createMeetingRoomRequestCreation(propertyIdentifier, upsertMeetingRoomRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeMeetingRoomRequestCreation(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/{meetingRoomIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeMeetingRoom(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeMeetingRoomWithHttpInfo(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMeetingRoomWithResponseSpec(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeMultimedia1RequestCreation(String propertyIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/{meetingRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomViewSupplier> removeMultimedia1(String propertyIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.removeMultimedia1RequestCreation(propertyIdentifier, meetingRoomIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomViewSupplier>> removeMultimedia1WithHttpInfo(String propertyIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.removeMultimedia1RequestCreation(propertyIdentifier, meetingRoomIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimedia1WithResponseSpec(String propertyIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeMultimedia1RequestCreation(propertyIdentifier, meetingRoomIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMeetingRoomRequestCreation(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomViewSupplier> showMeetingRoom(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.showMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomViewSupplier>> showMeetingRoomWithHttpInfo(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.showMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMeetingRoomWithResponseSpec(String propertyIdentifier, String meetingRoomIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMeetingRoomPairsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMeetingRoomPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showMeetingRoomPairs(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showMeetingRoomPairsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showMeetingRoomPairsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showMeetingRoomPairsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMeetingRoomPairsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showMeetingRoomPairsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMeetingRoomsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMeetingRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<MeetingRoomViewSupplier> showMeetingRooms(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.showMeetingRoomsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<MeetingRoomViewSupplier>>> showMeetingRoomsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.showMeetingRoomsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMeetingRoomsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showMeetingRoomsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateMeetingRoomRequestCreation(String propertyIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertMeetingRoomRequestSupplier postBody = upsertMeetingRoomRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertMeetingRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequestSupplier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/{meetingRoomIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomViewSupplier> updateMeetingRoom(String propertyIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.updateMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomViewSupplier>> updateMeetingRoomWithHttpInfo(String propertyIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.updateMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMeetingRoomWithResponseSpec(String propertyIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateMeetingRoomRequestCreation(propertyIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadMeetingRoomMediaRequestCreation(String propertyIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/meeting-room/{meetingRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MeetingRoomViewSupplier> uploadMeetingRoomMedia(String propertyIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.uploadMeetingRoomMediaRequestCreation(propertyIdentifier, meetingRoomIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MeetingRoomViewSupplier>> uploadMeetingRoomMediaWithHttpInfo(String propertyIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>(this){};
        return this.uploadMeetingRoomMediaRequestCreation(propertyIdentifier, meetingRoomIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadMeetingRoomMediaWithResponseSpec(String propertyIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadMeetingRoomMediaRequestCreation(propertyIdentifier, meetingRoomIdentifier, files);
    }
}

