/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.facilities.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.facilities.model.AddressSupplier;
import travel.wink.sdk.extranet.facilities.model.ContactSupplier;
import travel.wink.sdk.extranet.facilities.model.DowPatternGroupSupplier;
import travel.wink.sdk.extranet.facilities.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.facilities.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.facilities.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.facilities.model.SocialSupplier;
import travel.wink.sdk.extranet.facilities.model.TransactionalTravelInventorySupplier;
import travel.wink.sdk.extranet.facilities.model.TravelInventoryRecognitionSupplier;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "transactionalInventoryList", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "daysOfWeek", "irregular", "meetingRoomCapacity", "access", "meetingRoomTypeCode", "meetingRoomLevel", "dedicatedInd", "area", "height", "width", "length", "amenities"})
@JsonTypeName(value="MeetingRoom_Supplier")
public class MeetingRoomSupplier {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointSupplier location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionSupplier> descriptions = new ArrayList<SimpleDescriptionSupplier>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaSupplier> multimedias = new ArrayList<SimpleMultimediaSupplier>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactSupplier contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressSupplier address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures;
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures;
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialSupplier> socials;
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    private List<TravelInventoryRecognitionSupplier> recognitionList;
    public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
    private List<TransactionalTravelInventorySupplier> transactionalInventoryList;
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    private String closes;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    private DowPatternGroupSupplier daysOfWeek;
    public static final String JSON_PROPERTY_IRREGULAR = "irregular";
    private Boolean irregular = false;
    public static final String JSON_PROPERTY_MEETING_ROOM_CAPACITY = "meetingRoomCapacity";
    private Integer meetingRoomCapacity = 0;
    public static final String JSON_PROPERTY_ACCESS = "access";
    private String access = "MEETING_ROOM_ACCESS_PRIVATE";
    public static final String JSON_PROPERTY_MEETING_ROOM_TYPE_CODE = "meetingRoomTypeCode";
    private String meetingRoomTypeCode;
    public static final String JSON_PROPERTY_MEETING_ROOM_LEVEL = "meetingRoomLevel";
    private String meetingRoomLevel;
    public static final String JSON_PROPERTY_DEDICATED_IND = "dedicatedInd";
    private Boolean dedicatedInd;
    public static final String JSON_PROPERTY_AREA = "area";
    private Float area;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Float height;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width;
    public static final String JSON_PROPERTY_LENGTH = "length";
    private Float length;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities;

    public MeetingRoomSupplier identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public MeetingRoomSupplier hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public MeetingRoomSupplier featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public MeetingRoomSupplier lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public MeetingRoomSupplier location(GeoJsonPointSupplier location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointSupplier getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPointSupplier location) {
        this.location = location;
    }

    public MeetingRoomSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public MeetingRoomSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionSupplier>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionSupplier> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
        this.descriptions = descriptions;
    }

    public MeetingRoomSupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public MeetingRoomSupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaSupplier>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaSupplier> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
        this.multimedias = multimedias;
    }

    public MeetingRoomSupplier contact(ContactSupplier contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactSupplier getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactSupplier contact) {
        this.contact = contact;
    }

    public MeetingRoomSupplier address(AddressSupplier address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressSupplier getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressSupplier address) {
        this.address = address;
    }

    public MeetingRoomSupplier commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public MeetingRoomSupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public MeetingRoomSupplier proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public MeetingRoomSupplier sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public MeetingRoomSupplier minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public MeetingRoomSupplier bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public MeetingRoomSupplier active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public MeetingRoomSupplier disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public MeetingRoomSupplier addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public MeetingRoomSupplier securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public MeetingRoomSupplier addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public MeetingRoomSupplier socials(List<SocialSupplier> socials) {
        this.socials = socials;
        return this;
    }

    public MeetingRoomSupplier addSocialsItem(SocialSupplier socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialSupplier>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialSupplier> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialSupplier> socials) {
        this.socials = socials;
    }

    public MeetingRoomSupplier pricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public MeetingRoomSupplier recognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public MeetingRoomSupplier addRecognitionListItem(TravelInventoryRecognitionSupplier recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionSupplier>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TravelInventoryRecognitionSupplier> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public MeetingRoomSupplier transactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
        return this;
    }

    public MeetingRoomSupplier addTransactionalInventoryListItem(TransactionalTravelInventorySupplier transactionalInventoryListItem) {
        if (this.transactionalInventoryList == null) {
            this.transactionalInventoryList = new ArrayList<TransactionalTravelInventorySupplier>();
        }
        this.transactionalInventoryList.add(transactionalInventoryListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransactionalTravelInventorySupplier> getTransactionalInventoryList() {
        return this.transactionalInventoryList;
    }

    @JsonProperty(value="transactionalInventoryList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
        this.transactionalInventoryList = transactionalInventoryList;
    }

    public MeetingRoomSupplier applicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public MeetingRoomSupplier applicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public MeetingRoomSupplier reservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public MeetingRoomSupplier opens(String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(String opens) {
        this.opens = opens;
    }

    public MeetingRoomSupplier closes(String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(String closes) {
        this.closes = closes;
    }

    public MeetingRoomSupplier daysOfWeek(DowPatternGroupSupplier daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupSupplier getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(DowPatternGroupSupplier daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public MeetingRoomSupplier irregular(Boolean irregular) {
        this.irregular = irregular;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="irregular")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIrregular() {
        return this.irregular;
    }

    @JsonProperty(value="irregular")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIrregular(Boolean irregular) {
        this.irregular = irregular;
    }

    public MeetingRoomSupplier meetingRoomCapacity(Integer meetingRoomCapacity) {
        this.meetingRoomCapacity = meetingRoomCapacity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="meetingRoomCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMeetingRoomCapacity() {
        return this.meetingRoomCapacity;
    }

    @JsonProperty(value="meetingRoomCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMeetingRoomCapacity(Integer meetingRoomCapacity) {
        this.meetingRoomCapacity = meetingRoomCapacity;
    }

    public MeetingRoomSupplier access(String access) {
        this.access = access;
        return this;
    }

    @Nullable
    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccess() {
        return this.access;
    }

    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(String access) {
        this.access = access;
    }

    public MeetingRoomSupplier meetingRoomTypeCode(String meetingRoomTypeCode) {
        this.meetingRoomTypeCode = meetingRoomTypeCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="meetingRoomTypeCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMeetingRoomTypeCode() {
        return this.meetingRoomTypeCode;
    }

    @JsonProperty(value="meetingRoomTypeCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMeetingRoomTypeCode(String meetingRoomTypeCode) {
        this.meetingRoomTypeCode = meetingRoomTypeCode;
    }

    public MeetingRoomSupplier meetingRoomLevel(String meetingRoomLevel) {
        this.meetingRoomLevel = meetingRoomLevel;
        return this;
    }

    @Nullable
    @JsonProperty(value="meetingRoomLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMeetingRoomLevel() {
        return this.meetingRoomLevel;
    }

    @JsonProperty(value="meetingRoomLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRoomLevel(String meetingRoomLevel) {
        this.meetingRoomLevel = meetingRoomLevel;
    }

    public MeetingRoomSupplier dedicatedInd(Boolean dedicatedInd) {
        this.dedicatedInd = dedicatedInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="dedicatedInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getDedicatedInd() {
        return this.dedicatedInd;
    }

    @JsonProperty(value="dedicatedInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDedicatedInd(Boolean dedicatedInd) {
        this.dedicatedInd = dedicatedInd;
    }

    public MeetingRoomSupplier area(Float area) {
        this.area = area;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @JsonProperty(value="area")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getArea() {
        return this.area;
    }

    @JsonProperty(value="area")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setArea(Float area) {
        this.area = area;
    }

    public MeetingRoomSupplier height(Float height) {
        this.height = height;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHeight(Float height) {
        this.height = height;
    }

    public MeetingRoomSupplier width(Float width) {
        this.width = width;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public MeetingRoomSupplier length(Float length) {
        this.length = length;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1.0")
    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1.0") Float getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLength(Float length) {
        this.length = length;
    }

    public MeetingRoomSupplier amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public MeetingRoomSupplier addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeetingRoomSupplier meetingRoomSupplier = (MeetingRoomSupplier)o;
        return Objects.equals(this.identifier, meetingRoomSupplier.identifier) && Objects.equals(this.hotelIdentifier, meetingRoomSupplier.hotelIdentifier) && Objects.equals(this.featuredInd, meetingRoomSupplier.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)meetingRoomSupplier.lifestyleType) && Objects.equals(this.location, meetingRoomSupplier.location) && Objects.equals(this.descriptions, meetingRoomSupplier.descriptions) && Objects.equals(this.multimedias, meetingRoomSupplier.multimedias) && Objects.equals(this.contact, meetingRoomSupplier.contact) && Objects.equals(this.address, meetingRoomSupplier.address) && Objects.equals(this.commissionable, meetingRoomSupplier.commissionable) && Objects.equals(this.name, meetingRoomSupplier.name) && Objects.equals(this.proximityCode, meetingRoomSupplier.proximityCode) && Objects.equals(this.sort, meetingRoomSupplier.sort) && Objects.equals(this.minAgeAppropriateCode, meetingRoomSupplier.minAgeAppropriateCode) && Objects.equals(this.bookable, meetingRoomSupplier.bookable) && Objects.equals(this.active, meetingRoomSupplier.active) && Objects.equals(this.disabilityFeatures, meetingRoomSupplier.disabilityFeatures) && Objects.equals(this.securityFeatures, meetingRoomSupplier.securityFeatures) && Objects.equals(this.socials, meetingRoomSupplier.socials) && Objects.equals((Object)this.pricePoint, (Object)meetingRoomSupplier.pricePoint) && Objects.equals(this.recognitionList, meetingRoomSupplier.recognitionList) && Objects.equals(this.transactionalInventoryList, meetingRoomSupplier.transactionalInventoryList) && Objects.equals(this.applicableStart, meetingRoomSupplier.applicableStart) && Objects.equals(this.applicableEnd, meetingRoomSupplier.applicableEnd) && Objects.equals(this.reservationRequiredInd, meetingRoomSupplier.reservationRequiredInd) && Objects.equals(this.opens, meetingRoomSupplier.opens) && Objects.equals(this.closes, meetingRoomSupplier.closes) && Objects.equals(this.daysOfWeek, meetingRoomSupplier.daysOfWeek) && Objects.equals(this.irregular, meetingRoomSupplier.irregular) && Objects.equals(this.meetingRoomCapacity, meetingRoomSupplier.meetingRoomCapacity) && Objects.equals(this.access, meetingRoomSupplier.access) && Objects.equals(this.meetingRoomTypeCode, meetingRoomSupplier.meetingRoomTypeCode) && Objects.equals(this.meetingRoomLevel, meetingRoomSupplier.meetingRoomLevel) && Objects.equals(this.dedicatedInd, meetingRoomSupplier.dedicatedInd) && Objects.equals(this.area, meetingRoomSupplier.area) && Objects.equals(this.height, meetingRoomSupplier.height) && Objects.equals(this.width, meetingRoomSupplier.width) && Objects.equals(this.length, meetingRoomSupplier.length) && Objects.equals(this.amenities, meetingRoomSupplier.amenities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.transactionalInventoryList, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.daysOfWeek, this.irregular, this.meetingRoomCapacity, this.access, this.meetingRoomTypeCode, this.meetingRoomLevel, this.dedicatedInd, this.area, this.height, this.width, this.length, this.amenities});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeetingRoomSupplier {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    transactionalInventoryList: ").append(this.toIndentedString(this.transactionalInventoryList)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    irregular: ").append(this.toIndentedString(this.irregular)).append("\n");
        sb.append("    meetingRoomCapacity: ").append(this.toIndentedString(this.meetingRoomCapacity)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    meetingRoomTypeCode: ").append(this.toIndentedString(this.meetingRoomTypeCode)).append("\n");
        sb.append("    meetingRoomLevel: ").append(this.toIndentedString(this.meetingRoomLevel)).append("\n");
        sb.append("    dedicatedInd: ").append(this.toIndentedString(this.dedicatedInd)).append("\n");
        sb.append("    area: ").append(this.toIndentedString(this.area)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF("HALF"),
        ONE("ONE"),
        ONE_HALF("ONE_HALF"),
        TWO("TWO"),
        TWO_HALF("TWO_HALF"),
        THREE("THREE"),
        THREE_HALF("THREE_HALF"),
        FOUR("FOUR"),
        FOUR_HALF("FOUR_HALF"),
        FIVE("FIVE");

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

