/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.facilities.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.facilities.invoker.ApiClient;
import travel.wink.sdk.extranet.facilities.model.DuplicateGuestRoomRequestSupplier;
import travel.wink.sdk.extranet.facilities.model.ImproveRoomTypeRequestSupplier;
import travel.wink.sdk.extranet.facilities.model.ImproveRoomTypeResponseSupplier;
import travel.wink.sdk.extranet.facilities.model.RoomType;
import travel.wink.sdk.extranet.facilities.model.RoomTypeSupplier;
import travel.wink.sdk.extranet.facilities.model.UpsertRoomTypeRequestSupplier;

public class GuestRoomApi {
    private ApiClient apiClient;

    public GuestRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public GuestRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createGuestRoomRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRoomTypeRequestSupplier postBody = upsertRoomTypeRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRoomTypeRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRoomTypeRequestSupplier' when calling createGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomTypeSupplier> createGuestRoom(@Nonnull String propertyIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.createGuestRoomRequestCreation(propertyIdentifier, upsertRoomTypeRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomTypeSupplier>> createGuestRoomWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.createGuestRoomRequestCreation(propertyIdentifier, upsertRoomTypeRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createGuestRoomWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createGuestRoomRequestCreation(propertyIdentifier, upsertRoomTypeRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec duplicateGuestRoomRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        DuplicateGuestRoomRequestSupplier postBody = duplicateGuestRoomRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (duplicateGuestRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'duplicateGuestRoomRequestSupplier' when calling duplicateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}/duplicate", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomTypeSupplier> duplicateGuestRoom(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.duplicateGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, duplicateGuestRoomRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomTypeSupplier>> duplicateGuestRoomWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.duplicateGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, duplicateGuestRoomRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec duplicateGuestRoomWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull DuplicateGuestRoomRequestSupplier duplicateGuestRoomRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.duplicateGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, duplicateGuestRoomRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec improveGuestRoomRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull ImproveRoomTypeRequestSupplier improveRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ImproveRoomTypeRequestSupplier postBody = improveRoomTypeRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling improveGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling improveGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (improveRoomTypeRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'improveRoomTypeRequestSupplier' when calling improveGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ImproveRoomTypeResponseSupplier> localVarReturnType = new ParameterizedTypeReference<ImproveRoomTypeResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}/improve", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ImproveRoomTypeResponseSupplier> improveGuestRoom(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull ImproveRoomTypeRequestSupplier improveRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ImproveRoomTypeResponseSupplier> localVarReturnType = new ParameterizedTypeReference<ImproveRoomTypeResponseSupplier>(this){};
        return this.improveGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, improveRoomTypeRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ImproveRoomTypeResponseSupplier>> improveGuestRoomWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull ImproveRoomTypeRequestSupplier improveRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ImproveRoomTypeResponseSupplier> localVarReturnType = new ParameterizedTypeReference<ImproveRoomTypeResponseSupplier>(this){};
        return this.improveGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, improveRoomTypeRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec improveGuestRoomWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull ImproveRoomTypeRequestSupplier improveRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.improveGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, improveRoomTypeRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeGuestRoomRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling removeGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomType> localVarReturnType = new ParameterizedTypeReference<RoomType>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomType> removeGuestRoom(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomType> localVarReturnType = new ParameterizedTypeReference<RoomType>(this){};
        return this.removeGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomType>> removeGuestRoomWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomType> localVarReturnType = new ParameterizedTypeReference<RoomType>(this){};
        return this.removeGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeGuestRoomWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomType> localVarReturnType = new ParameterizedTypeReference<RoomType>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomType> removeMultimedia(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomType> localVarReturnType = new ParameterizedTypeReference<RoomType>(this){};
        return this.removeMultimediaRequestCreation(propertyIdentifier, roomTypeIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomType>> removeMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomType> localVarReturnType = new ParameterizedTypeReference<RoomType>(this){};
        return this.removeMultimediaRequestCreation(propertyIdentifier, roomTypeIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeMultimediaRequestCreation(propertyIdentifier, roomTypeIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showGuestRoomRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling showGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomTypeSupplier> showGuestRoom(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.showGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomTypeSupplier>> showGuestRoomWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.showGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGuestRoomWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showGuestRoomsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showGuestRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RoomTypeSupplier> showGuestRooms(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.showGuestRoomsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RoomTypeSupplier>>> showGuestRoomsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.showGuestRoomsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showGuestRoomsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showGuestRoomsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateGuestRoomRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRoomTypeRequestSupplier postBody = upsertRoomTypeRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRoomTypeRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRoomTypeRequestSupplier' when calling updateGuestRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomTypeSupplier> updateGuestRoom(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.updateGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, upsertRoomTypeRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomTypeSupplier>> updateGuestRoomWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.updateGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, upsertRoomTypeRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateGuestRoomWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull UpsertRoomTypeRequestSupplier upsertRoomTypeRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateGuestRoomRequestCreation(propertyIdentifier, roomTypeIdentifier, upsertRoomTypeRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadGuestRoomMediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadGuestRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/room-type/{roomTypeIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RoomTypeSupplier> uploadGuestRoomMedia(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.uploadGuestRoomMediaRequestCreation(propertyIdentifier, roomTypeIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RoomTypeSupplier>> uploadGuestRoomMediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RoomTypeSupplier> localVarReturnType = new ParameterizedTypeReference<RoomTypeSupplier>(this){};
        return this.uploadGuestRoomMediaRequestCreation(propertyIdentifier, roomTypeIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadGuestRoomMediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String roomTypeIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        return this.uploadGuestRoomMediaRequestCreation(propertyIdentifier, roomTypeIdentifier, files);
    }
}

