/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.facilities.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.facilities.invoker.ApiClient;
import travel.wink.sdk.extranet.facilities.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.facilities.model.RestaurantSupplier;
import travel.wink.sdk.extranet.facilities.model.UpsertRestaurantRequestSupplier;

public class RestaurantApi {
    private ApiClient apiClient;

    public RestaurantApi() {
        this(new ApiClient());
    }

    @Autowired
    public RestaurantApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRestaurantRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRestaurantRequestSupplier postBody = upsertRestaurantRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRestaurantRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRestaurantRequestSupplier' when calling createRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantSupplier> createRestaurant(@Nonnull String propertyIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.createRestaurantRequestCreation(propertyIdentifier, upsertRestaurantRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantSupplier>> createRestaurantWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.createRestaurantRequestCreation(propertyIdentifier, upsertRestaurantRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRestaurantWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createRestaurantRequestCreation(propertyIdentifier, upsertRestaurantRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeMultimedia1RequestCreation(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/{restaurantIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantSupplier> removeMultimedia1(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.removeMultimedia1RequestCreation(propertyIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantSupplier>> removeMultimedia1WithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.removeMultimedia1RequestCreation(propertyIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimedia1WithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeMultimedia1RequestCreation(propertyIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeRestaurantRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling removeRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/{restaurantIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantSupplier> removeRestaurant(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.removeRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantSupplier>> removeRestaurantWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.removeRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRestaurantWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling showRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/{restaurantIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantSupplier> showRestaurant(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.showRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantSupplier>> showRestaurantWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.showRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantPairsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRestaurantPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showRestaurantPairs(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showRestaurantPairsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showRestaurantPairsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showRestaurantPairsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantPairsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRestaurantPairsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRestaurantsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRestaurants", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RestaurantSupplier> showRestaurants(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.showRestaurantsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RestaurantSupplier>>> showRestaurantsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.showRestaurantsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRestaurantsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRestaurantRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRestaurantRequestSupplier postBody = upsertRestaurantRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRestaurantRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRestaurantRequestSupplier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/{restaurantIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantSupplier> updateRestaurant(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.updateRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantSupplier>> updateRestaurantWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.updateRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRestaurantWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateRestaurantRequestCreation(propertyIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadRestaurantMediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/restaurant/{restaurantIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RestaurantSupplier> uploadRestaurantMedia(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.uploadRestaurantMediaRequestCreation(propertyIdentifier, restaurantIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RestaurantSupplier>> uploadRestaurantMediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantSupplier>(this){};
        return this.uploadRestaurantMediaRequestCreation(propertyIdentifier, restaurantIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadRestaurantMediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String restaurantIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        return this.uploadRestaurantMediaRequestCreation(propertyIdentifier, restaurantIdentifier, files);
    }
}

