/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.facilities.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.facilities.invoker.ApiClient;
import travel.wink.sdk.extranet.facilities.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.facilities.model.SpaSupplier;
import travel.wink.sdk.extranet.facilities.model.UpsertSpaRequestSupplier;

public class SpaApi {
    private ApiClient apiClient;

    public SpaApi() {
        this(new ApiClient());
    }

    @Autowired
    public SpaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSpaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSpaRequestSupplier postBody = upsertSpaRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSpaRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSpaRequestSupplier' when calling createSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpaSupplier> createSpa(@Nonnull String propertyIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.createSpaRequestCreation(propertyIdentifier, upsertSpaRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpaSupplier>> createSpaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.createSpaRequestCreation(propertyIdentifier, upsertSpaRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSpaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSpaRequestCreation(propertyIdentifier, upsertSpaRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec deleteMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling deleteMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling deleteMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling deleteMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/{spaIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpaSupplier> deleteMultimedia(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.deleteMultimediaRequestCreation(propertyIdentifier, spaIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpaSupplier>> deleteMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.deleteMultimediaRequestCreation(propertyIdentifier, spaIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.deleteMultimediaRequestCreation(propertyIdentifier, spaIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeSpaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling removeSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/{spaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpaSupplier> removeSpa(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.removeSpaRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpaSupplier>> removeSpaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.removeSpaRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSpaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSpaRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSpaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling showSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/{spaIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpaSupplier> showSpa(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.showSpaRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpaSupplier>> showSpaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.showSpaRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSpaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSpaRequestCreation(propertyIdentifier, spaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSpaPairsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSpaPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/list/pair", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showSpaPairs(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showSpaPairsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showSpaPairsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showSpaPairsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSpaPairsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSpaPairsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSpasRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showSpas", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SpaSupplier> showSpas(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.showSpasRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SpaSupplier>>> showSpasWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.showSpasRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSpasWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSpasRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSpaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSpaRequestSupplier postBody = upsertSpaRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling updateSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSpaRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSpaRequestSupplier' when calling updateSpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/{spaIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpaSupplier> updateSpa(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.updateSpaRequestCreation(propertyIdentifier, spaIdentifier, upsertSpaRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpaSupplier>> updateSpaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.updateSpaRequestCreation(propertyIdentifier, spaIdentifier, upsertSpaRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSpaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull UpsertSpaRequestSupplier upsertSpaRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSpaRequestCreation(propertyIdentifier, spaIdentifier, upsertSpaRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadSpaMediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadSpaMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling uploadSpaMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadSpaMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/facility/spa/{spaIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpaSupplier> uploadSpaMedia(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.uploadSpaMediaRequestCreation(propertyIdentifier, spaIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpaSupplier>> uploadSpaMediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<SpaSupplier> localVarReturnType = new ParameterizedTypeReference<SpaSupplier>(this){};
        return this.uploadSpaMediaRequestCreation(propertyIdentifier, spaIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadSpaMediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String spaIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        return this.uploadSpaMediaRequestCreation(propertyIdentifier, spaIdentifier, files);
    }
}

