/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.facilities.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.facilities.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.facilities.model.SimpleDescription;
import travel.wink.sdk.extranet.facilities.model.SimpleMultimedia;

@JsonPropertyOrder(value={"identifier", "name", "descriptions", "pricingType", "basePrice", "discountedPrice", "multimedias", "minPax", "maxPax", "percentDiscount", "percentPremium"})
public class TransactionalTravelInventory {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private UUID identifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
    @Nonnull
    private PricingTypeEnum pricingType;
    public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
    @Nonnull
    private CustomMonetaryAmount basePrice;
    public static final String JSON_PROPERTY_DISCOUNTED_PRICE = "discountedPrice";
    @Nonnull
    private CustomMonetaryAmount discountedPrice;
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    @Nullable
    private List<@Valid SimpleMultimedia> multimedias = new ArrayList<SimpleMultimedia>();
    public static final String JSON_PROPERTY_MIN_PAX = "minPax";
    @Nullable
    private Integer minPax;
    public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
    @Nullable
    private Integer maxPax;
    public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
    @Nullable
    private Float percentDiscount;
    public static final String JSON_PROPERTY_PERCENT_PREMIUM = "percentPremium";
    @Nullable
    private Float percentPremium;

    public TransactionalTravelInventory identifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
    }

    public TransactionalTravelInventory name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public TransactionalTravelInventory descriptions(@Nonnull List<@Valid SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public TransactionalTravelInventory addDescriptionsItem(SimpleDescription descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescription>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public TransactionalTravelInventory pricingType(@Nonnull PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    @JsonProperty(value="pricingType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricingType(@Nonnull PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public TransactionalTravelInventory basePrice(@Nonnull CustomMonetaryAmount basePrice) {
        this.basePrice = basePrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getBasePrice() {
        return this.basePrice;
    }

    @JsonProperty(value="basePrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBasePrice(@Nonnull CustomMonetaryAmount basePrice) {
        this.basePrice = basePrice;
    }

    public TransactionalTravelInventory discountedPrice(@Nonnull CustomMonetaryAmount discountedPrice) {
        this.discountedPrice = discountedPrice;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="discountedPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CustomMonetaryAmount getDiscountedPrice() {
        return this.discountedPrice;
    }

    @JsonProperty(value="discountedPrice")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDiscountedPrice(@Nonnull CustomMonetaryAmount discountedPrice) {
        this.discountedPrice = discountedPrice;
    }

    public TransactionalTravelInventory multimedias(@Nullable List<@Valid SimpleMultimedia> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public TransactionalTravelInventory addMultimediasItem(SimpleMultimedia multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimedia>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SimpleMultimedia> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultimedias(@Nullable List<@Valid SimpleMultimedia> multimedias) {
        this.multimedias = multimedias;
    }

    public TransactionalTravelInventory minPax(@Nullable Integer minPax) {
        this.minPax = minPax;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) Integer getMinPax() {
        return this.minPax;
    }

    @JsonProperty(value="minPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinPax(@Nullable Integer minPax) {
        this.minPax = minPax;
    }

    public TransactionalTravelInventory maxPax(@Nullable Integer maxPax) {
        this.maxPax = maxPax;
        return this;
    }

    @Nullable
    @Min(value=0L)
    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Min(value=0L) Integer getMaxPax() {
        return this.maxPax;
    }

    @JsonProperty(value="maxPax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxPax(@Nullable Integer maxPax) {
        this.maxPax = maxPax;
    }

    public TransactionalTravelInventory percentDiscount(@Nullable Float percentDiscount) {
        this.percentDiscount = percentDiscount;
        return this;
    }

    @Nullable
    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPercentDiscount() {
        return this.percentDiscount;
    }

    @JsonProperty(value="percentDiscount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentDiscount(@Nullable Float percentDiscount) {
        this.percentDiscount = percentDiscount;
    }

    public TransactionalTravelInventory percentPremium(@Nullable Float percentPremium) {
        this.percentPremium = percentPremium;
        return this;
    }

    @Nullable
    @JsonProperty(value="percentPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPercentPremium() {
        return this.percentPremium;
    }

    @JsonProperty(value="percentPremium")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPercentPremium(@Nullable Float percentPremium) {
        this.percentPremium = percentPremium;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionalTravelInventory transactionalTravelInventory = (TransactionalTravelInventory)o;
        return Objects.equals(this.identifier, transactionalTravelInventory.identifier) && Objects.equals(this.name, transactionalTravelInventory.name) && Objects.equals(this.descriptions, transactionalTravelInventory.descriptions) && Objects.equals((Object)this.pricingType, (Object)transactionalTravelInventory.pricingType) && Objects.equals(this.basePrice, transactionalTravelInventory.basePrice) && Objects.equals(this.discountedPrice, transactionalTravelInventory.discountedPrice) && Objects.equals(this.multimedias, transactionalTravelInventory.multimedias) && Objects.equals(this.minPax, transactionalTravelInventory.minPax) && Objects.equals(this.maxPax, transactionalTravelInventory.maxPax) && Objects.equals(this.percentDiscount, transactionalTravelInventory.percentDiscount) && Objects.equals(this.percentPremium, transactionalTravelInventory.percentPremium);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.name, this.descriptions, this.pricingType, this.basePrice, this.discountedPrice, this.multimedias, this.minPax, this.maxPax, this.percentDiscount, this.percentPremium});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionalTravelInventory {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    basePrice: ").append(this.toIndentedString(this.basePrice)).append("\n");
        sb.append("    discountedPrice: ").append(this.toIndentedString(this.discountedPrice)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    minPax: ").append(this.toIndentedString(this.minPax)).append("\n");
        sb.append("    maxPax: ").append(this.toIndentedString(this.maxPax)).append("\n");
        sb.append("    percentDiscount: ").append(this.toIndentedString(this.percentDiscount)).append("\n");
        sb.append("    percentPremium: ").append(this.toIndentedString(this.percentPremium)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricingTypeEnum {
        PER_STAY(String.valueOf("PER_STAY")),
        PER_DAY(String.valueOf("PER_DAY")),
        PER_NIGHT(String.valueOf("PER_NIGHT")),
        PER_USE(String.valueOf("PER_USE")),
        PER_HOUR(String.valueOf("PER_HOUR")),
        PER_PERSON(String.valueOf("PER_PERSON")),
        PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
        PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
        PER_ADULT(String.valueOf("PER_ADULT")),
        PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
        PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
        PER_CHILD(String.valueOf("PER_CHILD")),
        PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
        PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String value) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

