package travel.wink.sdk.extranet.monetize.api;

import travel.wink.sdk.extranet.monetize.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.monetize.model.GenericErrorMessage;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.monetize.model.ShowAddOn400Response;
import travel.wink.sdk.extranet.monetize.model.SimpleMultimedia;
import travel.wink.sdk.extranet.monetize.model.UpgradeView;
import travel.wink.sdk.extranet.monetize.model.UpsertAddOnRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:03:43.239796474+07:00[Asia/Bangkok]")
public class AddOnApi {
    private ApiClient apiClient;

    public AddOnApi() {
        this(new ApiClient());
    }

    @Autowired
    public AddOnApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Add multimedia record to add-on record owned by this property identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addMultimediaRequestCreation(String propertyIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimedia;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimedia' is set
        if (simpleMultimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimedia' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Add multimedia record to add-on record owned by this property identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> addMultimedia(String propertyIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return addMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, simpleMultimedia, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Add multimedia record to add-on record owned by this property identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> addMultimediaWithHttpInfo(String propertyIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return addMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, simpleMultimedia, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Add multimedia record to add-on record owned by this property identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addMultimediaWithResponseSpec(String propertyIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        return addMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, simpleMultimedia, winkVersion);
    }
    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new add-on record owned by this property identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAddOnRequestCreation(String propertyIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddOnRequest;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddOnRequest' is set
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new add-on record owned by this property identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> createAddOn(String propertyIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return createAddOnRequestCreation(propertyIdentifier, upsertAddOnRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new add-on record owned by this property identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> createAddOnWithHttpInfo(String propertyIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return createAddOnRequestCreation(propertyIdentifier, upsertAddOnRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new add-on record owned by this property identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAddOnWithResponseSpec(String propertyIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        return createAddOnRequestCreation(propertyIdentifier, upsertAddOnRequest, winkVersion);
    }
    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove add-on record owned by this property identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAddOnRequestCreation(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove add-on record owned by this property identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAddOn(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove add-on record owned by this property identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeAddOnWithHttpInfo(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove add-on record owned by this property identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAddOnWithResponseSpec(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept);
    }
    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a media record from an existing add-on owned by this property identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimediaRequestCreation(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a media record from an existing add-on owned by this property identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> removeMultimedia(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return removeMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a media record from an existing add-on owned by this property identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> removeMultimediaWithHttpInfo(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return removeMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a media record from an existing add-on owned by this property identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMultimediaWithResponseSpec(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion, accept);
    }
    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single add-on owned by this property identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnRequestCreation(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single add-on owned by this property identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> showAddOn(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single add-on owned by this property identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> showAddOnWithHttpInfo(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single add-on owned by this property identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAddOnWithResponseSpec(String propertyIdentifier, String addOnIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept);
    }
    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show add-ons owned by this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAddOns", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show add-ons owned by this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<UpgradeView> showAddOns(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show add-ons owned by this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;UpgradeView&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<UpgradeView>>> showAddOnsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show add-ons owned by this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAddOnsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAddOnsRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing add-on record owned by this property identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddOnRequestCreation(String propertyIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddOnRequest;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddOnRequest' is set
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing add-on record owned by this property identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> updateAddOn(String propertyIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnRequestCreation(propertyIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing add-on record owned by this property identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> updateAddOnWithHttpInfo(String propertyIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnRequestCreation(propertyIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing add-on record owned by this property identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAddOnWithResponseSpec(String propertyIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        return updateAddOnRequestCreation(propertyIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion);
    }
    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing multimedia record on add-on record owned by this property identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddOnMultimediaRequestCreation(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimedia;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimedia' is set
        if (simpleMultimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimedia' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing multimedia record on add-on record owned by this property identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> updateAddOnMultimedia(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing multimedia record on add-on record owned by this property identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> updateAddOnMultimediaWithHttpInfo(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing multimedia record on add-on record owned by this property identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAddOnMultimediaWithResponseSpec(String propertyIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        return updateAddOnMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Upload multipart files and associate them with an existing add-on owned by this property identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadBinaryAddOnMediaRequestCreation(String propertyIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Upload multipart files and associate them with an existing add-on owned by this property identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> uploadBinaryAddOnMedia(String propertyIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return uploadBinaryAddOnMediaRequestCreation(propertyIdentifier, addOnIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Upload multipart files and associate them with an existing add-on owned by this property identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> uploadBinaryAddOnMediaWithHttpInfo(String propertyIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return uploadBinaryAddOnMediaRequestCreation(propertyIdentifier, addOnIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Upload multipart files and associate them with an existing add-on owned by this property identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadBinaryAddOnMediaWithResponseSpec(String propertyIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        return uploadBinaryAddOnMediaRequestCreation(propertyIdentifier, addOnIdentifier, files);
    }
}
