package travel.wink.sdk.extranet.monetize.api;

import travel.wink.sdk.extranet.monetize.invoker.ApiClient;

import travel.wink.sdk.extranet.monetize.model.CancellationPolicyRemovableResponseSupplier;
import travel.wink.sdk.extranet.monetize.model.CancellationPolicyViewSupplier;
import travel.wink.sdk.extranet.monetize.model.GenericErrorMessage;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.monetize.model.ShowAddOn400Response;
import travel.wink.sdk.extranet.monetize.model.UpsertCancellationPolicyRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:03:43.239796474+07:00[Asia/Bangkok]")
public class CancellationPolicyApi {
    private ApiClient apiClient;

    public CancellationPolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CancellationPolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create cancellation policy and associate it with by this property identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCancellationPolicyRequestCreation(String propertyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCancellationPolicyRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCancellationPolicyRequestSupplier' is set
        if (upsertCancellationPolicyRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequestSupplier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/cancellationpolicy", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create cancellation policy and associate it with by this property identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyViewSupplier> createCancellationPolicy(String propertyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return createCancellationPolicyRequestCreation(propertyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create cancellation policy and associate it with by this property identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> createCancellationPolicyWithHttpInfo(String propertyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return createCancellationPolicyRequestCreation(propertyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Cancellation Policy
     * Create a new cancellation policy
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create cancellation policy and associate it with by this property identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCancellationPolicyWithResponseSpec(String propertyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createCancellationPolicyRequestCreation(propertyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion);
    }
    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Verify if cancellation policy is removable and owned by this property identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CancellationPolicyRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isCancellationPolicyRemovableRequestCreation(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Verify if cancellation policy is removable and owned by this property identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CancellationPolicyRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyRemovableResponseSupplier> isCancellationPolicyRemovable(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>() {};
        return isCancellationPolicyRemovableRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Verify if cancellation policy is removable and owned by this property identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CancellationPolicyRemovableResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyRemovableResponseSupplier>> isCancellationPolicyRemovableWithHttpInfo(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>() {};
        return isCancellationPolicyRemovableRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a cancellation policy is removable. If a cancellation policy is associated / linked with a rate plan, it cannot be removed until the associated entity removes it first.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Verify if cancellation policy is removable and owned by this property identifier.
     * @param cancellationPolicyIdentifier Verify if cancellation policy is removable identified by this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isCancellationPolicyRemovableWithResponseSpec(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return isCancellationPolicyRemovableRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept);
    }
    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCancellationPolicyRequestCreation(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeCancellationPolicy(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeCancellationPolicyWithHttpInfo(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Cancellation Policy
     * Delete a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Delete cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCancellationPolicyWithResponseSpec(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept);
    }
    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCancellationPolicyRequestCreation(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyViewSupplier> showCancellationPolicy(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> showCancellationPolicyWithHttpInfo(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Cancellation Policy
     * Retrieve a cancellation policy by its identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Show single cancellation policy with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCancellationPolicyWithResponseSpec(String propertyIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, winkVersion, accept);
    }
    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier List all cancellation policies for this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCancellationPolicyListRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showCancellationPolicyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/cancellationpolicy/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier List all cancellation policies for this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CancellationPolicyViewSupplier> showCancellationPolicyList(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyListRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier List all cancellation policies for this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;CancellationPolicyViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CancellationPolicyViewSupplier>>> showCancellationPolicyListWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return showCancellationPolicyListRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Cancellation Policies
     * Retrieve list of cancellation policies for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier List all cancellation policies for this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCancellationPolicyListWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showCancellationPolicyListRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCancellationPolicyRequestCreation(String propertyIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCancellationPolicyRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'cancellationPolicyIdentifier' is set
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCancellationPolicyRequestSupplier' is set
        if (upsertCancellationPolicyRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequestSupplier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CancellationPolicyViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CancellationPolicyViewSupplier> updateCancellationPolicy(String propertyIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return updateCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CancellationPolicyViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> updateCancellationPolicyWithHttpInfo(String propertyIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>() {};
        return updateCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Cancellation Policy
     * Update a cancellation policy by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing cancellation policy owned by this property identifier.
     * @param cancellationPolicyIdentifier Update an existing cancellation policy with this identifier.
     * @param upsertCancellationPolicyRequestSupplier The upsertCancellationPolicyRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCancellationPolicyWithResponseSpec(String propertyIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateCancellationPolicyRequestCreation(propertyIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion);
    }
}
