package travel.wink.sdk.extranet.monetize.api;

import travel.wink.sdk.extranet.monetize.invoker.ApiClient;

import travel.wink.sdk.extranet.monetize.model.GenericErrorMessage;
import travel.wink.sdk.extranet.monetize.model.MasterRateViewSupplier;
import travel.wink.sdk.extranet.monetize.model.SetMasterRatePerkRequestSupplier;
import travel.wink.sdk.extranet.monetize.model.ShowAddOn400Response;
import travel.wink.sdk.extranet.monetize.model.ToggleMasterRateRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:03:43.239796474+07:00[Asia/Bangkok]")
public class MasterRateApi {
    private ApiClient apiClient;

    public MasterRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public MasterRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec setPerksRequestCreation(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = setMasterRatePerkRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'setMasterRatePerkRequestSupplier' is set
        if (setMasterRatePerkRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'setMasterRatePerkRequestSupplier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/perks", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> setPerks(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return setPerksRequestCreation(propertyIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> setPerksWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return setPerksRequestCreation(propertyIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec setPerksWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        return setPerksRequestCreation(propertyIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion);
    }
    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single master rate owned by this property identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single master rate owned by this property identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> showMasterRate(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single master rate owned by this property identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> showMasterRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single master rate owned by this property identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMasterRateWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, winkVersion, accept);
    }
    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all master rates owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRatesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all master rates owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MasterRateViewSupplier> showMasterRates(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all master rates owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;MasterRateViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MasterRateViewSupplier>>> showMasterRatesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all master rates owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMasterRatesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec toggleMasterRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = toggleMasterRateRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'toggleMasterRateRequestSupplier' is set
        if (toggleMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'toggleMasterRateRequestSupplier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/toggle", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> toggleMasterRate(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return toggleMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> toggleMasterRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return toggleMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing master rate owned by this property identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec toggleMasterRateWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return toggleMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion);
    }
}
