package travel.wink.sdk.extranet.monetize.api;

import travel.wink.sdk.extranet.monetize.invoker.ApiClient;

import travel.wink.sdk.extranet.monetize.model.GenericErrorMessage;
import travel.wink.sdk.extranet.monetize.model.RatePlanViewSupplier;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.monetize.model.ShowAddOn400Response;
import travel.wink.sdk.extranet.monetize.model.UpsertRatePlanRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:03:43.239796474+07:00[Asia/Bangkok]")
public class RatePlanApi {
    private ApiClient apiClient;

    public RatePlanApi() {
        this(new ApiClient());
    }

    @Autowired
    public RatePlanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new rate plan and associate it with this property identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRatePlanRequestCreation(String propertyIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRatePlanRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRatePlanRequestSupplier' is set
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/rateplan", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new rate plan and associate it with this property identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanViewSupplier> createRatePlan(String propertyIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return createRatePlanRequestCreation(propertyIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new rate plan and associate it with this property identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanViewSupplier>> createRatePlanWithHttpInfo(String propertyIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return createRatePlanRequestCreation(propertyIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Rate Plan
     * Create a new rate plan
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create a new rate plan and associate it with this property identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createRatePlanWithResponseSpec(String propertyIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createRatePlanRequestCreation(propertyIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }
    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove rate plan owned by this property identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRatePlanRequestCreation(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove rate plan owned by this property identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRatePlan(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove rate plan owned by this property identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRatePlanWithHttpInfo(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Rate Plan
     * Remove a rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove rate plan owned by this property identifier.
     * @param ratePlanIdentifier Remove rate plan with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRatePlanWithResponseSpec(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept);
    }
    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single rate plan owned by this property identifier.
     * @param ratePlanIdentifier Show rate plan with this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlanRequestCreation(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single rate plan owned by this property identifier.
     * @param ratePlanIdentifier Show rate plan with this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanViewSupplier> showRatePlan(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single rate plan owned by this property identifier.
     * @param ratePlanIdentifier Show rate plan with this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanViewSupplier>> showRatePlanWithHttpInfo(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Rate Plan
     * Retrieve a single rate plan identified by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single rate plan owned by this property identifier.
     * @param ratePlanIdentifier Show rate plan with this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRatePlanWithResponseSpec(String propertyIdentifier, String ratePlanIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept);
    }
    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of rate plans owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlansRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRatePlans", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/rateplan/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of rate plans owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RatePlanViewSupplier> showRatePlans(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlansRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of rate plans owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;RatePlanViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RatePlanViewSupplier>>> showRatePlansWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return showRatePlansRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Rate Plans
     * Retrieve list of rate plans for property.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of rate plans owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRatePlansWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRatePlansRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing rate plan owned by this property identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRatePlanRequestCreation(String propertyIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRatePlanRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRatePlanRequestSupplier' is set
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/rateplan/{ratePlanIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing rate plan owned by this property identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RatePlanViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RatePlanViewSupplier> updateRatePlan(String propertyIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return updateRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing rate plan owned by this property identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RatePlanViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RatePlanViewSupplier>> updateRatePlanWithHttpInfo(String propertyIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanViewSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanViewSupplier>() {};
        return updateRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Rate Plan
     * Update an existing rate plan by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update an existing rate plan owned by this property identifier.
     * @param ratePlanIdentifier Update an existing rate plan identified with this identifier.
     * @param upsertRatePlanRequestSupplier The upsertRatePlanRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRatePlanWithResponseSpec(String propertyIdentifier, String ratePlanIdentifier, UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }
}
