/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Extranet Monetize API This part of the documentation concerns itself with the management of cancellation policies, promotions, restrictions etc. This API lets you create:  1. Add-ons: Manage add-ons. 2. Cancellation policies: Manage cancellation policies for your property. 3. Rate plan: Manage property rate plans. 4. Master rates: Manage perks for room type / rate plan combos. 5. Promotions: Manage promotions. 6. Promotion bundle: Manage bundled promotions.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.monetize.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Indicate which days this inventory is open.
 */
@JsonPropertyOrder({
  DowPatternGroup.JSON_PROPERTY_MON,
  DowPatternGroup.JSON_PROPERTY_TUE,
  DowPatternGroup.JSON_PROPERTY_WED,
  DowPatternGroup.JSON_PROPERTY_THU,
  DowPatternGroup.JSON_PROPERTY_FRI,
  DowPatternGroup.JSON_PROPERTY_SAT,
  DowPatternGroup.JSON_PROPERTY_SUN,
  DowPatternGroup.JSON_PROPERTY_DISABLED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:03:43.239796474+07:00[Asia/Bangkok]")
public class DowPatternGroup {
  public static final String JSON_PROPERTY_MON = "mon";
  private Boolean mon;

  public static final String JSON_PROPERTY_TUE = "tue";
  private Boolean tue;

  public static final String JSON_PROPERTY_WED = "wed";
  private Boolean wed;

  public static final String JSON_PROPERTY_THU = "thu";
  private Boolean thu;

  public static final String JSON_PROPERTY_FRI = "fri";
  private Boolean fri;

  public static final String JSON_PROPERTY_SAT = "sat";
  private Boolean sat;

  public static final String JSON_PROPERTY_SUN = "sun";
  private Boolean sun;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public DowPatternGroup() {
  }

  public DowPatternGroup mon(Boolean mon) {
    
    this.mon = mon;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Monday.
   * @return mon
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMon() {
    return mon;
  }


  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMon(Boolean mon) {
    this.mon = mon;
  }


  public DowPatternGroup tue(Boolean tue) {
    
    this.tue = tue;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Tuesday.
   * @return tue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTue() {
    return tue;
  }


  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTue(Boolean tue) {
    this.tue = tue;
  }


  public DowPatternGroup wed(Boolean wed) {
    
    this.wed = wed;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Wednesday.
   * @return wed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getWed() {
    return wed;
  }


  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWed(Boolean wed) {
    this.wed = wed;
  }


  public DowPatternGroup thu(Boolean thu) {
    
    this.thu = thu;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Thursday.
   * @return thu
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getThu() {
    return thu;
  }


  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThu(Boolean thu) {
    this.thu = thu;
  }


  public DowPatternGroup fri(Boolean fri) {
    
    this.fri = fri;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Friday.
   * @return fri
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFri() {
    return fri;
  }


  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFri(Boolean fri) {
    this.fri = fri;
  }


  public DowPatternGroup sat(Boolean sat) {
    
    this.sat = sat;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Saturday.
   * @return sat
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSat() {
    return sat;
  }


  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSat(Boolean sat) {
    this.sat = sat;
  }


  public DowPatternGroup sun(Boolean sun) {
    
    this.sun = sun;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Sunday.
   * @return sun
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSun() {
    return sun;
  }


  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSun(Boolean sun) {
    this.sun = sun;
  }


  public DowPatternGroup disabled(Boolean disabled) {
    
    this.disabled = disabled;
    return this;
  }

   /**
   * Convenience property to quickly determine if this existing object has any active days enabled.
   * @return disabled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisabled() {
    return disabled;
  }


  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DowPatternGroup dowPatternGroup = (DowPatternGroup) o;
    return Objects.equals(this.mon, dowPatternGroup.mon) &&
        Objects.equals(this.tue, dowPatternGroup.tue) &&
        Objects.equals(this.wed, dowPatternGroup.wed) &&
        Objects.equals(this.thu, dowPatternGroup.thu) &&
        Objects.equals(this.fri, dowPatternGroup.fri) &&
        Objects.equals(this.sat, dowPatternGroup.sat) &&
        Objects.equals(this.sun, dowPatternGroup.sun) &&
        Objects.equals(this.disabled, dowPatternGroup.disabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mon, tue, wed, thu, fri, sat, sun, disabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DowPatternGroup {\n");
    sb.append("    mon: ").append(toIndentedString(mon)).append("\n");
    sb.append("    tue: ").append(toIndentedString(tue)).append("\n");
    sb.append("    wed: ").append(toIndentedString(wed)).append("\n");
    sb.append("    thu: ").append(toIndentedString(thu)).append("\n");
    sb.append("    fri: ").append(toIndentedString(fri)).append("\n");
    sb.append("    sat: ").append(toIndentedString(sat)).append("\n");
    sb.append("    sun: ").append(toIndentedString(sun)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

