/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Extranet Monetize API This part of the documentation concerns itself with the management of cancellation policies, promotions, restrictions etc. This API lets you create:  1. Add-ons: Manage add-ons. 2. Cancellation policies: Manage cancellation policies for your property. 3. Rate plan: Manage property rate plans. 4. Master rates: Manage perks for room type / rate plan combos. 5. Promotions: Manage promotions. 6. Promotion bundle: Manage bundled promotions.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.monetize.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.monetize.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.monetize.model.SimpleDescription;
import travel.wink.sdk.extranet.monetize.model.SimpleMultimedia;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * This is one bookable item that can stand alongside a restaurant / meeting room etc.
 */
@JsonPropertyOrder({
  TransactionalTravelInventory.JSON_PROPERTY_IDENTIFIER,
  TransactionalTravelInventory.JSON_PROPERTY_NAME,
  TransactionalTravelInventory.JSON_PROPERTY_DESCRIPTIONS,
  TransactionalTravelInventory.JSON_PROPERTY_PRICING_TYPE,
  TransactionalTravelInventory.JSON_PROPERTY_BASE_PRICE,
  TransactionalTravelInventory.JSON_PROPERTY_DISCOUNTED_PRICE,
  TransactionalTravelInventory.JSON_PROPERTY_MULTIMEDIAS,
  TransactionalTravelInventory.JSON_PROPERTY_MIN_PAX,
  TransactionalTravelInventory.JSON_PROPERTY_MAX_PAX,
  TransactionalTravelInventory.JSON_PROPERTY_PERCENT_DISCOUNT,
  TransactionalTravelInventory.JSON_PROPERTY_PERCENT_PREMIUM
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:03:43.239796474+07:00[Asia/Bangkok]")
public class TransactionalTravelInventory {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescription> descriptions = new ArrayList<>();

  /**
   * How this inventory item should be priced.
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_BASE_PRICE = "basePrice";
  private CustomMonetaryAmount basePrice;

  public static final String JSON_PROPERTY_DISCOUNTED_PRICE = "discountedPrice";
  private CustomMonetaryAmount discountedPrice;

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimedia> multimedias;

  public static final String JSON_PROPERTY_MIN_PAX = "minPax";
  private Integer minPax;

  public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
  private Integer maxPax;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Float percentDiscount;

  public static final String JSON_PROPERTY_PERCENT_PREMIUM = "percentPremium";
  private Float percentPremium;

  public TransactionalTravelInventory() {
  }

  public TransactionalTravelInventory identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique transactional identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public TransactionalTravelInventory name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of transactional inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public TransactionalTravelInventory descriptions(List<SimpleDescription> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public TransactionalTravelInventory addDescriptionsItem(SimpleDescription descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescription> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescription> descriptions) {
    this.descriptions = descriptions;
  }


  public TransactionalTravelInventory pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How this inventory item should be priced.
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public TransactionalTravelInventory basePrice(CustomMonetaryAmount basePrice) {
    
    this.basePrice = basePrice;
    return this;
  }

   /**
   * Get basePrice
   * @return basePrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getBasePrice() {
    return basePrice;
  }


  @JsonProperty(JSON_PROPERTY_BASE_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBasePrice(CustomMonetaryAmount basePrice) {
    this.basePrice = basePrice;
  }


  public TransactionalTravelInventory discountedPrice(CustomMonetaryAmount discountedPrice) {
    
    this.discountedPrice = discountedPrice;
    return this;
  }

   /**
   * Get discountedPrice
   * @return discountedPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DISCOUNTED_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getDiscountedPrice() {
    return discountedPrice;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNTED_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDiscountedPrice(CustomMonetaryAmount discountedPrice) {
    this.discountedPrice = discountedPrice;
  }


  public TransactionalTravelInventory multimedias(List<SimpleMultimedia> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public TransactionalTravelInventory addMultimediasItem(SimpleMultimedia multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of item.
   * @return multimedias
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimedia> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultimedias(List<SimpleMultimedia> multimedias) {
    this.multimedias = multimedias;
  }


  public TransactionalTravelInventory minPax(Integer minPax) {
    
    this.minPax = minPax;
    return this;
  }

   /**
   * Whether there is a limit to minimum group size.
   * @return minPax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPax() {
    return minPax;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPax(Integer minPax) {
    this.minPax = minPax;
  }


  public TransactionalTravelInventory maxPax(Integer maxPax) {
    
    this.maxPax = maxPax;
    return this;
  }

   /**
   * Whether there is a limit to maximum group size.
   * @return maxPax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPax() {
    return maxPax;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPax(Integer maxPax) {
    this.maxPax = maxPax;
  }


  public TransactionalTravelInventory percentDiscount(Float percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Calculates the percent difference between basePrice and discountedPrice.
   * @return percentDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentDiscount(Float percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public TransactionalTravelInventory percentPremium(Float percentPremium) {
    
    this.percentPremium = percentPremium;
    return this;
  }

   /**
   * Calculates the percent difference between basePrice and discountedPrice.
   * @return percentPremium
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERCENT_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPercentPremium() {
    return percentPremium;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentPremium(Float percentPremium) {
    this.percentPremium = percentPremium;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransactionalTravelInventory transactionalTravelInventory = (TransactionalTravelInventory) o;
    return Objects.equals(this.identifier, transactionalTravelInventory.identifier) &&
        Objects.equals(this.name, transactionalTravelInventory.name) &&
        Objects.equals(this.descriptions, transactionalTravelInventory.descriptions) &&
        Objects.equals(this.pricingType, transactionalTravelInventory.pricingType) &&
        Objects.equals(this.basePrice, transactionalTravelInventory.basePrice) &&
        Objects.equals(this.discountedPrice, transactionalTravelInventory.discountedPrice) &&
        Objects.equals(this.multimedias, transactionalTravelInventory.multimedias) &&
        Objects.equals(this.minPax, transactionalTravelInventory.minPax) &&
        Objects.equals(this.maxPax, transactionalTravelInventory.maxPax) &&
        Objects.equals(this.percentDiscount, transactionalTravelInventory.percentDiscount) &&
        Objects.equals(this.percentPremium, transactionalTravelInventory.percentPremium);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, descriptions, pricingType, basePrice, discountedPrice, multimedias, minPax, maxPax, percentDiscount, percentPremium);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransactionalTravelInventory {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    basePrice: ").append(toIndentedString(basePrice)).append("\n");
    sb.append("    discountedPrice: ").append(toIndentedString(discountedPrice)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    minPax: ").append(toIndentedString(minPax)).append("\n");
    sb.append("    maxPax: ").append(toIndentedString(maxPax)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    percentPremium: ").append(toIndentedString(percentPremium)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

