/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.monetize.invoker.ApiClient;
import travel.wink.sdk.extranet.monetize.model.MasterRateViewSupplier;
import travel.wink.sdk.extranet.monetize.model.SetMasterRatePerkRequestSupplier;
import travel.wink.sdk.extranet.monetize.model.ToggleMasterRateRequestSupplier;

public class MasterRateApi {
    private ApiClient apiClient;

    public MasterRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public MasterRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec setPerksRequestCreation(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        SetMasterRatePerkRequestSupplier postBody = setMasterRatePerkRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (setMasterRatePerkRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'setMasterRatePerkRequestSupplier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/perks", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MasterRateViewSupplier> setPerks(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.setPerksRequestCreation(propertyIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateViewSupplier>> setPerksWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.setPerksRequestCreation(propertyIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec setPerksWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.setPerksRequestCreation(propertyIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showMasterRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MasterRateViewSupplier> showMasterRate(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateViewSupplier>> showMasterRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMasterRateWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showMasterRatesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<MasterRateViewSupplier> showMasterRates(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<MasterRateViewSupplier>>> showMasterRatesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.showMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMasterRatesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showMasterRatesRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec toggleMasterRateRequestCreation(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ToggleMasterRateRequestSupplier postBody = toggleMasterRateRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (toggleMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'toggleMasterRateRequestSupplier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/master-rate/{masterRateIdentifier}/toggle", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<MasterRateViewSupplier> toggleMasterRate(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.toggleMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<MasterRateViewSupplier>> toggleMasterRateWithHttpInfo(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>(this){};
        return this.toggleMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec toggleMasterRateWithResponseSpec(String propertyIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.toggleMasterRateRequestCreation(propertyIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion);
    }
}

