/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.monetize.invoker.ApiClient;
import travel.wink.sdk.extranet.monetize.model.RateModifierViewSupplier;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.monetize.model.UpsertRateModifierRequestSupplier;

public class PromotionApi {
    private ApiClient apiClient;

    public PromotionApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createPromotionRequestCreation(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRateModifierRequestSupplier postBody = upsertRateModifierRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/promotion", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierViewSupplier> createPromotion(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierViewSupplier>> createPromotionWithHttpInfo(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createPromotionWithResponseSpec(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRateModifierRequestCreation(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/promotion/{rateModifierIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeRateModifier(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRateModifierWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRateModifierWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPromotionRequestCreation(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/promotion/{rateModifierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierViewSupplier> showPromotion(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierViewSupplier>> showPromotionWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPromotionWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPromotionsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPromotions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/promotion/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateModifierViewSupplier> showPromotions(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateModifierViewSupplier>>> showPromotionsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPromotionsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updatePromotionRequestCreation(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRateModifierRequestSupplier postBody = upsertRateModifierRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/promotion/{rateModifierIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierViewSupplier> updatePromotion(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierViewSupplier>> updatePromotionWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>(this){};
        return this.updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updatePromotionWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }
}

