/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Extranet Monetize API This part of the documentation concerns itself with the management of cancellation policies, promotions, restrictions etc. This API lets you create:  1. Add-ons: Manage add-ons. 2. Cancellation policies: Manage cancellation policies for your property. 3. Rate plan: Manage property rate plans. 4. Master rates: Manage perks for room type / rate plan combos. 5. Promotions: Manage promotions. 6. Promotion bundle: Manage bundled promotions.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.4.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.monetize.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Uses MaxMind&#39;s city lite db to persist GeoIP objects in our own db.
 */
@JsonPropertyOrder({
  GeoIPSupplier.JSON_PROPERTY_GEO_NAME_ID,
  GeoIPSupplier.JSON_PROPERTY_LOCALE_CODE,
  GeoIPSupplier.JSON_PROPERTY_CONTINENT_CODE,
  GeoIPSupplier.JSON_PROPERTY_CONTINENT_NAME,
  GeoIPSupplier.JSON_PROPERTY_COUNTRY_ISO_CODE,
  GeoIPSupplier.JSON_PROPERTY_COUNTRY_NAME,
  GeoIPSupplier.JSON_PROPERTY_CITY_NAME,
  GeoIPSupplier.JSON_PROPERTY_TIMEZONE,
  GeoIPSupplier.JSON_PROPERTY_SUB_DIVISION1_CODE,
  GeoIPSupplier.JSON_PROPERTY_SUB_DIVISION1_NAME,
  GeoIPSupplier.JSON_PROPERTY_SUB_DIVISION2_CODE,
  GeoIPSupplier.JSON_PROPERTY_SUB_DIVISION2_NAME
})
@JsonTypeName("GeoIP_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T22:11:34.251063454+07:00[Asia/Bangkok]")
public class GeoIPSupplier {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public static final String JSON_PROPERTY_LOCALE_CODE = "localeCode";
  private String localeCode;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public static final String JSON_PROPERTY_COUNTRY_ISO_CODE = "countryIsoCode";
  private String countryIsoCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_SUB_DIVISION1_CODE = "subDivision1Code";
  private String subDivision1Code;

  public static final String JSON_PROPERTY_SUB_DIVISION1_NAME = "subDivision1Name";
  private String subDivision1Name;

  public static final String JSON_PROPERTY_SUB_DIVISION2_CODE = "subDivision2Code";
  private String subDivision2Code;

  public static final String JSON_PROPERTY_SUB_DIVISION2_NAME = "subDivision2Name";
  private String subDivision2Name;

  public GeoIPSupplier() {
  }

  public GeoIPSupplier geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifiers taken from [https://geonames.org](https://geonames.org).
   * @return geoNameId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoIPSupplier localeCode(String localeCode) {
    
    this.localeCode = localeCode;
    return this;
  }

   /**
   * Locale code
   * @return localeCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocaleCode() {
    return localeCode;
  }


  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocaleCode(String localeCode) {
    this.localeCode = localeCode;
  }


  public GeoIPSupplier continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Continent code
   * @return continentCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public GeoIPSupplier continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Continent name
   * @return continentName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  public GeoIPSupplier countryIsoCode(String countryIsoCode) {
    
    this.countryIsoCode = countryIsoCode;
    return this;
  }

   /**
   * Country ISO code
   * @return countryIsoCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryIsoCode() {
    return countryIsoCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryIsoCode(String countryIsoCode) {
    this.countryIsoCode = countryIsoCode;
  }


  public GeoIPSupplier countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country name
   * @return countryName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public GeoIPSupplier cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * City name
   * @return cityName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public GeoIPSupplier timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoIPSupplier subDivision1Code(String subDivision1Code) {
    
    this.subDivision1Code = subDivision1Code;
    return this;
  }

   /**
   * Sub-division 1 code
   * @return subDivision1Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Code() {
    return subDivision1Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Code(String subDivision1Code) {
    this.subDivision1Code = subDivision1Code;
  }


  public GeoIPSupplier subDivision1Name(String subDivision1Name) {
    
    this.subDivision1Name = subDivision1Name;
    return this;
  }

   /**
   * Sub-division 1 name
   * @return subDivision1Name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Name() {
    return subDivision1Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Name(String subDivision1Name) {
    this.subDivision1Name = subDivision1Name;
  }


  public GeoIPSupplier subDivision2Code(String subDivision2Code) {
    
    this.subDivision2Code = subDivision2Code;
    return this;
  }

   /**
   * Sub-division 2 code
   * @return subDivision2Code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Code() {
    return subDivision2Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Code(String subDivision2Code) {
    this.subDivision2Code = subDivision2Code;
  }


  public GeoIPSupplier subDivision2Name(String subDivision2Name) {
    
    this.subDivision2Name = subDivision2Name;
    return this;
  }

   /**
   * Sub-division 2 name
   * @return subDivision2Name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Name() {
    return subDivision2Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Name(String subDivision2Name) {
    this.subDivision2Name = subDivision2Name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoIPSupplier geoIPSupplier = (GeoIPSupplier) o;
    return Objects.equals(this.geoNameId, geoIPSupplier.geoNameId) &&
        Objects.equals(this.localeCode, geoIPSupplier.localeCode) &&
        Objects.equals(this.continentCode, geoIPSupplier.continentCode) &&
        Objects.equals(this.continentName, geoIPSupplier.continentName) &&
        Objects.equals(this.countryIsoCode, geoIPSupplier.countryIsoCode) &&
        Objects.equals(this.countryName, geoIPSupplier.countryName) &&
        Objects.equals(this.cityName, geoIPSupplier.cityName) &&
        Objects.equals(this.timezone, geoIPSupplier.timezone) &&
        Objects.equals(this.subDivision1Code, geoIPSupplier.subDivision1Code) &&
        Objects.equals(this.subDivision1Name, geoIPSupplier.subDivision1Name) &&
        Objects.equals(this.subDivision2Code, geoIPSupplier.subDivision2Code) &&
        Objects.equals(this.subDivision2Name, geoIPSupplier.subDivision2Name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, localeCode, continentCode, continentName, countryIsoCode, countryName, cityName, timezone, subDivision1Code, subDivision1Name, subDivision2Code, subDivision2Name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoIPSupplier {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    localeCode: ").append(toIndentedString(localeCode)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("    countryIsoCode: ").append(toIndentedString(countryIsoCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    subDivision1Code: ").append(toIndentedString(subDivision1Code)).append("\n");
    sb.append("    subDivision1Name: ").append(toIndentedString(subDivision1Name)).append("\n");
    sb.append("    subDivision2Code: ").append(toIndentedString(subDivision2Code)).append("\n");
    sb.append("    subDivision2Name: ").append(toIndentedString(subDivision2Name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

