package travel.wink.sdk.extranet.monetize.api;

import travel.wink.sdk.extranet.monetize.invoker.ApiClient;

import travel.wink.sdk.extranet.monetize.model.GenericErrorMessage;
import travel.wink.sdk.extranet.monetize.model.RateModifierViewSupplier;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.monetize.model.ShowRatePlan400Response;
import travel.wink.sdk.extranet.monetize.model.UpsertRateModifierRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:58:55.878690607+07:00[Asia/Bangkok]")
public class PromotionApi {
    private ApiClient apiClient;

    public PromotionApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion and associate with this property identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPromotionRequestCreation(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierRequestSupplier' is set
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion and associate with this property identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierViewSupplier> createPromotion(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion and associate with this property identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierViewSupplier>> createPromotionWithHttpInfo(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Promotion
     * Create a new promotion
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion and associate with this property identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPromotionWithResponseSpec(String propertyIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }
    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion owned by this property identifier.
     * @param rateModifierIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRateModifierRequestCreation(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/{rateModifierIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion owned by this property identifier.
     * @param rateModifierIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRateModifier(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion owned by this property identifier.
     * @param rateModifierIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRateModifierWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Promotion
     * Delete a promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion owned by this property identifier.
     * @param rateModifierIdentifier Remove a promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRateModifierWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }
    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion owned by this property identifier.
     * @param rateModifierIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPromotionRequestCreation(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/{rateModifierIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion owned by this property identifier.
     * @param rateModifierIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierViewSupplier> showPromotion(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion owned by this property identifier.
     * @param rateModifierIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierViewSupplier>> showPromotionWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Promotion
     * Retrieve a rate modifier by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion owned by this property identifier.
     * @param rateModifierIdentifier Show single promotion with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPromotionWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }
    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotions owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPromotionsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPromotions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotions owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateModifierViewSupplier> showPromotions(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotions owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;RateModifierViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateModifierViewSupplier>>> showPromotionsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Promotions
     * Retrieve list of promotions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotions owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPromotionsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion owned by this property identifier.
     * @param rateModifierIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePromotionRequestCreation(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateModifierIdentifier' is set
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierRequestSupplier' is set
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/{rateModifierIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion owned by this property identifier.
     * @param rateModifierIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierViewSupplier> updatePromotion(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion owned by this property identifier.
     * @param rateModifierIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierViewSupplier>> updatePromotionWithHttpInfo(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierViewSupplier>() {};
        return updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Promotion
     * Update an existing promotion by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion owned by this property identifier.
     * @param rateModifierIdentifier Update existing promotion with this identifier.
     * @param upsertRateModifierRequestSupplier The upsertRateModifierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updatePromotionWithResponseSpec(String propertyIdentifier, String rateModifierIdentifier, UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }
}
