package travel.wink.sdk.extranet.monetize.api;

import travel.wink.sdk.extranet.monetize.invoker.ApiClient;

import travel.wink.sdk.extranet.monetize.model.GenericErrorMessage;
import travel.wink.sdk.extranet.monetize.model.RateModifierBundleViewSupplier;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.monetize.model.ShowRatePlan400Response;
import travel.wink.sdk.extranet.monetize.model.UpsertRateModifierBundleRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:58:55.878690607+07:00[Asia/Bangkok]")
public class PromotionBundleApi {
    private ApiClient apiClient;

    public PromotionBundleApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionBundleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion bundle and associate with this property identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRateModifierBundleRequestCreation(String propertyIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierBundleRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierBundleRequestSupplier' is set
        if (upsertRateModifierBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequestSupplier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion bundle and associate with this property identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleViewSupplier> createRateModifierBundle(String propertyIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return createRateModifierBundleRequestCreation(propertyIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion bundle and associate with this property identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> createRateModifierBundleWithHttpInfo(String propertyIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return createRateModifierBundleRequestCreation(propertyIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create new promotion bundle and associate with this property identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createRateModifierBundleWithResponseSpec(String propertyIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createRateModifierBundleRequestCreation(propertyIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion);
    }
    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRateModifierBundleRequestCreation(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/{promotionBundleIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRateModifierBundle(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRateModifierBundleWithHttpInfo(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove a promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRateModifierBundleWithResponseSpec(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, winkVersion, accept);
    }
    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRateModifierBundleRequestCreation(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/{promotionBundleIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleViewSupplier> showRateModifierBundle(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> showRateModifierBundleWithHttpInfo(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show single promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRateModifierBundleWithResponseSpec(String propertyIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, winkVersion, accept);
    }
    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotion bundles owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRateModifierBundlesRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRateModifierBundles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotion bundles owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateModifierBundleViewSupplier> showRateModifierBundles(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundlesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotion bundles owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;RateModifierBundleViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateModifierBundleViewSupplier>>> showRateModifierBundlesWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundlesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show all promotion bundles owned by this property identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRateModifierBundlesWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRateModifierBundlesRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRateModifierBundleRequestCreation(String propertyIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierBundleRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierBundleRequestSupplier' is set
        if (upsertRateModifierBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequestSupplier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/{promotionBundleIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleViewSupplier> updateRateModifierBundle(String propertyIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return updateRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> updateRateModifierBundleWithHttpInfo(String propertyIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return updateRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update existing promotion bundle owned by this property identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRateModifierBundleWithResponseSpec(String propertyIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateRateModifierBundleRequestCreation(propertyIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion);
    }
}
