/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.monetize.invoker.ApiClient;
import travel.wink.sdk.extranet.monetize.model.AddOn;
import travel.wink.sdk.extranet.monetize.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.monetize.model.SimpleMultimedia;
import travel.wink.sdk.extranet.monetize.model.UpsertAddOnRequest;

public class AddOnApi {
    private ApiClient apiClient;

    public AddOnApi() {
        this(new ApiClient());
    }

    @Autowired
    public AddOnApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        SimpleMultimedia postBody = simpleMultimedia;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimedia' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}/multimedia", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> addMultimedia(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.addMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, simpleMultimedia, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> addMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.addMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, simpleMultimedia, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        return this.addMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, simpleMultimedia, winkVersion);
    }

    private WebClient.ResponseSpec createAddOnRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAddOnRequest postBody = upsertAddOnRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> createAddOn(@Nonnull String propertyIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.createAddOnRequestCreation(propertyIdentifier, upsertAddOnRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> createAddOnWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.createAddOnRequestCreation(propertyIdentifier, upsertAddOnRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAddOnWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createAddOnRequestCreation(propertyIdentifier, upsertAddOnRequest, winkVersion);
    }

    private WebClient.ResponseSpec removeAddOnRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeAddOn(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeAddOnWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAddOnWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> removeMultimedia(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.removeMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> removeMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.removeMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAddOnRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> showAddOn(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.showAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> showAddOnWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.showAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAddOnWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAddOnRequestCreation(propertyIdentifier, addOnIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAddOnsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAddOns", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AddOn> showAddOns(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.showAddOnsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AddOn>>> showAddOnsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.showAddOnsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAddOnsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showAddOnsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAddOnRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertAddOnRequest postBody = upsertAddOnRequest;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> updateAddOn(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.updateAddOnRequestCreation(propertyIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> updateAddOnWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.updateAddOnRequestCreation(propertyIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAddOnWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull UpsertAddOnRequest upsertAddOnRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateAddOnRequestCreation(propertyIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion);
    }

    private WebClient.ResponseSpec updateAddOnMultimediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        SimpleMultimedia postBody = simpleMultimedia;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimedia' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> updateAddOnMultimedia(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.updateAddOnMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> updateAddOnMultimediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.updateAddOnMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAddOnMultimediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull String multimediaIdentifier, @Nonnull SimpleMultimedia simpleMultimedia, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateAddOnMultimediaRequestCreation(propertyIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion);
    }

    private WebClient.ResponseSpec uploadBinaryAddOnMediaRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/add-on/{addOnIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AddOn> uploadBinaryAddOnMedia(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.uploadBinaryAddOnMediaRequestCreation(propertyIdentifier, addOnIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AddOn>> uploadBinaryAddOnMediaWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<AddOn> localVarReturnType = new ParameterizedTypeReference<AddOn>(this){};
        return this.uploadBinaryAddOnMediaRequestCreation(propertyIdentifier, addOnIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadBinaryAddOnMediaWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String addOnIdentifier, @Nonnull List<File> files) throws WebClientResponseException {
        return this.uploadBinaryAddOnMediaRequestCreation(propertyIdentifier, addOnIdentifier, files);
    }
}

