/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.monetize.invoker.ApiClient;
import travel.wink.sdk.extranet.monetize.model.SpecialRateSupplier;
import travel.wink.sdk.extranet.monetize.model.UpsertRateModifierRequestSupplier;

public class PromotionApi {
    private ApiClient apiClient;

    public PromotionApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createPromotionRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRateModifierRequestSupplier postBody = upsertRateModifierRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling createPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateSupplier> createPromotion(@Nonnull String propertyIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateSupplier>> createPromotionWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createPromotionWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createPromotionRequestCreation(propertyIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRateModifierRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling removeRateModifier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/{rateModifierIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateSupplier> removeRateModifier(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateSupplier>> removeRateModifierWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRateModifierWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeRateModifierRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPromotionRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling showPromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/{rateModifierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateSupplier> showPromotion(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateSupplier>> showPromotionWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPromotionWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showPromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showPromotionsRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPromotions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SpecialRateSupplier> showPromotions(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SpecialRateSupplier>>> showPromotionsWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPromotionsWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showPromotionsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updatePromotionRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRateModifierRequestSupplier postBody = upsertRateModifierRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierIdentifier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierRequestSupplier' when calling updatePromotion", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierIdentifier", rateModifierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion/{rateModifierIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateSupplier> updatePromotion(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateSupplier>> updatePromotionWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateSupplier>(this){};
        return this.updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updatePromotionWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierIdentifier, @Nonnull UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updatePromotionRequestCreation(propertyIdentifier, rateModifierIdentifier, upsertRateModifierRequestSupplier, winkVersion);
    }
}

