/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.monetize.invoker.ApiClient;
import travel.wink.sdk.extranet.monetize.model.SpecialRateBundleSupplier;
import travel.wink.sdk.extranet.monetize.model.UpsertSpecialRateBundleRequestSupplier;

public class PromotionBundleApi {
    private ApiClient apiClient;

    public PromotionBundleApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionBundleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRateModifierBundleRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSpecialRateBundleRequestSupplier postBody = upsertSpecialRateBundleRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSpecialRateBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSpecialRateBundleRequestSupplier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateBundleSupplier> createRateModifierBundle(@Nonnull String propertyIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.createRateModifierBundleRequestCreation(propertyIdentifier, upsertSpecialRateBundleRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateBundleSupplier>> createRateModifierBundleWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.createRateModifierBundleRequestCreation(propertyIdentifier, upsertSpecialRateBundleRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRateModifierBundleWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createRateModifierBundleRequestCreation(propertyIdentifier, upsertSpecialRateBundleRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRateModifierBundleRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/{rateModifierBundleIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateBundleSupplier> removeRateModifierBundle(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.removeRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateBundleSupplier>> removeRateModifierBundleWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.removeRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRateModifierBundleWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRateModifierBundleRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/{rateModifierBundleIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateBundleSupplier> showRateModifierBundle(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.showRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateBundleSupplier>> showRateModifierBundleWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.showRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRateModifierBundleWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRateModifierBundlesRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRateModifierBundles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SpecialRateBundleSupplier> showRateModifierBundles(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.showRateModifierBundlesRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SpecialRateBundleSupplier>>> showRateModifierBundlesWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.showRateModifierBundlesRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRateModifierBundlesWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRateModifierBundlesRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRateModifierBundleRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSpecialRateBundleRequestSupplier postBody = upsertSpecialRateBundleRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rateModifierBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateModifierBundleIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSpecialRateBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSpecialRateBundleRequestSupplier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("rateModifierBundleIdentifier", rateModifierBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/promotion-bundle/{rateModifierBundleIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SpecialRateBundleSupplier> updateRateModifierBundle(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.updateRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, upsertSpecialRateBundleRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SpecialRateBundleSupplier>> updateRateModifierBundleWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SpecialRateBundleSupplier> localVarReturnType = new ParameterizedTypeReference<SpecialRateBundleSupplier>(this){};
        return this.updateRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, upsertSpecialRateBundleRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRateModifierBundleWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String rateModifierBundleIdentifier, @Nonnull UpsertSpecialRateBundleRequestSupplier upsertSpecialRateBundleRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateRateModifierBundleRequestCreation(propertyIdentifier, rateModifierBundleIdentifier, upsertSpecialRateBundleRequestSupplier, winkVersion);
    }
}

