/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.monetize.invoker.ApiClient;
import travel.wink.sdk.extranet.monetize.model.RatePlanSupplier;
import travel.wink.sdk.extranet.monetize.model.UpsertRatePlanRequestSupplier;

public class RatePlanApi {
    private ApiClient apiClient;

    public RatePlanApi() {
        this(new ApiClient());
    }

    @Autowired
    public RatePlanApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRatePlanRequestCreation(@Nonnull String propertyIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRatePlanRequestSupplier postBody = upsertRatePlanRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling createRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/rate-plan", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanSupplier> createRatePlan(@Nonnull String propertyIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.createRatePlanRequestCreation(propertyIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanSupplier>> createRatePlanWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.createRatePlanRequestCreation(propertyIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRatePlanWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createRatePlanRequestCreation(propertyIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRatePlanRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling removeRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/rate-plan/{ratePlanIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanSupplier> removeRatePlan(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.removeRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanSupplier>> removeRatePlanWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.removeRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRatePlanWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRatePlanRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/rate-plan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanSupplier> showRatePlan(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.showRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanSupplier>> showRatePlanWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.showRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRatePlanWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRatePlansRequestCreation(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRatePlans", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/rate-plan/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RatePlanSupplier> showRatePlans(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.showRatePlansRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RatePlanSupplier>>> showRatePlansWithHttpInfo(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.showRatePlansRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRatePlansWithResponseSpec(@Nonnull String propertyIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showRatePlansRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRatePlanRequestCreation(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertRatePlanRequestSupplier postBody = upsertRatePlanRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRatePlanRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRatePlanRequestSupplier' when calling updateRatePlan", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/rate-plan/{ratePlanIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RatePlanSupplier> updateRatePlan(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.updateRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RatePlanSupplier>> updateRatePlanWithHttpInfo(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RatePlanSupplier> localVarReturnType = new ParameterizedTypeReference<RatePlanSupplier>(this){};
        return this.updateRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRatePlanWithResponseSpec(@Nonnull String propertyIdentifier, @Nonnull String ratePlanIdentifier, @Nonnull UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateRatePlanRequestCreation(propertyIdentifier, ratePlanIdentifier, upsertRatePlanRequestSupplier, winkVersion);
    }
}

