/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.monetize.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "description", "language", "creator", "md5ContentHash", "hashMismatch"})
public class SimpleDescription {
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nonnull
    private String description;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    @Nonnull
    private String language = "en";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    @Nullable
    private CreatorEnum creator = CreatorEnum.USER;
    public static final String JSON_PROPERTY_MD5_CONTENT_HASH = "md5ContentHash";
    @Nullable
    private String md5ContentHash;
    public static final String JSON_PROPERTY_HASH_MISMATCH = "hashMismatch";
    @Nullable
    private Boolean hashMismatch;

    public SimpleDescription() {
    }

    @JsonCreator
    public SimpleDescription(@JsonProperty(value="hashMismatch") Boolean hashMismatch) {
        this();
        this.hashMismatch = hashMismatch;
    }

    public SimpleDescription name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SimpleDescription description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public SimpleDescription language(@Nonnull String language) {
        this.language = language;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=2, max=2)
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=2) String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLanguage(@Nonnull String language) {
        this.language = language;
    }

    public SimpleDescription creator(@Nullable CreatorEnum creator) {
        this.creator = creator;
        return this;
    }

    @Nullable
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreatorEnum getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(@Nullable CreatorEnum creator) {
        this.creator = creator;
    }

    public SimpleDescription md5ContentHash(@Nullable String md5ContentHash) {
        this.md5ContentHash = md5ContentHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="md5ContentHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMd5ContentHash() {
        return this.md5ContentHash;
    }

    @JsonProperty(value="md5ContentHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMd5ContentHash(@Nullable String md5ContentHash) {
        this.md5ContentHash = md5ContentHash;
    }

    @Nullable
    @JsonProperty(value="hashMismatch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHashMismatch() {
        return this.hashMismatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDescription simpleDescription = (SimpleDescription)o;
        return Objects.equals(this.name, simpleDescription.name) && Objects.equals(this.description, simpleDescription.description) && Objects.equals(this.language, simpleDescription.language) && Objects.equals((Object)this.creator, (Object)simpleDescription.creator) && Objects.equals(this.md5ContentHash, simpleDescription.md5ContentHash) && Objects.equals(this.hashMismatch, simpleDescription.hashMismatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.language, this.creator, this.md5ContentHash, this.hashMismatch});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimpleDescription {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString((Object)this.creator)).append("\n");
        sb.append("    md5ContentHash: ").append(this.toIndentedString(this.md5ContentHash)).append("\n");
        sb.append("    hashMismatch: ").append(this.toIndentedString(this.hashMismatch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CreatorEnum {
        SYSTEM(String.valueOf("SYSTEM")),
        USER(String.valueOf("USER"));

        private String value;

        private CreatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CreatorEnum fromValue(String value) {
            for (CreatorEnum b : CreatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

