package travel.wink.sdk.extranet.property.api;

import travel.wink.sdk.extranet.property.invoker.ApiClient;

import travel.wink.sdk.extranet.property.model.GenericErrorMessage;
import travel.wink.sdk.extranet.property.model.HotelViewSupplier;
import travel.wink.sdk.extranet.property.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.property.model.UpdateChannelManagerRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:04:02.243083328+07:00[Asia/Bangkok]")
public class ChannelManagerApi {
    private ApiClient apiClient;

    public ChannelManagerApi() {
        this(new ApiClient());
    }

    @Autowired
    public ChannelManagerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Set Channel Manager
     * Set which channel manager this property uses. Channel managers are not allowed access to rates until the property selects them as their channel manager.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set channel manager for this property identifier
     * @param updateChannelManagerRequestSupplier The updateChannelManagerRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateChannelManagerRequestCreation(String propertyIdentifier, UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = updateChannelManagerRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateChannelManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateChannelManagerRequestSupplier' is set
        if (updateChannelManagerRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateChannelManagerRequestSupplier' when calling updateChannelManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/channel-manager", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set Channel Manager
     * Set which channel manager this property uses. Channel managers are not allowed access to rates until the property selects them as their channel manager.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set channel manager for this property identifier
     * @param updateChannelManagerRequestSupplier The updateChannelManagerRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateChannelManager(String propertyIdentifier, UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateChannelManagerRequestCreation(propertyIdentifier, updateChannelManagerRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Set Channel Manager
     * Set which channel manager this property uses. Channel managers are not allowed access to rates until the property selects them as their channel manager.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set channel manager for this property identifier
     * @param updateChannelManagerRequestSupplier The updateChannelManagerRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateChannelManagerWithHttpInfo(String propertyIdentifier, UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateChannelManagerRequestCreation(propertyIdentifier, updateChannelManagerRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Set Channel Manager
     * Set which channel manager this property uses. Channel managers are not allowed access to rates until the property selects them as their channel manager.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set channel manager for this property identifier
     * @param updateChannelManagerRequestSupplier The updateChannelManagerRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateChannelManagerWithResponseSpec(String propertyIdentifier, UpdateChannelManagerRequestSupplier updateChannelManagerRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateChannelManagerRequestCreation(propertyIdentifier, updateChannelManagerRequestSupplier, winkVersion);
    }
}
