package travel.wink.sdk.extranet.property.api;

import travel.wink.sdk.extranet.property.invoker.ApiClient;

import travel.wink.sdk.extranet.property.model.ChangePropertyNameRequestSupplier;
import java.io.File;
import travel.wink.sdk.extranet.property.model.GeneralManagerSupplier;
import travel.wink.sdk.extranet.property.model.GenericErrorMessage;
import travel.wink.sdk.extranet.property.model.HotelViewSupplier;
import travel.wink.sdk.extranet.property.model.ImproveWelcomeTextRequestSupplier;
import travel.wink.sdk.extranet.property.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.property.model.PageHotelViewSupplier;
import travel.wink.sdk.extranet.property.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.property.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.property.model.StateSupplier;
import travel.wink.sdk.extranet.property.model.SuggestAmenitiesRequestSupplier;
import travel.wink.sdk.extranet.property.model.SuggestProfileRequestSupplier;
import travel.wink.sdk.extranet.property.model.SuggestProfileResponseSupplier;
import travel.wink.sdk.extranet.property.model.SuggestWelcomeTextRequestSupplier;
import travel.wink.sdk.extranet.property.model.UniqueResultSupplier;
import travel.wink.sdk.extranet.property.model.UpdateExternalHotelStatusRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpdatePropertyAmenitiesAndServicesRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertPropertyAddressRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertPropertyProfileRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertReservationsDeskRequestSupplier;
import travel.wink.sdk.extranet.property.model.UpsertWelcomeTextRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:04:02.243083328+07:00[Asia/Bangkok]")
public class PropertyApi {
    private ApiClient apiClient;

    public PropertyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PropertyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Change Property Name
     * Gives property owners a way to change the property name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param changePropertyNameRequestSupplier The changePropertyNameRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec changePropertyNameRequestCreation(String propertyIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = changePropertyNameRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling changePropertyName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'changePropertyNameRequestSupplier' is set
        if (changePropertyNameRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'changePropertyNameRequestSupplier' when calling changePropertyName", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/change-name", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Change Property Name
     * Gives property owners a way to change the property name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param changePropertyNameRequestSupplier The changePropertyNameRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> changePropertyName(String propertyIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return changePropertyNameRequestCreation(propertyIdentifier, changePropertyNameRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Change Property Name
     * Gives property owners a way to change the property name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param changePropertyNameRequestSupplier The changePropertyNameRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> changePropertyNameWithHttpInfo(String propertyIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return changePropertyNameRequestCreation(propertyIdentifier, changePropertyNameRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Change Property Name
     * Gives property owners a way to change the property name.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param changePropertyNameRequestSupplier The changePropertyNameRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec changePropertyNameWithResponseSpec(String propertyIdentifier, ChangePropertyNameRequestSupplier changePropertyNameRequestSupplier, String winkVersion) throws WebClientResponseException {
        return changePropertyNameRequestCreation(propertyIdentifier, changePropertyNameRequestSupplier, winkVersion);
    }
    /**
     * Improve Welcome Text
     * Let AI improve existing property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param improveWelcomeTextRequestSupplier The improveWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SimpleDescriptionSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec improveWelcomeTextRequestCreation(String propertyIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = improveWelcomeTextRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling improveWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'improveWelcomeTextRequestSupplier' is set
        if (improveWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'improveWelcomeTextRequestSupplier' when calling improveWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/welcome-text/improve", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Improve Welcome Text
     * Let AI improve existing property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param improveWelcomeTextRequestSupplier The improveWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SimpleDescriptionSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SimpleDescriptionSupplier> improveWelcomeText(String propertyIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>() {};
        return improveWelcomeTextRequestCreation(propertyIdentifier, improveWelcomeTextRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Improve Welcome Text
     * Let AI improve existing property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param improveWelcomeTextRequestSupplier The improveWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SimpleDescriptionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SimpleDescriptionSupplier>> improveWelcomeTextWithHttpInfo(String propertyIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>() {};
        return improveWelcomeTextRequestCreation(propertyIdentifier, improveWelcomeTextRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Improve Welcome Text
     * Let AI improve existing property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param improveWelcomeTextRequestSupplier The improveWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec improveWelcomeTextWithResponseSpec(String propertyIdentifier, ImproveWelcomeTextRequestSupplier improveWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        return improveWelcomeTextRequestCreation(propertyIdentifier, improveWelcomeTextRequestSupplier, winkVersion);
    }
    /**
     * Check Property Name Uniqueness
     * Check if hotel name is a unique.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UniqueResultSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isHotelNameUniqueRequestCreation(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new WebClientResponseException("Missing the required parameter 'key' when calling isHotelNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "key", key));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "hotelIdentifier", hotelIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>() {};
        return apiClient.invokeAPI("/api/property/unique-name", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Check Property Name Uniqueness
     * Check if hotel name is a unique.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UniqueResultSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResultSupplier> isHotelNameUnique(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>() {};
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Check Property Name Uniqueness
     * Check if hotel name is a unique.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;UniqueResultSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UniqueResultSupplier>> isHotelNameUniqueWithHttpInfo(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultSupplier> localVarReturnType = new ParameterizedTypeReference<UniqueResultSupplier>() {};
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Check Property Name Uniqueness
     * Check if hotel name is a unique.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param key Search for uniqueness for this hotel name.
     * @param hotelIdentifier Optional, existing hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isHotelNameUniqueWithResponseSpec(String key, String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return isHotelNameUniqueRequestCreation(key, hotelIdentifier, winkVersion, accept);
    }
    /**
     * Property Search
     * Retrieve a paginated list of  hotels you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return PageHotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec propertySearchRequestCreation(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = stateSupplier;
        // verify the required parameter 'stateSupplier' is set
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling propertySearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageHotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageHotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Property Search
     * Retrieve a paginated list of  hotels you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return PageHotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageHotelViewSupplier> propertySearch(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageHotelViewSupplier>() {};
        return propertySearchRequestCreation(stateSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Property Search
     * Retrieve a paginated list of  hotels you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageHotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageHotelViewSupplier>> propertySearchWithHttpInfo(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageHotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageHotelViewSupplier>() {};
        return propertySearchRequestCreation(stateSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Property Search
     * Retrieve a paginated list of  hotels you manage.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param stateSupplier Filter grid by state request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec propertySearchWithResponseSpec(StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return propertySearchRequestCreation(stateSupplier, winkVersion);
    }
    /**
     * Show Property
     * Retrieve property by record ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property record for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelByManagerRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelByManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Retrieve property by record ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property record for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> showHotelByManager(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return showHotelByManagerRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property
     * Retrieve property by record ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property record for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> showHotelByManagerWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return showHotelByManagerRequestCreation(propertyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Property
     * Retrieve property by record ID
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property record for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelByManagerWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showHotelByManagerRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Show Property Status
     * Retrieve hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show property status for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpdateExternalHotelStatusRequestSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelStatusRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/status", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property Status
     * Retrieve hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show property status for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return UpdateExternalHotelStatusRequestSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpdateExternalHotelStatusRequestSupplier> showHotelStatus(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>() {};
        return showHotelStatusRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property Status
     * Retrieve hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show property status for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;UpdateExternalHotelStatusRequestSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpdateExternalHotelStatusRequestSupplier>> showHotelStatusWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier> localVarReturnType = new ParameterizedTypeReference<UpdateExternalHotelStatusRequestSupplier>() {};
        return showHotelStatusRequestCreation(propertyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Property Status
     * Retrieve hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show property status for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelStatusWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showHotelStatusRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Property List
     * Retrieve a list of all your hotels
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showHotelsByManagerRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Property List
     * Retrieve a list of all your hotels
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<HotelViewSupplier> showHotelsByManager(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return showHotelsByManagerRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Property List
     * Retrieve a list of all your hotels
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;HotelViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<HotelViewSupplier>>> showHotelsByManagerWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return showHotelsByManagerRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Property List
     * Retrieve a list of all your hotels
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showHotelsByManagerWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return showHotelsByManagerRequestCreation(winkVersion, accept);
    }
    /**
     * Suggest property profile
     * Let AI suggest property profile.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestProfileRequestSupplier The suggestProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SuggestProfileResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec suggestPropertyProfileRequestCreation(String propertyIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = suggestProfileRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling suggestPropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'suggestProfileRequestSupplier' is set
        if (suggestProfileRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestProfileRequestSupplier' when calling suggestPropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/profile/suggest", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Suggest property profile
     * Let AI suggest property profile.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestProfileRequestSupplier The suggestProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SuggestProfileResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SuggestProfileResponseSupplier> suggestPropertyProfile(String propertyIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>() {};
        return suggestPropertyProfileRequestCreation(propertyIdentifier, suggestProfileRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Suggest property profile
     * Let AI suggest property profile.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestProfileRequestSupplier The suggestProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SuggestProfileResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SuggestProfileResponseSupplier>> suggestPropertyProfileWithHttpInfo(String propertyIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SuggestProfileResponseSupplier> localVarReturnType = new ParameterizedTypeReference<SuggestProfileResponseSupplier>() {};
        return suggestPropertyProfileRequestCreation(propertyIdentifier, suggestProfileRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Suggest property profile
     * Let AI suggest property profile.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestProfileRequestSupplier The suggestProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec suggestPropertyProfileWithResponseSpec(String propertyIdentifier, SuggestProfileRequestSupplier suggestProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        return suggestPropertyProfileRequestCreation(propertyIdentifier, suggestProfileRequestSupplier, winkVersion);
    }
    /**
     * Suggest Property Welcome Text
     * Let AI suggest property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestWelcomeTextRequestSupplier The suggestWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SimpleDescriptionSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec suggestPropertyWelcomeTextRequestCreation(String propertyIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = suggestWelcomeTextRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling suggestPropertyWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'suggestWelcomeTextRequestSupplier' is set
        if (suggestWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestWelcomeTextRequestSupplier' when calling suggestPropertyWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/welcome-text/suggest", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Suggest Property Welcome Text
     * Let AI suggest property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestWelcomeTextRequestSupplier The suggestWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SimpleDescriptionSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SimpleDescriptionSupplier> suggestPropertyWelcomeText(String propertyIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>() {};
        return suggestPropertyWelcomeTextRequestCreation(propertyIdentifier, suggestWelcomeTextRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Suggest Property Welcome Text
     * Let AI suggest property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestWelcomeTextRequestSupplier The suggestWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SimpleDescriptionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SimpleDescriptionSupplier>> suggestPropertyWelcomeTextWithHttpInfo(String propertyIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleDescriptionSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleDescriptionSupplier>() {};
        return suggestPropertyWelcomeTextRequestCreation(propertyIdentifier, suggestWelcomeTextRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Suggest Property Welcome Text
     * Let AI suggest property descriptions.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestWelcomeTextRequestSupplier The suggestWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec suggestPropertyWelcomeTextWithResponseSpec(String propertyIdentifier, SuggestWelcomeTextRequestSupplier suggestWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        return suggestPropertyWelcomeTextRequestCreation(propertyIdentifier, suggestWelcomeTextRequestSupplier, winkVersion);
    }
    /**
     * Suggest property amenities
     * Let AI suggest property amenities.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestAmenitiesRequestSupplier The suggestAmenitiesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec suggestPropertyWelcomeText1RequestCreation(String propertyIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = suggestAmenitiesRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling suggestPropertyWelcomeText1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'suggestAmenitiesRequestSupplier' is set
        if (suggestAmenitiesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'suggestAmenitiesRequestSupplier' when calling suggestPropertyWelcomeText1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/services/suggest", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Suggest property amenities
     * Let AI suggest property amenities.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestAmenitiesRequestSupplier The suggestAmenitiesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> suggestPropertyWelcomeText1(String propertyIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return suggestPropertyWelcomeText1RequestCreation(propertyIdentifier, suggestAmenitiesRequestSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Suggest property amenities
     * Let AI suggest property amenities.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestAmenitiesRequestSupplier The suggestAmenitiesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> suggestPropertyWelcomeText1WithHttpInfo(String propertyIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return suggestPropertyWelcomeText1RequestCreation(propertyIdentifier, suggestAmenitiesRequestSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Suggest property amenities
     * Let AI suggest property amenities.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Suggest for this property identifier
     * @param suggestAmenitiesRequestSupplier The suggestAmenitiesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec suggestPropertyWelcomeText1WithResponseSpec(String propertyIdentifier, SuggestAmenitiesRequestSupplier suggestAmenitiesRequestSupplier, String winkVersion) throws WebClientResponseException {
        return suggestPropertyWelcomeText1RequestCreation(propertyIdentifier, suggestAmenitiesRequestSupplier, winkVersion);
    }
    /**
     * Update Property Address
     * Update address
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyAddressRequestSupplier The upsertPropertyAddressRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddressRequestCreation(String propertyIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertPropertyAddressRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertPropertyAddressRequestSupplier' is set
        if (upsertPropertyAddressRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyAddressRequestSupplier' when calling updateAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/address", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Property Address
     * Update address
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyAddressRequestSupplier The upsertPropertyAddressRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateAddress(String propertyIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateAddressRequestCreation(propertyIdentifier, upsertPropertyAddressRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Property Address
     * Update address
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyAddressRequestSupplier The upsertPropertyAddressRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateAddressWithHttpInfo(String propertyIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateAddressRequestCreation(propertyIdentifier, upsertPropertyAddressRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Property Address
     * Update address
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyAddressRequestSupplier The upsertPropertyAddressRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAddressWithResponseSpec(String propertyIdentifier, UpsertPropertyAddressRequestSupplier upsertPropertyAddressRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateAddressRequestCreation(propertyIdentifier, upsertPropertyAddressRequestSupplier, winkVersion);
    }
    /**
     * Update General Manager
     * Update general manager information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param generalManagerSupplier The generalManagerSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateGeneralManagerRequestCreation(String propertyIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = generalManagerSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'generalManagerSupplier' is set
        if (generalManagerSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'generalManagerSupplier' when calling updateGeneralManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/general-manager", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update General Manager
     * Update general manager information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param generalManagerSupplier The generalManagerSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateGeneralManager(String propertyIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateGeneralManagerRequestCreation(propertyIdentifier, generalManagerSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update General Manager
     * Update general manager information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param generalManagerSupplier The generalManagerSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateGeneralManagerWithHttpInfo(String propertyIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateGeneralManagerRequestCreation(propertyIdentifier, generalManagerSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update General Manager
     * Update general manager information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param generalManagerSupplier The generalManagerSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateGeneralManagerWithResponseSpec(String propertyIdentifier, GeneralManagerSupplier generalManagerSupplier, String winkVersion) throws WebClientResponseException {
        return updateGeneralManagerRequestCreation(propertyIdentifier, generalManagerSupplier, winkVersion);
    }
    /**
     * Update Property Status
     * Update hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Change status for this property identifier
     * @param updateExternalHotelStatusRequestSupplier The updateExternalHotelStatusRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateHotelStatusRequestCreation(String propertyIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = updateExternalHotelStatusRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateExternalHotelStatusRequestSupplier' is set
        if (updateExternalHotelStatusRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateExternalHotelStatusRequestSupplier' when calling updateHotelStatus", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Property Status
     * Update hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Change status for this property identifier
     * @param updateExternalHotelStatusRequestSupplier The updateExternalHotelStatusRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateHotelStatus(String propertyIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateHotelStatusRequestCreation(propertyIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Property Status
     * Update hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Change status for this property identifier
     * @param updateExternalHotelStatusRequestSupplier The updateExternalHotelStatusRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateHotelStatusWithHttpInfo(String propertyIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateHotelStatusRequestCreation(propertyIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Property Status
     * Update hotel status
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Change status for this property identifier
     * @param updateExternalHotelStatusRequestSupplier The updateExternalHotelStatusRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateHotelStatusWithResponseSpec(String propertyIdentifier, UpdateExternalHotelStatusRequestSupplier updateExternalHotelStatusRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateHotelStatusRequestCreation(propertyIdentifier, updateExternalHotelStatusRequestSupplier, winkVersion);
    }
    /**
     * Update property profile
     * Update basic property information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyProfileRequestSupplier The upsertPropertyProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePropertyProfileRequestCreation(String propertyIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertPropertyProfileRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertPropertyProfileRequestSupplier' is set
        if (upsertPropertyProfileRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertPropertyProfileRequestSupplier' when calling updatePropertyProfile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/profile", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property profile
     * Update basic property information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyProfileRequestSupplier The upsertPropertyProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updatePropertyProfile(String propertyIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updatePropertyProfileRequestCreation(propertyIdentifier, upsertPropertyProfileRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update property profile
     * Update basic property information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyProfileRequestSupplier The upsertPropertyProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updatePropertyProfileWithHttpInfo(String propertyIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updatePropertyProfileRequestCreation(propertyIdentifier, upsertPropertyProfileRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update property profile
     * Update basic property information
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertPropertyProfileRequestSupplier The upsertPropertyProfileRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updatePropertyProfileWithResponseSpec(String propertyIdentifier, UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updatePropertyProfileRequestCreation(propertyIdentifier, upsertPropertyProfileRequestSupplier, winkVersion);
    }
    /**
     * Update Reservations Desk
     * Manage reservation desk hours of operation and contact details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update important request for this property identifier
     * @param upsertReservationsDeskRequestSupplier The upsertReservationsDeskRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateReservationsDeskRequestCreation(String propertyIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertReservationsDeskRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateReservationsDesk", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertReservationsDeskRequestSupplier' is set
        if (upsertReservationsDeskRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertReservationsDeskRequestSupplier' when calling updateReservationsDesk", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/reservations-desk", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Reservations Desk
     * Manage reservation desk hours of operation and contact details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update important request for this property identifier
     * @param upsertReservationsDeskRequestSupplier The upsertReservationsDeskRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateReservationsDesk(String propertyIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateReservationsDeskRequestCreation(propertyIdentifier, upsertReservationsDeskRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Reservations Desk
     * Manage reservation desk hours of operation and contact details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update important request for this property identifier
     * @param upsertReservationsDeskRequestSupplier The upsertReservationsDeskRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateReservationsDeskWithHttpInfo(String propertyIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateReservationsDeskRequestCreation(propertyIdentifier, upsertReservationsDeskRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Reservations Desk
     * Manage reservation desk hours of operation and contact details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update important request for this property identifier
     * @param upsertReservationsDeskRequestSupplier The upsertReservationsDeskRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateReservationsDeskWithResponseSpec(String propertyIdentifier, UpsertReservationsDeskRequestSupplier upsertReservationsDeskRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateReservationsDeskRequestCreation(propertyIdentifier, upsertReservationsDeskRequestSupplier, winkVersion);
    }
    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set amenities for this property identifier
     * @param updatePropertyAmenitiesAndServicesRequestSupplier The updatePropertyAmenitiesAndServicesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateServicesRequestCreation(String propertyIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = updatePropertyAmenitiesAndServicesRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updatePropertyAmenitiesAndServicesRequestSupplier' is set
        if (updatePropertyAmenitiesAndServicesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updatePropertyAmenitiesAndServicesRequestSupplier' when calling updateServices", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/services", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set amenities for this property identifier
     * @param updatePropertyAmenitiesAndServicesRequestSupplier The updatePropertyAmenitiesAndServicesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateServices(String propertyIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateServicesRequestCreation(propertyIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set amenities for this property identifier
     * @param updatePropertyAmenitiesAndServicesRequestSupplier The updatePropertyAmenitiesAndServicesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateServicesWithHttpInfo(String propertyIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateServicesRequestCreation(propertyIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update property services
     * Manage property amenity, accessibility and security features.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Set amenities for this property identifier
     * @param updatePropertyAmenitiesAndServicesRequestSupplier The updatePropertyAmenitiesAndServicesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateServicesWithResponseSpec(String propertyIdentifier, UpdatePropertyAmenitiesAndServicesRequestSupplier updatePropertyAmenitiesAndServicesRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateServicesRequestCreation(propertyIdentifier, updatePropertyAmenitiesAndServicesRequestSupplier, winkVersion);
    }
    /**
     * Update Property Text
     * Update localized welcome text
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertWelcomeTextRequestSupplier The upsertWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateWelcomeTextRequestCreation(String propertyIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertWelcomeTextRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertWelcomeTextRequestSupplier' is set
        if (upsertWelcomeTextRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertWelcomeTextRequestSupplier' when calling updateWelcomeText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/welcome-text", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Property Text
     * Update localized welcome text
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertWelcomeTextRequestSupplier The upsertWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateWelcomeText(String propertyIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateWelcomeTextRequestCreation(propertyIdentifier, upsertWelcomeTextRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Property Text
     * Update localized welcome text
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertWelcomeTextRequestSupplier The upsertWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateWelcomeTextWithHttpInfo(String propertyIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateWelcomeTextRequestCreation(propertyIdentifier, upsertWelcomeTextRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Property Text
     * Update localized welcome text
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update basic information for this property identifier
     * @param upsertWelcomeTextRequestSupplier The upsertWelcomeTextRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateWelcomeTextWithResponseSpec(String propertyIdentifier, UpsertWelcomeTextRequestSupplier upsertWelcomeTextRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateWelcomeTextRequestCreation(propertyIdentifier, upsertWelcomeTextRequestSupplier, winkVersion);
    }
    /**
     * Upload General Manager Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Add general manager profile picture for this property identifier
     * @param _file The _file parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadGeneralManagerProfilePictureRequestCreation(String propertyIdentifier, File _file) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new WebClientResponseException("Missing the required parameter '_file' when calling uploadGeneralManagerProfilePicture", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (_file != null)
            formParams.add("file", new FileSystemResource(_file));

        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/multimedia/general-manager/upload", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload General Manager Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Add general manager profile picture for this property identifier
     * @param _file The _file parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> uploadGeneralManagerProfilePicture(String propertyIdentifier, File _file) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return uploadGeneralManagerProfilePictureRequestCreation(propertyIdentifier, _file).bodyToMono(localVarReturnType);
    }

    /**
     * Upload General Manager Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Add general manager profile picture for this property identifier
     * @param _file The _file parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> uploadGeneralManagerProfilePictureWithHttpInfo(String propertyIdentifier, File _file) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return uploadGeneralManagerProfilePictureRequestCreation(propertyIdentifier, _file).toEntity(localVarReturnType);
    }

    /**
     * Upload General Manager Image
     * Uploads videos and/or images to the general manager profile associated with hotel identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>207</b> - Multi-Status
     * @param propertyIdentifier Add general manager profile picture for this property identifier
     * @param _file The _file parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadGeneralManagerProfilePictureWithResponseSpec(String propertyIdentifier, File _file) throws WebClientResponseException {
        return uploadGeneralManagerProfilePictureRequestCreation(propertyIdentifier, _file);
    }
}
