/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Extranet Property API This part of the documentation concerns itself with basic property management. It can:  1. Property: List existing properties. Manage property status. Change name and similar. 2. Notification: Read internal messages sent from Wink to your properties. 3. Announcement: Show pertinent messages to travelers in a pop-up window. 4. Geo-location: Set property geo-location. 5. Green Index: Answer eco-related questions regarding the property's recycling practices and much more. 6. Lifestyles: Manage lifestyles the property caters to. 7. Photos / Videos: Manage property media. 8. Policy: Manage property policy. I.e. Children, pets, wi-fi, parking etc. 9. Reputation: Manage awards, online / offline ratings etc. 10. Services: Manage property amenities. 11. Social media: Manage property social media networks. 12. Welcome text: Manage property descriptions  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.property.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertPropertyProfileRequestSupplier
 */
@JsonPropertyOrder({
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_STARS,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_HOTEL_CHAIN,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_HOTEL_BRAND,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_WHEN_BUILT,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_WEBSITE,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_LICENSE_NUMBER,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_NUMBER_OF_ROOMS,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_LOCATION_CATEGORY,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_SEGMENT_CATEGORY,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_HOTEL_CATEGORY,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_ARCHITECTURAL_STYLE
})
@JsonTypeName("UpsertPropertyProfileRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:04:02.243083328+07:00[Asia/Bangkok]")
public class UpsertPropertyProfileRequestSupplier {
  public static final String JSON_PROPERTY_STARS = "stars";
  private Integer stars;

  public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
  private String hotelChain;

  public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
  private String hotelBrand;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_WEBSITE = "website";
  private String website;

  public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
  private String licenseNumber;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private Integer numberOfRooms;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public UpsertPropertyProfileRequestSupplier() {
  }

  public UpsertPropertyProfileRequestSupplier stars(Integer stars) {
    
    this.stars = stars;
    return this;
  }

   /**
   * Hotel star rating.
   * minimum: 0
   * maximum: 6
   * @return stars
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getStars() {
    return stars;
  }


  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStars(Integer stars) {
    this.stars = stars;
  }


  public UpsertPropertyProfileRequestSupplier hotelChain(String hotelChain) {
    
    this.hotelChain = hotelChain;
    return this;
  }

   /**
   * Hotel chain name if property is part of that chain.
   * @return hotelChain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChain() {
    return hotelChain;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChain(String hotelChain) {
    this.hotelChain = hotelChain;
  }


  public UpsertPropertyProfileRequestSupplier hotelBrand(String hotelBrand) {
    
    this.hotelBrand = hotelBrand;
    return this;
  }

   /**
   * Hotel brand name if property is part of that brand.
   * @return hotelBrand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelBrand() {
    return hotelBrand;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelBrand(String hotelBrand) {
    this.hotelBrand = hotelBrand;
  }


  public UpsertPropertyProfileRequestSupplier whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public UpsertPropertyProfileRequestSupplier website(String website) {
    
    this.website = website;
    return this;
  }

   /**
   * Property&#39;s brand.com website.
   * @return website
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWebsite() {
    return website;
  }


  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebsite(String website) {
    this.website = website;
  }


  public UpsertPropertyProfileRequestSupplier licenseNumber(String licenseNumber) {
    
    this.licenseNumber = licenseNumber;
    return this;
  }

   /**
   * If the property has a valid license number to run a hotel in their country, add it here.
   * @return licenseNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicenseNumber() {
    return licenseNumber;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseNumber(String licenseNumber) {
    this.licenseNumber = licenseNumber;
  }


  public UpsertPropertyProfileRequestSupplier numberOfRooms(Integer numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Number of rooms / keys for property
   * minimum: 1
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNumberOfRooms(Integer numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public UpsertPropertyProfileRequestSupplier locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public UpsertPropertyProfileRequestSupplier segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public UpsertPropertyProfileRequestSupplier hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public UpsertPropertyProfileRequestSupplier architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier = (UpsertPropertyProfileRequestSupplier) o;
    return Objects.equals(this.stars, upsertPropertyProfileRequestSupplier.stars) &&
        Objects.equals(this.hotelChain, upsertPropertyProfileRequestSupplier.hotelChain) &&
        Objects.equals(this.hotelBrand, upsertPropertyProfileRequestSupplier.hotelBrand) &&
        Objects.equals(this.whenBuilt, upsertPropertyProfileRequestSupplier.whenBuilt) &&
        Objects.equals(this.website, upsertPropertyProfileRequestSupplier.website) &&
        Objects.equals(this.licenseNumber, upsertPropertyProfileRequestSupplier.licenseNumber) &&
        Objects.equals(this.numberOfRooms, upsertPropertyProfileRequestSupplier.numberOfRooms) &&
        Objects.equals(this.locationCategory, upsertPropertyProfileRequestSupplier.locationCategory) &&
        Objects.equals(this.segmentCategory, upsertPropertyProfileRequestSupplier.segmentCategory) &&
        Objects.equals(this.hotelCategory, upsertPropertyProfileRequestSupplier.hotelCategory) &&
        Objects.equals(this.architecturalStyle, upsertPropertyProfileRequestSupplier.architecturalStyle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stars, hotelChain, hotelBrand, whenBuilt, website, licenseNumber, numberOfRooms, locationCategory, segmentCategory, hotelCategory, architecturalStyle);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertPropertyProfileRequestSupplier {\n");
    sb.append("    stars: ").append(toIndentedString(stars)).append("\n");
    sb.append("    hotelChain: ").append(toIndentedString(hotelChain)).append("\n");
    sb.append("    hotelBrand: ").append(toIndentedString(hotelBrand)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("    licenseNumber: ").append(toIndentedString(licenseNumber)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

