/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.property.invoker.ApiClient;
import travel.wink.sdk.extranet.property.model.HotelViewSupplier;
import travel.wink.sdk.extranet.property.model.TravelInventoryRecognitionSupplier;
import travel.wink.sdk.extranet.property.model.UpsertRecognitionSupplier;

public class RecognitionApi {
    private ApiClient apiClient;

    public RecognitionApi() {
        this(new ApiClient());
    }

    @Autowired
    public RecognitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRecognitionRequestCreation(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRecognitionSupplier postBody = upsertRecognitionSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRecognitionSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRecognitionSupplier' when calling createRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/recognition", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> createRecognition(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.createRecognitionRequestCreation(propertyIdentifier, upsertRecognitionSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> createRecognitionWithHttpInfo(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.createRecognitionRequestCreation(propertyIdentifier, upsertRecognitionSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRecognitionWithResponseSpec(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        return this.createRecognitionRequestCreation(propertyIdentifier, upsertRecognitionSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRecognitionRequestCreation(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> removeRecognition(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.removeRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> removeRecognitionWithHttpInfo(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.removeRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRecognitionWithResponseSpec(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRecognitionRequestCreation(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TravelInventoryRecognitionSupplier> showRecognition(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.showRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TravelInventoryRecognitionSupplier>> showRecognitionWithHttpInfo(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.showRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRecognitionWithResponseSpec(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRecognitionsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRecognitions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/recognition/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<TravelInventoryRecognitionSupplier> showRecognitions(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.showRecognitionsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<TravelInventoryRecognitionSupplier>>> showRecognitionsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.showRecognitionsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRecognitionsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRecognitionsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRecognitionsByCategoryRequestCreation(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("category", category);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/recognition/{category}/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<TravelInventoryRecognitionSupplier> showRecognitionsByCategory(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.showRecognitionsByCategoryRequestCreation(propertyIdentifier, category, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<TravelInventoryRecognitionSupplier>>> showRecognitionsByCategoryWithHttpInfo(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>(this){};
        return this.showRecognitionsByCategoryRequestCreation(propertyIdentifier, category, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRecognitionsByCategoryWithResponseSpec(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRecognitionsByCategoryRequestCreation(propertyIdentifier, category, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRecognitionRequestCreation(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRecognitionSupplier postBody = upsertRecognitionSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRecognitionSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRecognitionSupplier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/inventory/recognition/{recognitionIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateRecognition(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, upsertRecognitionSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateRecognitionWithHttpInfo(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, upsertRecognitionSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRecognitionWithResponseSpec(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, upsertRecognitionSupplier, winkVersion);
    }
}

