/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.property.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.property.invoker.ApiClient;
import travel.wink.sdk.extranet.property.model.AnnouncementViewSupplier;
import travel.wink.sdk.extranet.property.model.UpsertAnnouncementRequestSupplier;

public class AnnouncementApi {
    private ApiClient apiClient;

    public AnnouncementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnnouncementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAnnouncementRequestCreation(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertAnnouncementRequestSupplier postBody = upsertAnnouncementRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAnnouncementRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAnnouncementRequestSupplier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> createAnnouncement(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.createAnnouncementRequestCreation(propertyIdentifier, upsertAnnouncementRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> createAnnouncementWithHttpInfo(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.createAnnouncementRequestCreation(propertyIdentifier, upsertAnnouncementRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAnnouncementWithResponseSpec(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createAnnouncementRequestCreation(propertyIdentifier, upsertAnnouncementRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeAnnouncementRequestCreation(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/{announcementIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> removeAnnouncement(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.removeAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> removeAnnouncementWithHttpInfo(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.removeAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAnnouncementWithResponseSpec(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAnnouncementRequestCreation(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/{announcementIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> showAnnouncement(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.showAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> showAnnouncementWithHttpInfo(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.showAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnnouncementWithResponseSpec(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAnnouncementsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAnnouncements", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AnnouncementViewSupplier> showAnnouncements(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.showAnnouncementsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AnnouncementViewSupplier>>> showAnnouncementsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.showAnnouncementsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAnnouncementsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAnnouncementsRequestCreation(propertyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAnnouncementRequestCreation(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertAnnouncementRequestSupplier postBody = upsertAnnouncementRequestSupplier;
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAnnouncementRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAnnouncementRequestSupplier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/{announcementIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AnnouncementViewSupplier> updateAnnouncement(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.updateAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AnnouncementViewSupplier>> updateAnnouncementWithHttpInfo(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>(this){};
        return this.updateAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAnnouncementWithResponseSpec(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion);
    }
}

