package travel.wink.sdk.extranet.property.api;

import travel.wink.sdk.extranet.property.invoker.ApiClient;

import travel.wink.sdk.extranet.property.model.AnnouncementViewSupplier;
import travel.wink.sdk.extranet.property.model.GenericErrorMessage;
import travel.wink.sdk.extranet.property.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.property.model.ShowRecognition400Response;
import travel.wink.sdk.extranet.property.model.UpsertAnnouncementRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:59:12.975377331+07:00[Asia/Bangkok]")
public class AnnouncementApi {
    private ApiClient apiClient;

    public AnnouncementApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnnouncementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create announcement for this property identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAnnouncementRequestCreation(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAnnouncementRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAnnouncementRequestSupplier' is set
        if (upsertAnnouncementRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAnnouncementRequestSupplier' when calling createAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create announcement for this property identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementViewSupplier> createAnnouncement(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return createAnnouncementRequestCreation(propertyIdentifier, upsertAnnouncementRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create announcement for this property identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AnnouncementViewSupplier>> createAnnouncementWithHttpInfo(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return createAnnouncementRequestCreation(propertyIdentifier, upsertAnnouncementRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Announcement
     * Create a new announcement
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create announcement for this property identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAnnouncementWithResponseSpec(String propertyIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createAnnouncementRequestCreation(propertyIdentifier, upsertAnnouncementRequestSupplier, winkVersion);
    }
    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove announcement for this property identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAnnouncementRequestCreation(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling removeAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/{announcementIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove announcement for this property identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeAnnouncement(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove announcement for this property identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeAnnouncementWithHttpInfo(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Announcement
     * Delete an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Remove announcement for this property identifier
     * @param announcementIdentifier Remove announcement with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAnnouncementWithResponseSpec(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept);
    }
    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcement for this property identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnnouncementRequestCreation(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling showAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/{announcementIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcement for this property identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementViewSupplier> showAnnouncement(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcement for this property identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AnnouncementViewSupplier>> showAnnouncementWithHttpInfo(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Announcement
     * Retrieve an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcement for this property identifier
     * @param announcementIdentifier Show data for this announcement identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnnouncementWithResponseSpec(String propertyIdentifier, String announcementIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, winkVersion, accept);
    }
    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcements for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAnnouncementsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showAnnouncements", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcements for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AnnouncementViewSupplier> showAnnouncements(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcements for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;AnnouncementViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<AnnouncementViewSupplier>>> showAnnouncementsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return showAnnouncementsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Announcements
     * Retrieve list of announcements
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show announcements for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAnnouncementsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAnnouncementsRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update announcement for this property identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAnnouncementRequestCreation(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAnnouncementRequestSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'announcementIdentifier' is set
        if (announcementIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'announcementIdentifier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAnnouncementRequestSupplier' is set
        if (upsertAnnouncementRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAnnouncementRequestSupplier' when calling updateAnnouncement", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("announcementIdentifier", announcementIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/announcement/{announcementIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update announcement for this property identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return AnnouncementViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AnnouncementViewSupplier> updateAnnouncement(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return updateAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update announcement for this property identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AnnouncementViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AnnouncementViewSupplier>> updateAnnouncementWithHttpInfo(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AnnouncementViewSupplier> localVarReturnType = new ParameterizedTypeReference<AnnouncementViewSupplier>() {};
        return updateAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Announcement
     * Update an announcement by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update announcement for this property identifier
     * @param announcementIdentifier Update announcement with this identifier
     * @param upsertAnnouncementRequestSupplier The upsertAnnouncementRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAnnouncementWithResponseSpec(String propertyIdentifier, String announcementIdentifier, UpsertAnnouncementRequestSupplier upsertAnnouncementRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateAnnouncementRequestCreation(propertyIdentifier, announcementIdentifier, upsertAnnouncementRequestSupplier, winkVersion);
    }
}
