package travel.wink.sdk.extranet.property.api;

import travel.wink.sdk.extranet.property.invoker.ApiClient;

import travel.wink.sdk.extranet.property.model.GenericErrorMessage;
import travel.wink.sdk.extranet.property.model.HotelViewSupplier;
import travel.wink.sdk.extranet.property.model.PropertyPolicySupplier;
import travel.wink.sdk.extranet.property.model.ShowRecognition400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:59:12.975377331+07:00[Asia/Bangkok]")
public class PolicyApi {
    private ApiClient apiClient;

    public PolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public PolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create property policy for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createPolicyRequestCreation(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyPolicySupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyPolicySupplier' is set
        if (propertyPolicySupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicySupplier' when calling createPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/policy/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create property policy for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> createPolicy(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return createPolicyRequestCreation(propertyIdentifier, propertyPolicySupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create property policy for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> createPolicyWithHttpInfo(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return createPolicyRequestCreation(propertyIdentifier, propertyPolicySupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create property policy
     * Creates the initial property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Create property policy for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createPolicyWithResponseSpec(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        return createPolicyRequestCreation(propertyIdentifier, propertyPolicySupplier, winkVersion);
    }
    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property policy for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyPolicyRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showPropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/policy/property", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property policy for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PropertyPolicySupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PropertyPolicySupplier> showPropertyPolicy(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return showPropertyPolicyRequestCreation(propertyIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property policy for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PropertyPolicySupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PropertyPolicySupplier>> showPropertyPolicyWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyPolicySupplier> localVarReturnType = new ParameterizedTypeReference<PropertyPolicySupplier>() {};
        return showPropertyPolicyRequestCreation(propertyIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show property policy
     * Returns property policy for hotel
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Retrieve property policy for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyPolicyWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyPolicyRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update property policy record for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updatePropertyPolicyRequestCreation(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = propertyPolicySupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'propertyPolicySupplier' is set
        if (propertyPolicySupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyPolicySupplier' when calling updatePropertyPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/policy/property", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update property policy record for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updatePropertyPolicy(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updatePropertyPolicyRequestCreation(propertyIdentifier, propertyPolicySupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update property policy record for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updatePropertyPolicyWithHttpInfo(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updatePropertyPolicyRequestCreation(propertyIdentifier, propertyPolicySupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update property policy
     * Update property policy record for the hotel.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update property policy record for this property identifier
     * @param propertyPolicySupplier The propertyPolicySupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updatePropertyPolicyWithResponseSpec(String propertyIdentifier, PropertyPolicySupplier propertyPolicySupplier, String winkVersion) throws WebClientResponseException {
        return updatePropertyPolicyRequestCreation(propertyIdentifier, propertyPolicySupplier, winkVersion);
    }
}
