package travel.wink.sdk.extranet.property.api;

import travel.wink.sdk.extranet.property.invoker.ApiClient;

import travel.wink.sdk.extranet.property.model.GenericErrorMessage;
import travel.wink.sdk.extranet.property.model.HotelViewSupplier;
import travel.wink.sdk.extranet.property.model.ShowRecognition400Response;
import travel.wink.sdk.extranet.property.model.TravelInventoryRecognitionSupplier;
import travel.wink.sdk.extranet.property.model.UpsertRecognitionSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:59:12.975377331+07:00[Asia/Bangkok]")
public class RecognitionApi {
    private ApiClient apiClient;

    public RecognitionApi() {
        this(new ApiClient());
    }

    @Autowired
    public RecognitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Recognition
     * Create a new request
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Associate new request record with this property identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRecognitionRequestCreation(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRecognitionSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling createRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRecognitionSupplier' is set
        if (upsertRecognitionSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRecognitionSupplier' when calling createRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/recognition", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Recognition
     * Create a new request
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Associate new request record with this property identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> createRecognition(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return createRecognitionRequestCreation(propertyIdentifier, upsertRecognitionSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Recognition
     * Create a new request
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Associate new request record with this property identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> createRecognitionWithHttpInfo(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return createRecognitionRequestCreation(propertyIdentifier, upsertRecognitionSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Recognition
     * Create a new request
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param propertyIdentifier Associate new request record with this property identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createRecognitionWithResponseSpec(String propertyIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        return createRecognitionRequestCreation(propertyIdentifier, upsertRecognitionSupplier, winkVersion);
    }
    /**
     * Delete Recognition
     * Delete a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete recognition record for property with this property identifier
     * @param recognitionIdentifier Delete recognition with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRecognitionRequestCreation(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognitionIdentifier' is set
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling removeRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/recognition/{recognitionIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Recognition
     * Delete a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete recognition record for property with this property identifier
     * @param recognitionIdentifier Delete recognition with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> removeRecognition(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return removeRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Recognition
     * Delete a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete recognition record for property with this property identifier
     * @param recognitionIdentifier Delete recognition with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> removeRecognitionWithHttpInfo(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return removeRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Recognition
     * Delete a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Delete recognition record for property with this property identifier
     * @param recognitionIdentifier Delete recognition with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRecognitionWithResponseSpec(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept);
    }
    /**
     * Show Recognition
     * Retrieve a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show recognition belonging to this property identifier
     * @param recognitionIdentifier Show recognition associated with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return TravelInventoryRecognitionSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRecognitionRequestCreation(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognitionIdentifier' is set
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling showRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/recognition/{recognitionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Recognition
     * Retrieve a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show recognition belonging to this property identifier
     * @param recognitionIdentifier Show recognition associated with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return TravelInventoryRecognitionSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<TravelInventoryRecognitionSupplier> showRecognition(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return showRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Recognition
     * Retrieve a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show recognition belonging to this property identifier
     * @param recognitionIdentifier Show recognition associated with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;TravelInventoryRecognitionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<TravelInventoryRecognitionSupplier>> showRecognitionWithHttpInfo(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return showRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Recognition
     * Retrieve a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show recognition belonging to this property identifier
     * @param recognitionIdentifier Show recognition associated with this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRecognitionWithResponseSpec(String propertyIdentifier, String recognitionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, winkVersion, accept);
    }
    /**
     * Show Recognitions
     * Retrieve a list of all recognitions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;TravelInventoryRecognitionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRecognitionsRequestCreation(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRecognitions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/recognition/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Recognitions
     * Retrieve a list of all recognitions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;TravelInventoryRecognitionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<TravelInventoryRecognitionSupplier> showRecognitions(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return showRecognitionsRequestCreation(propertyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Recognitions
     * Retrieve a list of all recognitions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;TravelInventoryRecognitionSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<TravelInventoryRecognitionSupplier>>> showRecognitionsWithHttpInfo(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return showRecognitionsRequestCreation(propertyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Recognitions
     * Retrieve a list of all recognitions for property
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRecognitionsWithResponseSpec(String propertyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRecognitionsRequestCreation(propertyIdentifier, winkVersion, accept);
    }
    /**
     * Show Recognition by Category
     * Retrieve list recognitions by category
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param category Filter list of recognitions by category
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;TravelInventoryRecognitionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRecognitionsByCategoryRequestCreation(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'category' is set
        if (category == null) {
            throw new WebClientResponseException("Missing the required parameter 'category' when calling showRecognitionsByCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("category", category);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/recognition/{category}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Recognition by Category
     * Retrieve list recognitions by category
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param category Filter list of recognitions by category
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;TravelInventoryRecognitionSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<TravelInventoryRecognitionSupplier> showRecognitionsByCategory(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return showRecognitionsByCategoryRequestCreation(propertyIdentifier, category, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Recognition by Category
     * Retrieve list recognitions by category
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param category Filter list of recognitions by category
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;TravelInventoryRecognitionSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<TravelInventoryRecognitionSupplier>>> showRecognitionsByCategoryWithHttpInfo(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<TravelInventoryRecognitionSupplier> localVarReturnType = new ParameterizedTypeReference<TravelInventoryRecognitionSupplier>() {};
        return showRecognitionsByCategoryRequestCreation(propertyIdentifier, category, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Recognition by Category
     * Retrieve list recognitions by category
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Show list of recognitions for this property identifier
     * @param category Filter list of recognitions by category
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRecognitionsByCategoryWithResponseSpec(String propertyIdentifier, String category, String winkVersion, String accept) throws WebClientResponseException {
        return showRecognitionsByCategoryRequestCreation(propertyIdentifier, category, winkVersion, accept);
    }
    /**
     * Update Recognition
     * Update a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update recognition record associated with this property identifier
     * @param recognitionIdentifier Update recognition with this identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRecognitionRequestCreation(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRecognitionSupplier;
        // verify the required parameter 'propertyIdentifier' is set
        if (propertyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'recognitionIdentifier' is set
        if (recognitionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'recognitionIdentifier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRecognitionSupplier' is set
        if (upsertRecognitionSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRecognitionSupplier' when calling updateRecognition", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("propertyIdentifier", propertyIdentifier);
        pathParams.put("recognitionIdentifier", recognitionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return apiClient.invokeAPI("/api/property/{propertyIdentifier}/recognition/{recognitionIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Recognition
     * Update a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update recognition record associated with this property identifier
     * @param recognitionIdentifier Update recognition with this identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return HotelViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelViewSupplier> updateRecognition(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, upsertRecognitionSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Recognition
     * Update a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update recognition record associated with this property identifier
     * @param recognitionIdentifier Update recognition with this identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelViewSupplier>> updateRecognitionWithHttpInfo(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>() {};
        return updateRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, upsertRecognitionSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Recognition
     * Update a recognition by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param propertyIdentifier Update recognition record associated with this property identifier
     * @param recognitionIdentifier Update recognition with this identifier
     * @param upsertRecognitionSupplier The upsertRecognitionSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRecognitionWithResponseSpec(String propertyIdentifier, String recognitionIdentifier, UpsertRecognitionSupplier upsertRecognitionSupplier, String winkVersion) throws WebClientResponseException {
        return updateRecognitionRequestCreation(propertyIdentifier, recognitionIdentifier, upsertRecognitionSupplier, winkVersion);
    }
}
